/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser.actions;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.ProjectBrowserAction;
import jp.sourceforge.concierge.widget.TextInputDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class RenameAction
extends ProjectBrowserAction {
    public RenameAction(TableViewer pv, TableViewer cv) {
        super(pv, cv);
    }

    public void run() {
        ArrayList<Document> docs = this.getSelection();
        if (docs.size() == 0) {
            return;
        }
        String path = DataDomImpl.getFilePath((Document)docs.get(0));
        File oldf = new File(path);
        if (!oldf.exists()) {
            return;
        }
        FileInputDialog tid = new FileInputDialog(this.projectview.getControl().getShell(), "Rename file", "Enter new filename");
        if (tid.open() != 0) {
            return;
        }
        tid.getValue();
    }

    private class FileInputDialog
    extends TextInputDialog {
        private String TMPDIR;

        public FileInputDialog(Shell shell, String t, String m) {
            super(shell, t, m);
            this.TMPDIR = System.getProperty("java.io.tmpdir");
        }

        public boolean isInputError() {
            String t = this.textBox.getText().trim();
            if (t.length() == 0) {
                return false;
            }
            File f = new File(String.valueOf(this.TMPDIR) + File.separator + t);
            try {
                if (f.exists()) {
                    f.delete();
                }
                return !f.createNewFile();
            }
            catch (Throwable throwable) {
                return true;
            }
        }
    }
}

