/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Observable;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.Referable;

public abstract class StoredObject
extends Observable
implements Referable,
Insertable {
    public static final int MAXIMUM_OBJECT_SIZE = 7612;
    public static final int TYPE_OFFSET = 0;
    public static final int TYPE_LENGTH = 2;
    protected ObjectStore store;
    protected ObjectAddress address;
    protected int referenceCount;
    protected int type;

    protected StoredObject() {
        this.type = this.getRequiredType();
    }

    protected StoredObject(Field f, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        if (f.length() < this.getMinimumSize()) {
            throw new ObjectStoreException(24);
        }
        if (f.length() > this.getMaximumSize()) {
            throw new ObjectStoreException(24);
        }
        this.extractValues(f);
        this.setStore(store);
        this.setAddress(address);
    }

    public abstract String toString();

    protected abstract int getRequiredType();

    @Override
    public final byte[] toByteArray() {
        Field f = new Field(this.length());
        this.insertValues(f);
        return f.get();
    }

    @Override
    public final int addReference() {
        ++this.referenceCount;
        return this.referenceCount;
    }

    @Override
    public final int removeReference() {
        if (this.referenceCount > 0) {
            --this.referenceCount;
        }
        return this.referenceCount;
    }

    @Override
    public final boolean hasReferences() {
        return this.referenceCount > 0;
    }

    public final ObjectAddress getAddress() {
        return this.address;
    }

    public final void setStore(ObjectStore store) {
        this.store = store;
    }

    public final void setAddress(ObjectAddress address) {
        this.address = address;
    }

    protected void extractValues(Field f) throws ObjectStoreException {
        this.type = f.subfield(0, 2).getInt();
        if (this.type != this.getRequiredType()) {
            throw new ObjectStoreException(23);
        }
    }

    protected void insertValues(Field f) {
        f.subfield(0, 2).put(this.type);
    }

    protected int getMaximumSize() {
        return this.getMinimumSize();
    }

    protected int getMinimumSize() {
        return 2;
    }

    protected int length() {
        return this.getMinimumSize();
    }
}

