/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.backupmanager.actions;

import java.io.File;
import java.util.List;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.backupmanager.actions.BaseAction;
import jp.sourceforge.concierge.util.CCGFileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class RestoreAction
extends BaseAction {
    public RestoreAction(TableViewer tv) {
        super(tv);
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection)this.tableviewer.getSelection();
        List docs = sel.toList();
        if (docs.size() == 0) {
            return;
        }
        boolean success = true;
        int i = 0;
        while (i < docs.size()) {
            Document doc = (Document)docs.get(i);
            String path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc));
            if (path == null) {
                success = false;
            } else {
                File bf = new File(path);
                String origpath = DataDomImpl.getFilePath((Document)doc);
                if (origpath == null || origpath.length() == 0) {
                    success = false;
                } else {
                    File of = new File(origpath);
                    boolean exist = of.exists();
                    if (!(exist && !MessageDialog.openConfirm((Shell)this.tableviewer.getControl().getShell(), (String)"Restore confirm", (String)("Original file " + origpath + " exists. Restore anyway?")) || CCGFileUtils.copy((File)bf, (File)of))) {
                        success = false;
                    }
                }
            }
            ++i;
        }
        if (!success) {
            MessageDialog.openWarning((Shell)this.tableviewer.getControl().getShell(), (String)"Restore warning", (String)"Some items were not restored.");
        }
        this.tableviewer.update(docs.toArray(), null);
    }
}

