/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.Map;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.LabelRetargetAction;
import org.eclipse.ui.actions.NewWizardDropDownAction;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.CloseAllSavedAction;
import org.eclipse.ui.internal.IntroAction;
import org.eclipse.ui.internal.LockToolBarAction;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.internal.OpenPreferencesAction;
import org.eclipse.ui.internal.ResetPerspectiveAction;
import org.eclipse.ui.internal.SaveAction;
import org.eclipse.ui.internal.SaveAllAction;
import org.eclipse.ui.internal.SaveAsAction;
import org.eclipse.ui.internal.SavePerspectiveAction;
import org.eclipse.ui.internal.ToggleEditorsVisibilityAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.actions.DynamicHelpAction;
import org.eclipse.ui.internal.actions.HelpContentsAction;
import org.eclipse.ui.internal.actions.HelpSearchAction;
import org.eclipse.ui.services.IServiceLocator;

public abstract class ActionFactory {
    public static final ActionFactory ABOUT = new ActionFactory("about"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.help.aboutAction", window);
            action.setId(this.getId());
            IProduct product = Platform.getProduct();
            String productName = null;
            if (product != null) {
                productName = product.getName();
            }
            if (productName == null) {
                productName = "";
            }
            action.setText(NLS.bind((String)WorkbenchMessages.AboutAction_text, (Object)productName));
            action.setToolTipText(NLS.bind((String)WorkbenchMessages.AboutAction_toolTip, (Object)productName));
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.about_action_context");
            return action;
        }
    };
    public static final ActionFactory ACTIVATE_EDITOR = new ActionFactory("activateEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.activateEditor", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ActivateEditorAction_text);
            action.setToolTipText(WorkbenchMessages.ActivateEditorAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory BACK = new ActionFactory("back"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_back);
            action.setToolTipText(WorkbenchMessages.Workbench_backToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.back");
            return action;
        }
    };
    public static final ActionFactory BACKWARD_HISTORY = new ActionFactory("backardHistory"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NavigationHistoryAction action = new NavigationHistoryAction(window, false);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE = new ActionFactory("close"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.close", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CloseEditorAction_text);
            action.setToolTipText(WorkbenchMessages.CloseEditorAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory CLOSE_ALL = new ActionFactory("closeAll"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.closeAll", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CloseAllAction_text);
            action.setToolTipText(WorkbenchMessages.CloseAllAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory CLOSE_OTHERS = new ActionFactory("closeOthers"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.closeOthers", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CloseOthersAction_text);
            action.setToolTipText(WorkbenchMessages.CloseOthersAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory CLOSE_ALL_PERSPECTIVES = new ActionFactory("closeAllPerspectives"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.closeAllPerspectives", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CloseAllPerspectivesAction_text);
            action.setToolTipText(WorkbenchMessages.CloseAllPerspectivesAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.close_all_pages_action_context");
            return action;
        }
    };
    public static final ActionFactory CLOSE_ALL_SAVED = new ActionFactory("closeAllSaved"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            CloseAllSavedAction action = new CloseAllSavedAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory CLOSE_PERSPECTIVE = new ActionFactory("closePerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.closePerspective", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ClosePerspectiveAction_text);
            action.setToolTipText(WorkbenchMessages.ClosePerspectiveAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.close_page_action_context");
            return action;
        }
    };
    public static final ActionFactory INTRO = new ActionFactory("intro"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            IntroAction action = new IntroAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory COPY = new ActionFactory("copy"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_copy);
            action.setToolTipText(WorkbenchMessages.Workbench_copyToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.copy");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory CUT = new ActionFactory("cut"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_cut);
            action.setToolTipText(WorkbenchMessages.Workbench_cutToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.cut");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory DELETE = new ActionFactory("delete"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_delete);
            action.setToolTipText(WorkbenchMessages.Workbench_deleteToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.delete");
            action.enableAccelerator(false);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.delete_retarget_action_context");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory EDIT_ACTION_SETS = new ActionFactory("editActionSets"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.customizePerspective", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.EditActionSetsAction_text);
            action.setToolTipText(WorkbenchMessages.EditActionSetsAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.edit_action_sets_action_context");
            return action;
        }
    };
    public static final ActionFactory EXPORT = new ActionFactory("export"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.export", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ExportResourcesAction_fileMenuText);
            action.setToolTipText(WorkbenchMessages.ExportResourcesAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.export_action_context");
            action.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_EXPORT_WIZ"));
            return action;
        }
    };
    public static final ActionFactory FIND = new ActionFactory("find"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_findReplace);
            action.setToolTipText(WorkbenchMessages.Workbench_findReplaceToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
            return action;
        }
    };
    public static final ActionFactory FORWARD = new ActionFactory("forward"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_forward);
            action.setToolTipText(WorkbenchMessages.Workbench_forwardToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.forward");
            return action;
        }
    };
    public static final ActionFactory FORWARD_HISTORY = new ActionFactory("forwardHistory"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NavigationHistoryAction action = new NavigationHistoryAction(window, true);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory GO_INTO = new ActionFactory("goInto"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_goInto);
            action.setToolTipText(WorkbenchMessages.Workbench_goIntoToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.goInto");
            return action;
        }
    };
    public static final ActionFactory IMPORT = new ActionFactory("import"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.import", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ImportResourcesAction_text);
            action.setToolTipText(WorkbenchMessages.ImportResourcesAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.import_action_context");
            action.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_IMPORT_WIZ"));
            return action;
        }
    };
    public static final ActionFactory LOCK_TOOL_BAR = new ActionFactory("lockToolBar"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LockToolBarAction action = new LockToolBarAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory MAXIMIZE = new ActionFactory("maximize"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.maximizePart", window);
            action.setId(this.getId());
            action.setToolTipText(WorkbenchMessages.MaximizePartAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.maximize_part_action_context");
            return action;
        }
    };
    public static final ActionFactory MINIMIZE = new ActionFactory("minimize"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.minimizePart", window);
            action.setId(this.getId());
            action.setToolTipText(WorkbenchMessages.MinimizePartAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.minimize_part_action_context");
            return action;
        }
    };
    public static final ActionFactory MOVE = new ActionFactory("move"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_move);
            action.setToolTipText(WorkbenchMessages.Workbench_moveToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.move");
            return action;
        }
    };
    public static final ActionFactory NEW = new ActionFactory("new"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.newWizard", window);
            action.setId(this.getId());
            ISharedImages images = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
            action.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
            action.setText(WorkbenchMessages.NewWizardAction_text);
            action.setToolTipText(WorkbenchMessages.NewWizardAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.new_action_context");
            return action;
        }
    };
    public static final ActionFactory NEW_WIZARD_DROP_DOWN = new ActionFactory("newWizardDropDown"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            NewWizardDropDownAction action = new NewWizardDropDownAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory NEXT = new ActionFactory("next"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_next);
            action.setToolTipText(WorkbenchMessages.Workbench_nextToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.next");
            return action;
        }
    };
    public static final ActionFactory NEXT_EDITOR = new ActionFactory("nextEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.nextEditor", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CycleEditorAction_next_text);
            action.setToolTipText(WorkbenchMessages.CycleEditorAction_next_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_editor_forward_action_context");
            return action;
        }
    };
    public static final ActionFactory NEXT_PART = new ActionFactory("nextPart"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.nextView", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CyclePartAction_next_text);
            action.setToolTipText(WorkbenchMessages.CyclePartAction_next_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_part_forward_action_context");
            return action;
        }
    };
    public static final ActionFactory NEXT_PERSPECTIVE = new ActionFactory("nextPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.nextPerspective", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CyclePerspectiveAction_next_text);
            action.setToolTipText(WorkbenchMessages.CyclePerspectiveAction_next_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_perspective_forward_action_context");
            return action;
        }
    };
    public static final ActionFactory OPEN_NEW_WINDOW = new ActionFactory("openNewWindow"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.newWindow", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.OpenInNewWindowAction_text);
            action.setToolTipText(WorkbenchMessages.OpenInNewWindowAction_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.open_new_window_action_context");
            return action;
        }
    };
    public static final ActionFactory PASTE = new ActionFactory("paste"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_paste);
            action.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.paste");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory PREFERENCES = new ActionFactory("preferences"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            OpenPreferencesAction action = new OpenPreferencesAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory PREVIOUS = new ActionFactory("previous"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_previous);
            action.setToolTipText(WorkbenchMessages.Workbench_previousToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.previous");
            return action;
        }
    };
    public static final ActionFactory PREVIOUS_EDITOR = new ActionFactory("previousEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.previousEditor", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CycleEditorAction_prev_text);
            action.setToolTipText(WorkbenchMessages.CycleEditorAction_prev_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_editor_backward_action_context");
            return action;
        }
    };
    public static final ActionFactory PREVIOUS_PART = new ActionFactory("previousPart"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.previousView", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CyclePartAction_prev_text);
            action.setToolTipText(WorkbenchMessages.CyclePartAction_prev_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_part_backward_action_context");
            return action;
        }
    };
    public static final ActionFactory PREVIOUS_PERSPECTIVE = new ActionFactory("previousPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.previousPerspective", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.CyclePerspectiveAction_prev_text);
            action.setToolTipText(WorkbenchMessages.CyclePerspectiveAction_prev_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.cycle_perspective_backward_action_context");
            return action;
        }
    };
    public static final ActionFactory PRINT = new ActionFactory("print"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_print);
            action.setToolTipText(WorkbenchMessages.Workbench_printToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.print");
            action.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT"));
            action.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory PROPERTIES = new ActionFactory("properties"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_properties);
            action.setToolTipText(WorkbenchMessages.Workbench_propertiesToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.properties");
            return action;
        }
    };
    public static final ActionFactory QUIT = new ActionFactory("quit"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.file.exit", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.Exit_text);
            action.setToolTipText(WorkbenchMessages.Exit_toolTip);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.quit_action_context");
            return action;
        }
    };
    public static final ActionFactory REDO = new ActionFactory("redo"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_redo);
            action.setToolTipText(WorkbenchMessages.Workbench_redoToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.redo");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory REFRESH = new ActionFactory("refresh"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_refresh);
            action.setToolTipText(WorkbenchMessages.Workbench_refreshToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.refresh");
            return action;
        }
    };
    public static final ActionFactory RENAME = new ActionFactory("rename"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_rename);
            action.setToolTipText(WorkbenchMessages.Workbench_renameToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.rename");
            return action;
        }
    };
    public static final ActionFactory RESET_PERSPECTIVE = new ActionFactory("resetPerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ResetPerspectiveAction action = new ResetPerspectiveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory REVERT = new ActionFactory("revert"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_revert);
            action.setToolTipText(WorkbenchMessages.Workbench_revertToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.file.revert");
            return action;
        }
    };
    public static final ActionFactory SAVE = new ActionFactory("save"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SaveAction action = new SaveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SAVE_ALL = new ActionFactory("saveAll"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SaveAllAction action = new SaveAllAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SAVE_AS = new ActionFactory("saveAs"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SaveAsAction action = new SaveAsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SAVE_PERSPECTIVE = new ActionFactory("savePerspective"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SavePerspectiveAction action = new SavePerspectiveAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SELECT_ALL = new ActionFactory("selectAll"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            RetargetAction action = new RetargetAction(this.getId(), WorkbenchMessages.Workbench_selectAll);
            action.setToolTipText(WorkbenchMessages.Workbench_selectAllToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
            return action;
        }
    };
    public static final ActionFactory SHOW_EDITOR = new ActionFactory("showEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ToggleEditorsVisibilityAction action = new ToggleEditorsVisibilityAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory SHOW_OPEN_EDITORS = new ActionFactory("showOpenEditors"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.switchToEditor", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.WorkbenchEditorsAction_label);
            window.getWorkbench().getHelpSystem().setHelp(action, "org.eclipse.ui.workbench_editors_action_context");
            return action;
        }
    };
    public static final ActionFactory SHOW_WORKBOOK_EDITORS = new ActionFactory("showWorkBookEditors"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.openEditorDropDown", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.WorkbookEditorsAction_label);
            return action;
        }
    };
    public static final ActionFactory SHOW_QUICK_ACCESS = new ActionFactory("showQuickAccess"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.quickAccess", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.QuickAccessAction_text);
            action.setToolTipText(WorkbenchMessages.QuickAccessAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory SHOW_PART_PANE_MENU = new ActionFactory("showPartPaneMenu"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.showSystemMenu", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ShowPartPaneMenuAction_text);
            action.setToolTipText(WorkbenchMessages.ShowPartPaneMenuAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory SHOW_VIEW_MENU = new ActionFactory("showViewMenu"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.showViewMenu", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ShowViewMenuAction_text);
            action.setToolTipText(WorkbenchMessages.ShowViewMenuAction_toolTip);
            return action;
        }
    };
    public static final ActionFactory UNDO = new ActionFactory("undo"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_undo);
            action.setToolTipText(WorkbenchMessages.Workbench_undoToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.edit.undo");
            ISharedImages sharedImages = window.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
            action.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
            return action;
        }
    };
    public static final ActionFactory UP = new ActionFactory("up"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            LabelRetargetAction action = new LabelRetargetAction(this.getId(), WorkbenchMessages.Workbench_up);
            action.setToolTipText(WorkbenchMessages.Workbench_upToolTip);
            window.getPartService().addPartListener(action);
            action.setActionDefinitionId("org.eclipse.ui.navigate.up");
            return action;
        }
    };
    public static final ActionFactory HELP_CONTENTS = new ActionFactory("helpContents"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            HelpContentsAction action = new HelpContentsAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory HELP_SEARCH = new ActionFactory("helpSearch"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            HelpSearchAction action = new HelpSearchAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory DYNAMIC_HELP = new ActionFactory("dynamicHelp"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            DynamicHelpAction action = new DynamicHelpAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    public static final ActionFactory OPEN_PERSPECTIVE_DIALOG = new ActionFactory("openPerspectiveDialog"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.perspectives.showPerspective", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.OpenPerspectiveDialogAction_text);
            action.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
            action.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE"));
            return action;
        }
    };
    public static final ActionFactory NEW_EDITOR = new ActionFactory("newEditor"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.window.newEditor", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.NewEditorAction_text);
            action.setToolTipText(WorkbenchMessages.NewEditorAction_tooltip);
            return action;
        }
    };
    public static final ActionFactory TOGGLE_COOLBAR = new ActionFactory("toggleCoolbar"){

        @Override
        public IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction("org.eclipse.ui.ToggleCoolbarAction", window);
            action.setId(this.getId());
            action.setText(WorkbenchMessages.ToggleCoolbarVisibilityAction_hide_text);
            action.setToolTipText(WorkbenchMessages.ToggleCoolbarVisibilityAction_toolTip);
            return action;
        }
    };
    private final String actionId;

    public static void linkCycleActionPair(IWorkbenchAction next, IWorkbenchAction previous) {
    }

    protected ActionFactory(String actionId) {
        this.actionId = actionId;
    }

    public abstract IWorkbenchAction create(IWorkbenchWindow var1);

    public String getId() {
        return this.actionId;
    }

    public static interface IWorkbenchAction
    extends IAction {
        public void dispose();
    }

    private static class WorkbenchCommandAction
    extends CommandAction
    implements IWorkbenchAction {
        public WorkbenchCommandAction(String commandIdIn, IWorkbenchWindow window) {
            super(window, commandIdIn);
        }

        public WorkbenchCommandAction(String commandIdIn, Map parameterMap, IServiceLocator serviceLocator) {
            super(serviceLocator, commandIdIn, parameterMap);
        }
    }
}

