/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import jp.sourceforge.concierge.plugin.imageviewer.ControlUtils;
import jp.sourceforge.concierge.plugin.imageviewer.DrawArea;
import jp.sourceforge.concierge.plugin.imageviewer.SelectionArea;
import jp.sourceforge.concierge.plugin.imageviewer.TextInput;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class Memo {
    private boolean drawmode = false;
    private boolean passmode = false;
    private Control control;
    private int width;
    private int height;
    private SelectionArea selarea;
    private DrawArea drawarea;
    private Cursor cfreehand;
    private Cursor cselection;
    private Color curcolor = null;
    private Font curfont = null;

    public static String getOverlayedImagePath(String orgfile) {
        String basename = String.valueOf(FilenameUtils.getPrefix((String)orgfile)) + FilenameUtils.getPath((String)orgfile) + FilenameUtils.getBaseName((String)orgfile);
        return String.valueOf(basename) + "_overlay.png";
    }

    public static String getMemoImagePath(String orgfile) {
        String basename = String.valueOf(FilenameUtils.getPrefix((String)orgfile)) + FilenameUtils.getPath((String)orgfile) + FilenameUtils.getBaseName((String)orgfile);
        return String.valueOf(basename) + "_memo.bmp";
    }

    public Memo(Control ctrl, int w, int h) {
        this.control = ctrl;
        this.width = w;
        this.height = h;
        this.selarea = new SelectionArea(this.control, this.width, this.height);
        this.drawarea = new DrawArea(this.control, this.width, this.height);
        this.cfreehand = new Cursor((Device)this.control.getDisplay(), 2);
        this.cselection = new Cursor((Device)this.control.getDisplay(), 0);
        this.curcolor = new Color((Device)this.control.getDisplay(), 0, 0, 0);
        this.curfont = new Font((Device)this.control.getDisplay(), "Times-Roman", 16, 0);
        this.control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (Memo.this.control == null) {
                    return;
                }
                if (Memo.this.passmode) {
                    Memo.this.passmode = false;
                    Memo.this.control.redraw();
                    return;
                }
                Point topleft = ControlUtils.getLeftTopPosition(Memo.this.control);
                GC gc = new GC((Drawable)Memo.this.control);
                Point sz = Memo.this.control.getSize();
                if (topleft.x + sz.x > Memo.this.width) {
                    sz.x = Memo.this.width - topleft.x;
                }
                if (topleft.y + sz.y > Memo.this.height) {
                    sz.y = Memo.this.height - topleft.y;
                }
                Memo.this.drawarea.drawImage(gc, topleft.x, topleft.y, sz.x, sz.y, 0, 0, sz.x, sz.y);
                Memo.this.selarea.drawImage(gc, topleft.x, topleft.y, sz.x, sz.y, 0, 0, sz.x, sz.y);
                gc.dispose();
            }
        });
        this.control.addMouseMoveListener(new MouseMoveListener(){
            private Point prevpt = null;
            private Point selp1 = null;
            private Point selp2 = null;

            public void mouseMove(MouseEvent e) {
                if (!Memo.this.drawmode || (e.stateMask & 0x80000) == 0) {
                    this.prevpt = null;
                    this.selp1 = null;
                    this.selp2 = null;
                    Memo.this.control.setCursor(null);
                    return;
                }
                Point topleft = ControlUtils.getLeftTopPosition(Memo.this.control);
                if ((e.stateMask & 0x20000) == 0) {
                    if (this.prevpt == null) {
                        this.prevpt = new Point(topleft.x + e.x, topleft.y + e.y);
                        Memo.this.drawarea.commit();
                        Memo.this.selarea.reset();
                        Memo.this.control.setCursor(Memo.this.cfreehand);
                    } else {
                        Memo.this.drawarea.setLineWidth(3);
                        Memo.this.drawarea.drawLine(this.prevpt.x, this.prevpt.y, topleft.x + e.x, topleft.y + e.y, Memo.this.curcolor);
                        this.prevpt = new Point(topleft.x + e.x, topleft.y + e.y);
                        Memo.this.control.redraw();
                    }
                } else {
                    if (this.selp1 == null) {
                        Memo.this.selarea.reset();
                        this.selp2 = this.selp1 = new Point(topleft.x + e.x, topleft.y + e.y);
                        Memo.this.control.setCursor(Memo.this.cselection);
                    } else {
                        this.selp2 = new Point(topleft.x + e.x, topleft.y + e.y);
                        Memo.this.selarea.selection(this.selp1, this.selp2);
                    }
                    Memo.this.control.redraw();
                }
            }
        });
        this.control.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (!Memo.this.drawmode) {
                    return;
                }
                TextInput txt = new TextInput(Memo.this.control.getShell());
                txt.setFont(Memo.this.curfont);
                txt.setInitialLocation(Memo.this.control.toDisplay(new Point(e.x, e.y)));
                txt.open();
                String value = txt.getValue();
                Memo.this.drawarea.commit();
                Point topleft = ControlUtils.getLeftTopPosition(Memo.this.control);
                Memo.this.drawarea.drawText(topleft.x + e.x, topleft.y + e.y, value, Memo.this.curcolor, Memo.this.curfont);
                Memo.this.control.redraw();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (!Memo.this.drawmode) {
                    return;
                }
                if (e.keyCode == 127 || e.keyCode == 8) {
                    Rectangle r = Memo.this.selarea.getSelection();
                    if (r != null) {
                        Memo.this.drawarea.commit();
                        Memo.this.drawarea.deleteArea(r);
                        Memo.this.selarea.reset();
                    } else {
                        if (!MessageDialog.openConfirm((Shell)Memo.this.control.getShell(), (String)"Delete", (String)"Delete. OK?")) {
                            return;
                        }
                        Memo.this.drawarea.commit();
                        Memo.this.drawarea.reset();
                    }
                } else if (e.keyCode == 122 && (e.stateMask & 0x40000) != 0) {
                    Memo.this.drawarea.undo();
                } else {
                    return;
                }
                Memo.this.control.redraw();
            }
        });
        if (this.control instanceof StyledText) {
            StyledText st = (StyledText)this.control;
            st.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (Memo.this.drawmode) {
                        e.doit = false;
                        return;
                    }
                    Memo.this.passmode = true;
                }
            });
        }
    }

    public void loadImage(String file) {
        this.drawarea = new DrawArea(this.control, file);
        this.control.redraw();
    }

    public void saveImage(String file) {
        GraphicUtil.saveImage((Image)this.drawarea.getImage(), (String)file, (int)0);
    }

    public void setDrawMode(boolean mode) {
        this.drawmode = mode;
        this.control.redraw();
    }

    public boolean isDrawMode() {
        return this.drawmode;
    }

    public void setImage(Image img) {
        this.drawarea.setImage(img);
        this.control.redraw();
    }

    public Image getImage() {
        return this.drawarea.getImage();
    }

    public void setColor(Color c) {
        if (this.curcolor != null && !this.curcolor.isDisposed()) {
            this.curcolor.dispose();
        }
        this.curcolor = new Color((Device)this.control.getDisplay(), c.getRed(), c.getGreen(), c.getBlue());
    }

    public Color getColor() {
        return this.curcolor;
    }

    public void setFont(Font f) {
        if (this.curfont != null && !this.curfont.isDisposed()) {
            this.curfont.dispose();
        }
        this.curfont = new Font((Device)this.control.getDisplay(), f.getFontData());
    }

    public Font getFont() {
        return this.curfont;
    }

    protected void finalize() throws Throwable {
        this.cfreehand.dispose();
        this.cselection.dispose();
        super.finalize();
    }
}

