/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import jp.sourceforge.concierge.editor.EditorDelegate;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorPlugin;
import jp.sourceforge.concierge.framework.AbstractDocumentUIPlugin;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.ibooks.ConciergeAdapter;
import jp.sourceforge.concierge.plugin.ibooks.ConciergeDialogArea;
import jp.sourceforge.concierge.util.CCGFileUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class iBooksPlugin
extends AbstractDocumentUIPlugin
implements IEditorPlugin {
    private static iBooksPlugin plugin;
    public static final String catchFolderName = "ibooks";
    public static final int thumbnailImageSize = 120;

    public iBooksPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (!ConciergeAdapter.isReady(iBooksPlugin.getDefault().getBundle().getSymbolicName())) {
            System.out.println("Your Concierge is inappropriate for using iBooks.");
            System.out.println("Please read the required configuration in manual.");
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static iBooksPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ibooks", (String)path);
    }

    public static String getPluginFilePath(String path) {
        return plugin.getFilePath(path);
    }

    public EditorDelegate getDelegate() {
        return null;
    }

    public IConciergeDialogArea getDialogArea() {
        return new ConciergeDialogArea();
    }

    public Image loadCatchThumbnailFile(String filename) {
        Image newImage;
        block10: {
            newImage = null;
            try {
                ImageLoader imgldr;
                ImageData[] imgdata;
                String catchFileName;
                File catchFile;
                String catchDirName = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + catchFolderName;
                File catchFolder = new File(catchDirName);
                if (!catchFolder.exists()) {
                    catchFolder.mkdir();
                }
                if ((catchFile = new File(catchFileName = String.valueOf(catchDirName) + System.getProperty("file.separator") + filename)).exists() && (imgdata = (imgldr = new ImageLoader()).load(catchFileName)).length > 0) {
                    ImageData imagedata = imgdata[0];
                    int width = 120;
                    int height = 120;
                    if (imagedata.width > 120 || imagedata.height > 120) {
                        float a;
                        if (imagedata.width > imagedata.height) {
                            a = imagedata.width;
                            float b = 120.0f;
                            float c = imagedata.height;
                            float ans = a / b;
                            height = (int)(c / ans);
                        } else {
                            a = imagedata.height;
                            float b = 120.0f;
                            float c = imagedata.width;
                            float ans = a / b;
                            width = (int)(c / ans);
                        }
                        ImageData newimagedata = imagedata.scaledTo(width, height);
                        imagedata = null;
                        imagedata = newimagedata;
                    }
                    newImage = new Image((Device)plugin.getWorkbench().getDisplay(), imagedata);
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                if (newImage == null) break block10;
                newImage.dispose();
                newImage = null;
            }
        }
        if (newImage == null) {
            ImageDescriptor imgDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.concierge.plugin.ibooks", (String)"icons/NoImage.jpg");
            Image image = imgDes.createImage();
            Rectangle r = image.getBounds();
            if (r.width > 120 || r.height > 120) {
                ImageData imgdata = image.getImageData().scaledTo(120, 120);
                newImage = new Image((Device)plugin.getWorkbench().getDisplay(), imgdata);
                image.dispose();
                image = null;
            } else {
                newImage = image;
            }
        }
        return newImage;
    }

    public void saveThumbnailFile(String imageURL, long id) {
        try {
            File f;
            String dirName = FrameworkPlugin.getThumbnailFileDirectory();
            String thumbnailPath = CCGFileUtils.findFile((String)dirName, (String)String.valueOf(id));
            if (thumbnailPath != null && (f = new File(thumbnailPath)).exists()) {
                f.delete();
            }
            thumbnailPath = String.valueOf(dirName) + File.separator + String.valueOf(id) + ".jpg";
            System.out.println(thumbnailPath);
            if (imageURL != null && imageURL.length() > 0) {
                try {
                    int count;
                    URL url = new URL(imageURL);
                    InputStream is = url.openStream();
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(thumbnailPath));
                    byte[] buf = new byte[16384];
                    while ((count = is.read(buf, 0, 16384)) != -1) {
                        os.write(buf, 0, count);
                    }
                    buf = null;
                    os.close();
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
    }

    public void saveCatchThumbnailFile(String imageURL, String filename) {
        String catchDirName = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + catchFolderName;
        String catchFileName = String.valueOf(catchDirName) + System.getProperty("file.separator") + filename;
        try {
            File catchFile;
            File catchFolder = new File(catchDirName);
            if (!catchFolder.exists()) {
                catchFolder.mkdir();
            }
            if ((catchFile = new File(catchFileName)).exists()) {
                catchFile.delete();
            }
        }
        catch (Exception exception) {}
        if (imageURL != null && imageURL.length() > 0) {
            try {
                int count;
                URL url = new URL(imageURL);
                InputStream is = url.openStream();
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(catchFileName));
                byte[] buf = new byte[16384];
                while ((count = is.read(buf, 0, 16384)) != -1) {
                    os.write(buf, 0, count);
                }
                buf = null;
                os.close();
                is.close();
            }
            catch (Exception exception) {}
        }
    }
}

