/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.editor;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import jp.sourceforge.concierge.editor.EditorDelegate;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateType;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.CategoryViewer;
import jp.sourceforge.concierge.plugin.labnote.LabNoteDocumentImpl;
import jp.sourceforge.concierge.plugin.labnote.preferences.LabNotePreferencePage;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.DataHeaderValue;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.StyleModifyListener;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.StyledTextEditor;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.FileLauncher;
import jp.sourceforge.concierge.widget.SmartText;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;

public class LabNoteEditorDelegate
extends EditorDelegate {
    Composite parentcomp;
    Label datelabel;
    Label datevalue;
    Label titlelabel;
    Text titleeditor;
    Label kwdlabel;
    SmartText keywordeditor;
    Label catlabel;
    Combo categoryeditor;
    StyledTextEditor contenteditor;
    Document document;
    Object sender;
    SelectionAdapter catseladapter;
    ModifyListener editormodlistener;
    ModifyListener titlemodlistener;
    ModifyListener keywordslistener;
    StyleModifyListener stylemodlistener;
    static final int ID_EXPORT = 200;
    static final String defaultTitle = "untitled";
    static final Color defaultcolor = new Color(null, 0, 0, 0);
    private boolean ismodified = false;
    private boolean isnewdoc = false;

    private ArrayList<DataHeaderValue> makeValueTable() {
        ArrayList<DataHeaderValue> l = new ArrayList<DataHeaderValue>();
        l.add(new DataHeaderValue(this.titlelabel.getText(), this.titleeditor.getText(), true));
        l.add(new DataHeaderValue(LabNotePlugin.getString("LabnoteDialog.2"), this.getTitle(), false));
        l.add(new DataHeaderValue(this.catlabel.getText(), this.categoryeditor.getText(), false));
        l.add(new DataHeaderValue(this.kwdlabel.getText(), this.keywordeditor.getText(), false));
        return l;
    }

    private String createCSSString(Document doc) {
        Category cat = LabNotePlugin.getCategoryManager().getCategoryByName(this.categoryeditor.getText());
        Color color = cat != null ? CategoryViewer.getColor(cat.colorid) : defaultcolor;
        String cssname = LabNotePreferencePage.getCSSName();
        String cssfile = LabNotePlugin.getDefault().getFilePath("lib/" + cssname);
        try {
            String cssstr = FileUtils.readFileToString((File)new File(cssfile), (String)"UTF-8");
            cssstr = cssstr.replaceFirst("%CATEGORYCOLOR%", "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")");
            return cssstr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void modifyListenerEnabled(boolean en) {
        if (en) {
            this.categoryeditor.addSelectionListener((SelectionListener)this.catseladapter);
            this.titleeditor.addModifyListener(this.titlemodlistener);
            this.keywordeditor.addModifyListener(this.keywordslistener);
            this.contenteditor.setModifyListener(this.editormodlistener);
            this.contenteditor.setStyleModifyListener(this.stylemodlistener);
        } else {
            this.categoryeditor.removeSelectionListener((SelectionListener)this.catseladapter);
            this.titleeditor.removeModifyListener(this.titlemodlistener);
            this.keywordeditor.removeModifyListener(this.keywordslistener);
            this.contenteditor.removeModifyListener(this.editormodlistener);
            this.contenteditor.setStyleModifyListener(null);
        }
    }

    private void updateCategory() {
        if (this.parentcomp == null || this.parentcomp.isDisposed()) {
            return;
        }
        this.categoryeditor.removeAll();
        ArrayList<Category> cats = LabNotePlugin.getCategoryManager().getCategories();
        Collections.sort(cats, new Comparator<Category>(){

            @Override
            public int compare(Category c1, Category c2) {
                return c1.name.compareTo(c2.name);
            }
        });
        int i = 0;
        while (i < cats.size()) {
            this.categoryeditor.add(cats.get((int)i).name);
            ++i;
        }
        this.categoryeditor.layout();
    }

    private void removeEmbeddedObjects(ArrayList<Document> docs) {
        int i = 0;
        while (i < docs.size()) {
            this.contenteditor.removeEmbeddedObjectByDocument(docs.get(i));
            ++i;
        }
    }

    private void updateEmbeddedObjects(ArrayList<Document> docs) {
        int i = 0;
        while (i < docs.size()) {
            this.contenteditor.updateEmbeddedObjectByDocument(docs.get(i));
            ++i;
        }
    }

    private void setValuesToDocument() {
        if (this.document == null) {
            return;
        }
        String value = this.titleeditor.getText();
        if (value.length() == 0) {
            value = defaultTitle;
        }
        LabNoteDocumentImpl.setTitle(this.document, value);
        String path = DataDomImpl.getFilePath((Document)this.document);
        if (path == null || path.length() == 0) {
            path = String.valueOf(LabNotePlugin.getLabNoteSrcDirectory()) + File.separator + LabNoteDocumentImpl.getDate(this.document) + "-" + DomImpl.getID((Document)this.document) + ".html";
            DataDomImpl.setFilePath((Document)this.document, (String)path);
        }
        LabNoteDocumentImpl.setContent(this.document, this.contenteditor.getDocument());
        LabNoteDocumentImpl.setCategory(this.document, this.categoryeditor.getText());
        LabNoteDocumentImpl.setKeywords(this.document, this.keywordeditor.getText());
        this.keywordeditor.save();
    }

    private void saveDocument() {
        LabNotePlugin fp = LabNotePlugin.getDefault();
        if (this.isnewdoc) {
            fp.addDocument(this.document, true, this.sender);
        } else {
            fp.updateDocument(this.document, this.sender);
        }
        this.isnewdoc = false;
        this.ismodified = false;
    }

    private void modified() {
        this.ismodified = true;
        if (this.listener != null) {
            EditorEvent ee = new EditorEvent(1, null, null);
            this.listener.run(ee);
        }
    }

    private void updateInternal() {
        Document content;
        String kwds;
        if (this.parentcomp == null || this.parentcomp.isDisposed()) {
            return;
        }
        this.modifyListenerEnabled(false);
        String title = LabNoteDocumentImpl.getTitle(this.document);
        if (title != null) {
            this.titleeditor.setText(title);
        }
        if ((kwds = LabNoteDocumentImpl.getKeywords(this.document)) != null) {
            this.keywordeditor.setText(kwds);
        }
        if ((content = LabNoteDocumentImpl.getContent(this.document)) != null) {
            this.contenteditor.setDocument(content);
        }
        if (this.categoryeditor.getItemCount() == 0) {
            return;
        }
        String cat = LabNoteDocumentImpl.getCategory(this.document);
        Category category = LabNotePlugin.getCategoryManager().getCategoryByName(cat);
        if (category != null) {
            int idx = this.categoryeditor.indexOf(category.name);
            if (idx >= 0) {
                this.categoryeditor.select(idx);
            } else {
                this.categoryeditor.select(0);
            }
        }
        this.modifyListenerEnabled(true);
    }

    public Document getDocument() {
        return this.document;
    }

    public void doSave() {
        this.setValuesToDocument();
        this.saveDocument();
        if (this.listener != null) {
            EditorEvent ee = new EditorEvent(0, null, (Object)this.document);
            this.listener.run(ee);
        }
    }

    public void setDocument(Document doc, boolean newdoc, Object sender) {
        if (this.document != null && this.ismodified && MessageDialog.openQuestion((Shell)this.parentcomp.getShell(), (String)"Save", (String)"The metadata was modified. Do you want to save before opening new document?")) {
            this.setValuesToDocument();
            this.saveDocument();
        }
        this.isnewdoc = newdoc;
        this.ismodified = false;
        this.document = doc;
        this.sender = sender;
    }

    public void update(Document doc) {
        this.document = doc;
        this.updateCategory();
        this.updateInternal();
    }

    public void update(CCGUpdateEvent updateinfo) {
        if (updateinfo == null || !updateinfo.success.booleanValue()) {
            return;
        }
        if (updateinfo.collection.equals("ccgconfig")) {
            this.updateCategory();
            return;
        }
        if (updateinfo.sender == this.sender) {
            return;
        }
        if (updateinfo.collection.equals("data")) {
            if (updateinfo.type == CCGUpdateType.DEL_DOCUMENT) {
                this.removeEmbeddedObjects(updateinfo.documents);
            } else if (updateinfo.type == CCGUpdateType.UPD_DOCUMENT) {
                this.updateEmbeddedObjects(updateinfo.documents);
            }
            Document doc = DomImpl.findDocument((ArrayList)updateinfo.documents, (Document)this.document);
            if (doc != null) {
                if (!doc.equals(this.document)) {
                    this.document = doc;
                    this.isnewdoc = false;
                    this.ismodified = false;
                }
                this.updateInternal();
            }
        }
    }

    public Control createEditorArea(Composite parent) {
        this.parentcomp = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite comp = new Composite(parent, 0);
        GridLayout cgl = new GridLayout(1, false);
        cgl.marginWidth = 0;
        cgl.marginHeight = 0;
        cgl.verticalSpacing = 1;
        comp.setLayout((Layout)cgl);
        comp.setLayoutData((Object)new GridData(1808));
        Composite header = new Composite(comp, 0);
        header.setLayout((Layout)new FormLayout());
        header.setLayoutData((Object)new GridData(768));
        MouseTrackListener tooltipMouseTrackListener = new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                Control cont = (Control)e.getSource();
                ToolTip tooltip = (ToolTip)cont.getData("ToolTip");
                Point p = cont.getSize();
                tooltip.setLocation(cont.toDisplay(p.x, p.y));
                tooltip.setVisible(true);
            }

            public void mouseExit(MouseEvent e) {
                Control cont = (Control)e.getSource();
                ToolTip tooltip = (ToolTip)cont.getData("ToolTip");
                tooltip.setVisible(false);
            }

            public void mouseHover(MouseEvent e) {
            }
        };
        FormData fd = null;
        ImageHyperlink savelink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        savelink.setLayoutData((Object)fd);
        savelink.setImage(LabNotePlugin.getImageDescriptor("icons/s.png").createImage());
        savelink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                LabNoteEditorDelegate.this.modifyListenerEnabled(false);
                LabNoteEditorDelegate.this.doSave();
                LabNoteEditorDelegate.this.ismodified = false;
                LabNoteEditorDelegate.this.modifyListenerEnabled(true);
            }
        });
        ToolTip tooltip = new ToolTip(savelink.getShell(), 2);
        savelink.setData("ToolTip", (Object)tooltip);
        tooltip.setMessage(LabNotePlugin.getString("LabnoteDialog.6"));
        savelink.addMouseTrackListener(tooltipMouseTrackListener);
        ImageHyperlink exportlink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)savelink, 5);
        exportlink.setLayoutData((Object)fd);
        exportlink.setImage(LabNotePlugin.getImageDescriptor("icons/e.png").createImage());
        exportlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                LabNoteEditorDelegate.this.modifyListenerEnabled(false);
                LabNoteEditorDelegate.this.contenteditor.exportToHtml(LabNoteEditorDelegate.this.makeValueTable(), LabNoteEditorDelegate.this.createCSSString(LabNoteEditorDelegate.this.document), LabNoteDocumentImpl.getDate(LabNoteEditorDelegate.this.document));
                LabNoteEditorDelegate.this.modifyListenerEnabled(true);
            }
        });
        ToolTip tooltip2 = new ToolTip(exportlink.getShell(), 2);
        exportlink.setData("ToolTip", (Object)tooltip2);
        tooltip2.setMessage(LabNotePlugin.getString("LabnoteDialog.9"));
        exportlink.addMouseTrackListener(tooltipMouseTrackListener);
        ImageHyperlink browserlink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)exportlink, 5);
        browserlink.setLayoutData((Object)fd);
        browserlink.setImage(LabNotePlugin.getImageDescriptor("icons/b.png").createImage());
        browserlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                try {
                    String tempDirName = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + ".temp";
                    File tempFolder = new File(tempDirName);
                    if (!tempFolder.exists()) {
                        tempFolder.mkdir();
                    } else {
                        long total = 0L;
                        File[] files = tempFolder.listFiles();
                        int i = 0;
                        while (i < files.length) {
                            total += files[i].length();
                            ++i;
                        }
                        if (total >= 0xA00000L) {
                            i = 0;
                            while (i < files.length) {
                                files[i].delete();
                                ++i;
                            }
                        }
                    }
                    long id = DomImpl.getID((Document)LabNoteEditorDelegate.this.document);
                    String htmlFileName = String.valueOf(tempDirName) + System.getProperty("file.separator") + String.valueOf(id) + ".html";
                    LabNoteEditorDelegate.this.modifyListenerEnabled(false);
                    LabNoteEditorDelegate.this.contenteditor.exportToHtml(htmlFileName, LabNoteEditorDelegate.this.makeValueTable(), LabNoteEditorDelegate.this.createCSSString(LabNoteEditorDelegate.this.document));
                    LabNoteEditorDelegate.this.modifyListenerEnabled(true);
                    FileLauncher.LaunchFile((File)new File(htmlFileName));
                }
                catch (Exception excp) {
                    System.err.println(excp.getMessage());
                }
            }
        });
        ToolTip tooltip3 = new ToolTip(browserlink.getShell(), 2);
        browserlink.setData("ToolTip", (Object)tooltip3);
        tooltip3.setMessage(LabNotePlugin.getString("LabnoteDialog.16"));
        browserlink.addMouseTrackListener(tooltipMouseTrackListener);
        ImageHyperlink preferencelink = new ImageHyperlink(header, 0x800000);
        fd = new FormData();
        fd.left = new FormAttachment((Control)browserlink, 5);
        preferencelink.setLayoutData((Object)fd);
        preferencelink.setImage(LabNotePlugin.getImageDescriptor("icons/p.png").createImage());
        preferencelink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)"jp.sourceforge.concierge.plugin.labnote.preferences.LabNotePreferencePage", null, null);
                dialog.open();
            }
        });
        ToolTip tooltip4 = new ToolTip(preferencelink.getShell(), 2);
        preferencelink.setData("ToolTip", (Object)tooltip4);
        tooltip4.setMessage(LabNotePlugin.getString("LabnoteDialog.20"));
        preferencelink.addMouseTrackListener(tooltipMouseTrackListener);
        Label seplatorLabel = new Label(comp, 258);
        seplatorLabel.setLayoutData((Object)new GridData(768));
        Composite headgrp = new Composite(comp, 0);
        headgrp.setLayout((Layout)new GridLayout(2, false));
        GridData hggd = new GridData(768);
        headgrp.setLayoutData((Object)hggd);
        this.catlabel = new Label(headgrp, 131072);
        this.catlabel.setLayoutData((Object)new GridData(0));
        this.catlabel.setText(LabNotePlugin.getString("LabnoteDialog.3"));
        this.categoryeditor = new Combo(headgrp, 8);
        this.categoryeditor.setLayoutData((Object)new GridData(768));
        this.catseladapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabNoteEditorDelegate.this.modified();
            }
        };
        this.titlelabel = new Label(headgrp, 131072);
        this.titlelabel.setLayoutData((Object)new GridData(0));
        this.titlelabel.setText(LabNotePlugin.getString("LabnoteDialog.5"));
        this.titleeditor = new Text(headgrp, 2052);
        this.titleeditor.setLayoutData((Object)new GridData(768));
        this.titlemodlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabNoteEditorDelegate.this.modified();
            }
        };
        this.kwdlabel = new Label(headgrp, 131072);
        this.kwdlabel.setLayoutData((Object)new GridData(0));
        this.kwdlabel.setText(LabNotePlugin.getString("LabnoteDialog.4"));
        this.keywordeditor = new SmartText(headgrp, 2052);
        this.keywordeditor.setLayoutData((Object)new GridData(768));
        ITypeParser p = FrameworkPlugin.getParser((String)"keywords");
        if (p != null) {
            this.keywordeditor.setToolTipText(p.getMessage());
        }
        this.keywordslistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabNoteEditorDelegate.this.modified();
            }
        };
        this.updateCategory();
        this.contenteditor = new StyledTextEditor(comp, 0);
        GridData cmgd = new GridData(1808);
        this.contenteditor.setLayoutData(cmgd);
        this.editormodlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LabNoteEditorDelegate.this.modified();
            }
        };
        this.stylemodlistener = new StyleModifyListener(){

            @Override
            public void modifyStyle() {
                LabNoteEditorDelegate.this.modified();
            }
        };
        this.modifyListenerEnabled(true);
        if (this.document != null) {
            this.updateInternal();
        }
        return comp;
    }

    public String getTitle() {
        String dateString = LabNoteDocumentImpl.getDate(this.document);
        if (dateString == null) {
            return "";
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date date = df.parse(dateString);
            return date != null ? CalendarUtil.getDateString((Date)date) : "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean close() {
        if (this.ismodified && MessageDialog.openQuestion((Shell)this.parentcomp.getShell(), (String)"Save", (String)"The metadata was modified. Do you want to save before leaving?")) {
            this.doSave();
            this.ismodified = false;
        }
        this.contenteditor.removePropertyChangeListener();
        this.contenteditor.close();
        return !this.ismodified;
    }

    public boolean isModified() {
        return this.ismodified;
    }
}

