/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerRow;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewer
extends AbstractTableViewer {
    private Table table;
    private TableViewerRow cachedRow;

    public TableViewer(Composite parent) {
        this(parent, 2818);
    }

    public TableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public TableViewer(Table table) {
        this.table = table;
        this.hookControl((Control)table);
    }

    @Override
    public Control getControl() {
        return this.table;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    protected ColumnViewerEditor createViewerEditor() {
        return new TableViewerEditor(this, null, new ColumnViewerEditorActivationStrategy(this), 1);
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
        super.setSelection(selection, reveal);
    }

    @Override
    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new TableViewerRow((TableItem)item);
        } else {
            this.cachedRow.setItem((TableItem)item);
        }
        return this.cachedRow;
    }

    @Override
    protected ViewerRow internalCreateNewRowPart(int style, int rowIndex) {
        TableItem item = rowIndex >= 0 ? new TableItem(this.table, style, rowIndex) : new TableItem(this.table, style);
        return this.getViewerRowFromItem((Widget)item);
    }

    @Override
    protected Item getItemAt(Point p) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 1) {
            int columnCount = this.table.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                if (selection[0].getBounds(i).contains(p)) {
                    return selection[0];
                }
                ++i;
            }
        }
        return this.table.getItem(p);
    }

    @Override
    protected int doGetItemCount() {
        return this.table.getItemCount();
    }

    @Override
    protected int doIndexOf(Item item) {
        return this.table.indexOf((TableItem)item);
    }

    @Override
    protected void doSetItemCount(int count) {
        this.table.setItemCount(count);
    }

    @Override
    protected Item[] doGetItems() {
        return this.table.getItems();
    }

    @Override
    protected int doGetColumnCount() {
        return this.table.getColumnCount();
    }

    @Override
    protected Widget doGetColumn(int index) {
        return this.table.getColumn(index);
    }

    @Override
    protected Item doGetItem(int index) {
        return this.table.getItem(index);
    }

    @Override
    protected Item[] doGetSelection() {
        return this.table.getSelection();
    }

    @Override
    protected int[] doGetSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    @Override
    protected void doClearAll() {
        this.table.clearAll();
    }

    @Override
    protected void doResetItem(Item item) {
        TableItem tableItem = (TableItem)item;
        int columnCount = Math.max(1, this.table.getColumnCount());
        int i = 0;
        while (i < columnCount) {
            tableItem.setText(i, "");
            if (tableItem.getImage(i) != null) {
                tableItem.setImage(i, null);
            }
            ++i;
        }
    }

    @Override
    protected void doRemove(int start, int end) {
        this.table.remove(start, end);
    }

    @Override
    protected void doRemoveAll() {
        this.table.removeAll();
    }

    @Override
    protected void doRemove(int[] indices) {
        this.table.remove(indices);
    }

    @Override
    protected void doShowItem(Item item) {
        this.table.showItem((TableItem)item);
    }

    @Override
    protected void doDeselectAll() {
        this.table.deselectAll();
    }

    @Override
    protected void doSetSelection(Item[] items) {
        Assert.isNotNull((Object)items, (String)"Items-Array can not be null");
        TableItem[] t = new TableItem[items.length];
        System.arraycopy(items, 0, t, 0, t.length);
        this.table.setSelection(t);
    }

    @Override
    protected void doShowSelection() {
        this.table.showSelection();
    }

    @Override
    protected void doSetSelection(int[] indices) {
        this.table.setSelection(indices);
    }

    @Override
    protected void doClear(int index) {
        this.table.clear(index);
    }

    @Override
    protected void doSelect(int[] indices) {
        this.table.select(indices);
    }

    public void refresh(final Object element, final boolean updateLabels, boolean reveal) {
        if (this.checkBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                TableViewer.this.internalRefresh(element, updateLabels);
            }
        }, reveal);
    }

    public void refresh(boolean updateLabels, boolean reveal) {
        this.refresh(this.getRoot(), updateLabels, reveal);
    }
}

