/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;

public class NestedDirBundleFile
extends BundleFile {
    BundleFile baseBundleFile;
    String cp;

    public NestedDirBundleFile(BundleFile baseBundlefile, String cp) {
        super(baseBundlefile.basefile);
        this.baseBundleFile = baseBundlefile;
        this.cp = cp;
        if (cp.charAt(cp.length() - 1) != '/') {
            this.cp = String.valueOf(this.cp) + '/';
        }
    }

    @Override
    public void close() {
    }

    @Override
    public BundleEntry getEntry(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        String newpath = new StringBuffer(this.cp).append(path).toString();
        return this.baseBundleFile.getEntry(newpath);
    }

    @Override
    public boolean containsDir(String dir) {
        if (dir == null) {
            return false;
        }
        if (dir.length() > 0 && dir.charAt(0) == '/') {
            dir = dir.substring(1);
        }
        String newdir = new StringBuffer(this.cp).append(dir).toString();
        return this.baseBundleFile.containsDir(newdir);
    }

    @Override
    public Enumeration getEntryPaths(String path) {
        return null;
    }

    @Override
    public File getFile(String entry, boolean nativeCode) {
        return null;
    }

    @Override
    public void open() throws IOException {
    }
}

