/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionAdminImpl;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.osgi.service.condpermadmin.Condition;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionSet
extends BundlePermissionCollection {
    private static final long serialVersionUID = 3258411750729920566L;
    private ConditionalPermissionInfoImpl[] cpis = ConditionalPermissionAdminImpl.EMPTY_COND_PERM_INFO;
    private HashMap cachedPermissionCollections = new HashMap();
    private boolean hasAllPermission = false;
    private AbstractBundle bundle;
    private Condition[] neededConditions;

    public ConditionalPermissionSet(AbstractBundle bundle, ConditionalPermissionInfoImpl[] cpis, Condition[] neededConditions) {
        this.bundle = bundle;
        this.cpis = cpis;
        this.neededConditions = neededConditions;
        this.checkForAllPermission();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConditionalPermissionInfo(ConditionalPermissionInfoImpl cpi) {
        if (this.neededConditions == null || this.neededConditions.length > 0) {
            throw new RuntimeException("Cannot add ConditionalPermissionInfoImpl to a non satisfied set");
        }
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            int i = 0;
            while (i < this.cpis.length) {
                if (this.cpis[i] == null) {
                    this.cpis[i] = cpi;
                    this.cachedPermissionCollections.clear();
                    return;
                }
                ++i;
            }
            ConditionalPermissionInfoImpl[] newcpis = new ConditionalPermissionInfoImpl[this.cpis.length + 1];
            System.arraycopy(this.cpis, 0, newcpis, 0, this.cpis.length);
            newcpis[this.cpis.length] = cpi;
            this.cpis = newcpis;
            this.cachedPermissionCollections.clear();
            this.checkForAllPermission();
        }
    }

    private void checkForAllPermission() {
        if (this.hasAllPermission) {
            return;
        }
        int i = 0;
        block0: while (i < this.cpis.length) {
            if (this.cpis[i] != null) {
                PermissionInfo[] perms = this.cpis[i].perms;
                int j = 0;
                while (j < perms.length) {
                    if (perms[j].getType().equals(AllPermission.class.getName())) {
                        this.hasAllPermission = true;
                        break block0;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNonEmpty() {
        boolean nonEmpty = false;
        boolean forceAllPermCheck = false;
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            int i = 0;
            while (i < this.cpis.length) {
                if (this.cpis[i] != null) {
                    if (this.cpis[i].isDeleted()) {
                        this.cpis[i] = null;
                        forceAllPermCheck = true;
                        this.cachedPermissionCollections.clear();
                    } else {
                        nonEmpty = true;
                    }
                }
                ++i;
            }
            if (!nonEmpty) {
                this.cpis = ConditionalPermissionAdminImpl.EMPTY_COND_PERM_INFO;
            }
            if (forceAllPermCheck) {
                this.hasAllPermission = false;
                this.checkForAllPermission();
            }
        }
        return nonEmpty;
    }

    /*
     * Enabled aggressive block sorting
     */
    Condition[] getNeededConditions() {
        if (this.neededConditions == null || this.neededConditions.length == 0) {
            return this.neededConditions;
        }
        boolean foundNonNullCondition = false;
        int i = 0;
        while (i < this.neededConditions.length) {
            block7: {
                Condition cond = this.neededConditions[i];
                if (cond != null) {
                    if (!cond.isMutable()) {
                        if (cond.isSatisfied()) {
                            this.neededConditions[i] = null;
                            break block7;
                        } else {
                            this.neededConditions = null;
                            break;
                        }
                    }
                    foundNonNullCondition = true;
                }
            }
            ++i;
        }
        if (this.neededConditions != null && !foundNonNullCondition) {
            this.neededConditions = ConditionalPermissionAdminImpl.EMPTY_COND;
        }
        return this.neededConditions;
    }

    @Override
    public void add(Permission perm) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission perm) {
        PermissionCollection collection;
        if (this.hasAllPermission) {
            return true;
        }
        Class<?> permClass = perm.getClass();
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            collection = (PermissionCollection)this.cachedPermissionCollections.get(permClass);
            if (collection == null) {
                collection = perm.newPermissionCollection();
                if (collection == null) {
                    collection = new PermissionsHash();
                }
                int i = 0;
                while (i < this.cpis.length) {
                    try {
                        ConditionalPermissionInfoImpl cpi = this.cpis[i];
                        if (cpi != null) {
                            cpi.addPermissions(this.bundle, collection, permClass);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.cachedPermissionCollections.put(permClass, collection);
            }
        }
        return collection.implies(perm);
    }

    public Enumeration elements() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void unresolvePermissions() {
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            this.cachedPermissionCollections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean remove(ConditionalPermissionInfoImpl cpi) {
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            int i = 0;
            while (true) {
                if (i >= this.cpis.length) {
                    return false;
                }
                if (this.cpis[i] == cpi) {
                    this.cpis[i] = null;
                    this.cachedPermissionCollections.clear();
                    return true;
                }
                ++i;
            }
        }
    }
}

