/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverBundle
extends VersionSupplier
implements Comparable {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private GenericCapability[] capabilities;
    private GenericConstraint[] genericReqiures;
    private ArrayList fragments;
    private HashMap fragmentExports;
    private HashMap fragmentImports;
    private HashMap fragmentRequires;
    private HashMap fragmentGenericRequires;
    private boolean resolvable = true;
    private int state = 0;
    private boolean uninstalled = false;
    private ResolverImpl resolver;
    private boolean newFragmentExports;
    private ArrayList refs;

    ResolverBundle(BundleDescription bundle, ResolverImpl resolver) {
        super(bundle);
        this.bundleID = new Long(bundle.getBundleId());
        this.resolver = resolver;
        this.initialize(bundle.isResolved());
    }

    void initialize(boolean useSelectedExports) {
        if (this.getBundle().isSingleton()) {
            this.refs = new ArrayList();
        }
        GenericDescription[] actualCapabilities = this.getBundle().getGenericCapabilities();
        this.capabilities = new GenericCapability[actualCapabilities.length];
        int i = 0;
        while (i < this.capabilities.length) {
            this.capabilities[i] = new GenericCapability(this, actualCapabilities[i]);
            ++i;
        }
        if (this.getBundle().getHost() != null) {
            this.host = new BundleConstraint(this, this.getBundle().getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            this.genericReqiures = new GenericConstraint[0];
            return;
        }
        ImportPackageSpecification[] actualImports = this.getBundle().getImportPackages();
        ArrayList<ResolverImport> importList = new ArrayList<ResolverImport>(actualImports.length);
        int i2 = actualImports.length - 1;
        while (i2 >= 0) {
            if ("optional".equals(actualImports[i2].getDirective("resolution"))) {
                importList.add(new ResolverImport(this, actualImports[i2]));
            } else {
                importList.add(0, new ResolverImport(this, actualImports[i2]));
            }
            --i2;
        }
        this.imports = importList.toArray(new ResolverImport[importList.size()]);
        ExportPackageDescription[] actualExports = useSelectedExports ? this.getBundle().getSelectedExports() : this.getBundle().getExportPackages();
        this.exports = new ResolverExport[actualExports.length];
        int i3 = 0;
        while (i3 < actualExports.length) {
            this.exports[i3] = new ResolverExport(this, actualExports[i3]);
            ++i3;
        }
        BundleSpecification[] actualRequires = this.getBundle().getRequiredBundles();
        this.requires = new BundleConstraint[actualRequires.length];
        int i4 = 0;
        while (i4 < this.requires.length) {
            this.requires[i4] = new BundleConstraint(this, actualRequires[i4]);
            ++i4;
        }
        GenericSpecification[] actualGenericRequires = this.getBundle().getGenericRequires();
        this.genericReqiures = new GenericConstraint[actualGenericRequires.length];
        int i5 = 0;
        while (i5 < this.genericReqiures.length) {
            this.genericReqiures[i5] = new GenericConstraint(this, actualGenericRequires[i5]);
            ++i5;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
        this.fragmentGenericRequires = null;
    }

    ResolverExport getExport(String name) {
        ResolverExport[] allExports = this.getExports(name);
        return allExports.length == 0 ? null : allExports[0];
    }

    ResolverExport[] getExports(String name) {
        ArrayList<Object> results = new ArrayList<Object>(1);
        Object[] resolverExports = this.resolver.getResolverExports().get(name);
        int i = 0;
        while (i < resolverExports.length) {
            if (((ResolverExport)resolverExports[i]).getExporter() == this) {
                results.add(resolverExports[i]);
            }
            ++i;
        }
        return results.toArray(new ResolverExport[results.size()]);
    }

    void clearWires() {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            allImports[i].clearPossibleSuppliers();
            ++i;
        }
        if (this.host != null) {
            this.host.clearPossibleSuppliers();
        }
        BundleConstraint[] allRequires = this.getRequires();
        int i2 = 0;
        while (i2 < allRequires.length) {
            allRequires[i2].clearPossibleSuppliers();
            ++i2;
        }
        GenericConstraint[] allGenericRequires = this.getGenericRequires();
        int i3 = 0;
        while (i3 < allGenericRequires.length) {
            allGenericRequires[i3].setMatchingCapability(null);
            ++i3;
        }
        ResolverExport[] allExports = this.getExportPackages();
        int i4 = 0;
        while (i4 < allExports.length) {
            allExports[i4].setSubstitute(null);
            ++i4;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment()) {
            return new ResolverImport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        ArrayList<ResolverImport> resultList = new ArrayList<ResolverImport>(this.imports.length);
        int i = 0;
        while (i < this.imports.length) {
            resultList.add(this.imports[i]);
            ++i;
        }
        for (ResolverBundle fragment : this.fragments) {
            ArrayList fragImports = (ArrayList)this.fragmentImports.get(fragment.bundleID);
            if (fragImports == null) continue;
            resultList.addAll(fragImports);
        }
        return resultList.toArray(new ResolverImport[resultList.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        ArrayList<ResolverExport> resultList = new ArrayList<ResolverExport>(this.exports.length);
        int i = 0;
        while (i < this.exports.length) {
            resultList.add(this.exports[i]);
            ++i;
        }
        for (ResolverBundle fragment : this.fragments) {
            ArrayList fragExports = (ArrayList)this.fragmentExports.get(fragment.bundleID);
            if (fragExports == null) continue;
            resultList.addAll(fragExports);
        }
        return resultList.toArray(new ResolverExport[resultList.size()]);
    }

    ResolverExport[] getSelectedExports() {
        return this.getExports(true);
    }

    ResolverExport[] getSubstitutedExports() {
        return this.getExports(false);
    }

    private ResolverExport[] getExports(boolean selected) {
        ResolverExport[] results = this.getExportPackages();
        int removedExports = 0;
        int i = 0;
        while (i < results.length) {
            if (selected ? results[i].getSubstitute() != null : results[i].getSubstitute() == null) {
                ++removedExports;
            }
            ++i;
        }
        if (removedExports == 0) {
            return results;
        }
        ResolverExport[] selectedExports = new ResolverExport[results.length - removedExports];
        int index = 0;
        int i2 = 0;
        while (i2 < results.length) {
            if (!(selected ? results[i2].getSubstitute() != null : results[i2].getSubstitute() == null)) {
                selectedExports[index] = results[i2];
                ++index;
            }
            ++i2;
        }
        return selectedExports;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    GenericCapability[] getGenericCapabilities() {
        return this.capabilities;
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment()) {
            return new BundleConstraint[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        ArrayList<BundleConstraint> resultList = new ArrayList<BundleConstraint>(this.requires.length);
        int i = 0;
        while (i < this.requires.length) {
            resultList.add(this.requires[i]);
            ++i;
        }
        for (ResolverBundle fragment : this.fragments) {
            ArrayList fragRequires = (ArrayList)this.fragmentRequires.get(fragment.bundleID);
            if (fragRequires == null) continue;
            resultList.addAll(fragRequires);
        }
        return resultList.toArray(new BundleConstraint[resultList.size()]);
    }

    GenericConstraint[] getGenericRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericReqiures;
        }
        ArrayList<GenericConstraint> resultList = new ArrayList<GenericConstraint>(this.genericReqiures.length);
        int i = 0;
        while (i < this.genericReqiures.length) {
            resultList.add(this.genericReqiures[i]);
            ++i;
        }
        for (ResolverBundle fragment : this.fragments) {
            ArrayList fragGenericRegs = (ArrayList)this.fragmentGenericRequires.get(fragment.bundleID);
            if (fragGenericRegs == null) continue;
            resultList.addAll(fragGenericRegs);
        }
        return resultList.toArray(new GenericConstraint[resultList.size()]);
    }

    BundleConstraint getRequire(String name) {
        BundleConstraint[] allRequires = this.getRequires();
        int i = 0;
        while (i < allRequires.length) {
            if (allRequires[i].getVersionConstraint().getName().equals(name)) {
                return allRequires[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public BundleDescription getBundle() {
        return (BundleDescription)this.getBaseDescription();
    }

    @Override
    public ResolverBundle getResolverBundle() {
        return this;
    }

    ResolverImport getImport(String name) {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            if (allImports[i].getName().equals(name)) {
                return allImports[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public String toString() {
        return "[" + this.getBundle() + "]";
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
        if (this.fragmentGenericRequires == null) {
            this.fragmentGenericRequires = new HashMap(1);
        }
    }

    private boolean isImported(String packageName) {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            if (packageName.equals(allImports[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRequired(String bundleName) {
        return this.getRequire(bundleName) != null;
    }

    ResolverExport[] attachFragment(ResolverBundle fragment, boolean dynamicAttach) {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (!this.getBundle().attachFragments() || this.isResolved() && !this.getBundle().dynamicFragments()) {
            return new ResolverExport[0];
        }
        if (fragment.getHost().getNumPossibleSuppliers() > 0 && !((HostSpecification)fragment.getHost().getVersionConstraint()).isMultiHost()) {
            return new ResolverExport[0];
        }
        ImportPackageSpecification[] newImports = fragment.getBundle().getImportPackages();
        BundleSpecification[] newRequires = fragment.getBundle().getRequiredBundles();
        ExportPackageDescription[] newExports = fragment.getBundle().getExportPackages();
        GenericSpecification[] newGenericRequires = fragment.getBundle().getGenericRequires();
        if (dynamicAttach && this.constraintsConflict(fragment.getBundle(), newImports, newRequires, newGenericRequires)) {
            return new ResolverExport[0];
        }
        if (this.isResolved() && newExports.length > 0) {
            fragment.setNewFragmentExports(true);
        }
        this.initFragments();
        for (ResolverBundle existingFragment : this.fragments) {
            String bsn = existingFragment.getName();
            if (bsn == null || !bsn.equals(fragment.getName())) continue;
            return new ResolverExport[0];
        }
        if (this.fragments.contains(fragment)) {
            return new ResolverExport[0];
        }
        this.fragments.add(fragment);
        fragment.getHost().addPossibleSupplier(this);
        if (newImports.length > 0) {
            ArrayList<ResolverImport> hostImports = new ArrayList<ResolverImport>(newImports.length);
            int i = 0;
            while (i < newImports.length) {
                if (!this.isImported(newImports[i].getName())) {
                    hostImports.add(new ResolverImport(this, newImports[i]));
                }
                ++i;
            }
            this.fragmentImports.put(fragment.bundleID, hostImports);
        }
        if (newRequires.length > 0) {
            ArrayList<BundleConstraint> hostRequires = new ArrayList<BundleConstraint>(newRequires.length);
            int i = 0;
            while (i < newRequires.length) {
                if (!this.isRequired(newRequires[i].getName())) {
                    hostRequires.add(new BundleConstraint(this, newRequires[i]));
                }
                ++i;
            }
            this.fragmentRequires.put(fragment.bundleID, hostRequires);
        }
        if (newGenericRequires.length > 0) {
            ArrayList<GenericConstraint> hostGenericRequires = new ArrayList<GenericConstraint>(newGenericRequires.length);
            int i = 0;
            while (i < newGenericRequires.length) {
                hostGenericRequires.add(new GenericConstraint(this, newGenericRequires[i]));
                ++i;
            }
            this.fragmentGenericRequires.put(fragment.bundleID, hostGenericRequires);
        }
        ArrayList<ResolverExport> hostExports = new ArrayList<ResolverExport>(newExports.length);
        if (newExports.length > 0 && dynamicAttach) {
            StateObjectFactory factory = this.resolver.getState().getFactory();
            int i = 0;
            while (i < newExports.length) {
                ResolverExport[] currentExports = this.getExports(newExports[i].getName());
                boolean foundEquivalent = false;
                int j = 0;
                while (j < currentExports.length && !foundEquivalent) {
                    if (this.equivalentExports(currentExports[j], newExports[i])) {
                        foundEquivalent = true;
                    }
                    ++j;
                }
                if (!foundEquivalent) {
                    ExportPackageDescription hostExport = factory.createExportPackageDescription(newExports[i].getName(), newExports[i].getVersion(), newExports[i].getDirectives(), newExports[i].getAttributes(), newExports[i].isRoot(), this.getBundle());
                    hostExports.add(new ResolverExport(this, hostExport));
                }
                ++i;
            }
            this.fragmentExports.put(fragment.bundleID, hostExports);
        }
        return hostExports.toArray(new ResolverExport[hostExports.size()]);
    }

    private boolean equivalentExports(ResolverExport existingExport, ExportPackageDescription newDescription) {
        ExportPackageDescription existingDescription = existingExport.getExportPackageDescription();
        if (!existingDescription.getName().equals(newDescription.getName())) {
            return false;
        }
        if (!existingDescription.getVersion().equals(newDescription.getVersion())) {
            return false;
        }
        if (!this.equivalentMaps(existingDescription.getAttributes(), newDescription.getAttributes())) {
            return false;
        }
        return this.equivalentMaps(existingDescription.getDirectives(), newDescription.getDirectives());
    }

    private boolean equivalentMaps(Map existingDirectives, Map newDirectives) {
        if (existingDirectives == null && newDirectives == null) {
            return true;
        }
        if (existingDirectives == null ? newDirectives != null : newDirectives == null) {
            return false;
        }
        if (existingDirectives.size() != newDirectives.size()) {
            return false;
        }
        for (Map.Entry entry : existingDirectives.entrySet()) {
            Object newValue = newDirectives.get(entry.getKey());
            if (newValue == null || entry.getValue().getClass() != newValue.getClass()) {
                return false;
            }
            if (!(newValue instanceof String[] ? !Arrays.equals((Object[])entry.getValue(), (Object[])newValue) : !entry.getValue().equals(newValue))) continue;
            return false;
        }
        return true;
    }

    boolean constraintsConflict(BundleDescription fragment, ImportPackageSpecification[] newImports, BundleSpecification[] newRequires, GenericSpecification[] newGenericRequires) {
        boolean result = false;
        int i = 0;
        while (i < newImports.length) {
            ResolverImport hostImport = this.getImport(newImports[i].getName());
            ResolverExport resolvedExport = (ResolverExport)(hostImport == null ? null : hostImport.getSelectedSupplier());
            if (resolvedExport == null && this.isResolved() || resolvedExport != null && !newImports[i].isSatisfiedBy(resolvedExport.getExportPackageDescription())) {
                result = true;
                this.resolver.getState().addResolverError(fragment, 16, newImports[i].toString(), newImports[i]);
            }
            ++i;
        }
        i = 0;
        while (i < newRequires.length) {
            BundleConstraint hostRequire = this.getRequire(newRequires[i].getName());
            ResolverBundle resolvedRequire = (ResolverBundle)(hostRequire == null ? null : hostRequire.getSelectedSupplier());
            if (resolvedRequire == null && this.isResolved() || resolvedRequire != null && !newRequires[i].isSatisfiedBy(resolvedRequire.getBundle())) {
                result = true;
                this.resolver.getState().addResolverError(fragment, 16, newRequires[i].toString(), newRequires[i]);
            }
            ++i;
        }
        if (this.isResolved() && newGenericRequires != null && newGenericRequires.length > 0) {
            result = true;
        }
        return result;
    }

    private void setNewFragmentExports(boolean newFragmentExports) {
        this.newFragmentExports = newFragmentExports;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    ResolverExport[] detachFragment(ResolverBundle fragment, ResolverConstraint reason) {
        int i;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        this.initFragments();
        ResolverImport[] oldImports = this.getImportPackages();
        BundleConstraint[] oldRequires = this.getRequires();
        if (!this.fragments.remove(fragment)) {
            return new ResolverExport[0];
        }
        fragment.setNewFragmentExports(false);
        fragment.getHost().removePossibleSupplier(this);
        this.fragmentImports.remove(fragment.bundleID);
        this.fragmentRequires.remove(fragment.bundleID);
        ArrayList removedExports = (ArrayList)this.fragmentExports.remove(fragment.bundleID);
        this.fragmentGenericRequires.remove(fragment.bundleID);
        if (reason != null) {
            ResolverBundle[] remainingFrags = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
            i = 0;
            while (i < remainingFrags.length) {
                ArrayList additionalImports = new ArrayList(0);
                ArrayList additionalRequires = new ArrayList(0);
                if (!this.hasUnresolvedConstraint(reason, fragment, remainingFrags[i], oldImports, oldRequires, additionalImports, additionalRequires)) {
                    if (additionalImports.size() > 0) {
                        ArrayList remainingImports = (ArrayList)this.fragmentImports.get(remainingFrags[i].bundleID);
                        if (remainingImports == null) {
                            this.fragmentImports.put(remainingFrags[i].bundleID, additionalImports);
                        } else {
                            remainingImports.addAll(additionalImports);
                        }
                    }
                    if (additionalRequires.size() > 0) {
                        ArrayList remainingRequires = (ArrayList)this.fragmentRequires.get(remainingFrags[i].bundleID);
                        if (remainingRequires == null) {
                            this.fragmentRequires.put(remainingFrags[i].bundleID, additionalRequires);
                        } else {
                            remainingRequires.addAll(additionalRequires);
                        }
                    }
                }
                ++i;
            }
        }
        ResolverExport[] results = removedExports == null ? new ResolverExport[]{} : removedExports.toArray(new ResolverExport[removedExports.size()]);
        i = 0;
        while (i < results.length) {
            results[i].setSubstitute(results[i]);
            ++i;
        }
        return results;
    }

    private boolean hasUnresolvedConstraint(ResolverConstraint reason, ResolverBundle detachedFragment, ResolverBundle remainingFragment, ResolverImport[] oldImports, BundleConstraint[] oldRequires, ArrayList additionalImports, ArrayList additionalRequires) {
        int j;
        ImportPackageSpecification[] remainingFragImports = remainingFragment.getBundle().getImportPackages();
        BundleSpecification[] remainingFragRequires = remainingFragment.getBundle().getRequiredBundles();
        VersionConstraint[] constraints = reason instanceof ResolverImport ? remainingFragImports : remainingFragRequires;
        int i = 0;
        while (i < constraints.length) {
            if (reason.getName().equals(constraints[i].getName())) {
                this.resolver.getResolverExports().remove(this.detachFragment(remainingFragment, null));
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < oldImports.length) {
            if (oldImports[i].getVersionConstraint().getBundle() == detachedFragment.getBundle()) {
                j = 0;
                while (j < remainingFragImports.length) {
                    if (oldImports[i].getName().equals(remainingFragImports[j].getName())) {
                        additionalImports.add(oldImports[i]);
                        oldImports[i].setVersionConstraint(remainingFragImports[j]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < oldRequires.length) {
            if (oldRequires[i].getVersionConstraint().getBundle() == detachedFragment.getBundle()) {
                j = 0;
                while (j < remainingFragRequires.length) {
                    if (oldRequires[i].getName().equals(remainingFragRequires[j].getName())) {
                        additionalRequires.add(oldRequires[i]);
                        oldRequires[i].setVersionConstraint(remainingFragRequires[j]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] allFragments = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int i = 0;
        while (i < allFragments.length) {
            this.detachFragment(allFragments[i], null);
            ++i;
        }
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean resolvable) {
        this.resolvable = resolvable;
    }

    void addExport(ResolverExport re) {
        ResolverExport[] newExports = new ResolverExport[this.exports.length + 1];
        int i = 0;
        while (i < this.exports.length) {
            newExports[i] = this.exports[i];
            ++i;
        }
        newExports[this.exports.length] = re;
        this.exports = newExports;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }

    void clearRefs() {
        if (this.refs != null) {
            this.refs.clear();
        }
    }

    void addRef(ResolverBundle ref) {
        if (((BundleDescription)this.getBaseDescription()).isResolved()) {
            return;
        }
        if (this.refs != null && !this.refs.contains(ref)) {
            this.refs.add(ref);
        }
    }

    int getRefs() {
        return this.refs == null ? 0 : this.refs.size();
    }

    ResolverBundle[] getFragments() {
        return this.fragments == null ? new ResolverBundle[]{} : this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
    }

    public int compareTo(Object o) {
        String bsn = this.getName();
        String otherBsn = ((ResolverBundle)o).getName();
        if (bsn == null) {
            return otherBsn == null ? 0 : 1;
        }
        return otherBsn == null ? -1 : bsn.compareTo(otherBsn);
    }

    void setUninstalled() {
        this.uninstalled = true;
    }

    boolean isUninstalled() {
        return this.uninstalled;
    }
}

