/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.framework.preferences;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import jp.sourceforge.concierge.contentassist.Word;
import jp.sourceforge.concierge.contentassist.WordList;
import jp.sourceforge.concierge.widget.TextInputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer listviewer = null;
    private ArrayList<String> words = new ArrayList();

    /*
     * Loose catch block
     */
    private ArrayList<String> importWords(String file) {
        ArrayList<String> words = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        fr = new FileReader(new File(file));
        br = new BufferedReader(fr);
        String v = null;
        while ((v = br.readLine()) != null) {
            words.add(v);
        }
        ArrayList<String> arrayList = words;
        try {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
        catch (Throwable throwable) {}
        return arrayList;
        catch (Throwable throwable) {
            ArrayList<String> arrayList2;
            try {
                arrayList2 = words;
            }
            catch (Throwable throwable2) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (Throwable throwable3) {}
                throw throwable2;
            }
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Throwable throwable4) {}
            return arrayList2;
        }
    }

    private void exportWords(String file) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            try {
                fw = new FileWriter(new File(file));
                bw = new BufferedWriter(fw);
                int i = 0;
                while (i < this.words.size()) {
                    bw.write(this.words.get(i));
                    bw.newLine();
                    ++i;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Throwable throwable2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Throwable throwable3) {}
            throw throwable;
        }
        try {
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
        catch (Throwable throwable) {}
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        parent.setLayout((Layout)new GridLayout(1, false));
        Group gr = new Group(parent, 0);
        gr.setLayoutData((Object)new GridData(4, 4, true, true));
        gr.setText("Registered keywords");
        gr.setLayout((Layout)new GridLayout(4, true));
        this.listviewer = new ListViewer((Composite)gr, 514);
        GridData lgd = new GridData(4, 4, true, true);
        lgd.horizontalSpan = 3;
        this.listviewer.getControl().setLayoutData((Object)lgd);
        Composite btns = new Composite((Composite)gr, 0);
        btns.setLayoutData((Object)new GridData(4, 4, false, true));
        btns.setLayout((Layout)new GridLayout(1, false));
        Button abtn = new Button(btns, 0);
        abtn.setText("Add");
        abtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        abtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextInputDialog tid = new TextInputDialog(KeywordPreferencePage.this.listviewer.getControl().getShell(), "Add keyword", "Input keyword");
                if (tid.open() == 1) {
                    return;
                }
                String val = tid.getValue();
                if (KeywordPreferencePage.this.words.contains(val)) {
                    return;
                }
                KeywordPreferencePage.this.words.add(tid.getValue());
                KeywordPreferencePage.this.listviewer.refresh();
            }
        });
        Button ebtn = new Button(btns, 0);
        ebtn.setText("Edit");
        ebtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ebtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection is = (IStructuredSelection)KeywordPreferencePage.this.listviewer.getSelection();
                if (is == null || is.size() != 1) {
                    return;
                }
                TextInputDialog tid = new TextInputDialog(KeywordPreferencePage.this.listviewer.getControl().getShell(), "Add keyword", "Input keyword");
                tid.setValue((String)is.getFirstElement());
                if (tid.open() == 1) {
                    return;
                }
                String newval = tid.getValue();
                if (KeywordPreferencePage.this.words.contains(newval)) {
                    return;
                }
                KeywordPreferencePage.this.words.remove(is.getFirstElement());
                KeywordPreferencePage.this.words.add(newval);
                KeywordPreferencePage.this.listviewer.refresh();
            }
        });
        Button rbtn = new Button(btns, 0);
        rbtn.setText("Remove");
        rbtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        rbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection is = (IStructuredSelection)KeywordPreferencePage.this.listviewer.getSelection();
                if (is == null || is.size() == 0) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)KeywordPreferencePage.this.listviewer.getControl().getShell(), (String)"Remove", (String)"Remove keywords. OK?")) {
                    return;
                }
                Iterator it = is.iterator();
                while (it.hasNext()) {
                    KeywordPreferencePage.this.words.remove(it.next());
                }
                KeywordPreferencePage.this.listviewer.refresh();
            }
        });
        Button ibtn = new Button(btns, 0);
        ibtn.setText("Import");
        ibtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ibtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(KeywordPreferencePage.this.listviewer.getControl().getShell(), 4096);
                fd.setText("Select keyword list file");
                String path = fd.open();
                if (path == null) {
                    return;
                }
                ArrayList wds = KeywordPreferencePage.this.importWords(path);
                if (wds.size() == 0) {
                    return;
                }
                int i = 0;
                while (i < wds.size()) {
                    if (!KeywordPreferencePage.this.words.contains(wds.get(i))) {
                        KeywordPreferencePage.this.words.add((String)wds.get(i));
                    }
                    ++i;
                }
                KeywordPreferencePage.this.listviewer.refresh();
            }
        });
        Button exbtn = new Button(btns, 0);
        exbtn.setText("Export");
        exbtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        exbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(KeywordPreferencePage.this.listviewer.getControl().getShell(), 8192);
                fd.setText("Input keyword list file name");
                String path = fd.open();
                if (path == null) {
                    return;
                }
                KeywordPreferencePage.this.exportWords(path);
            }
        });
        this.listviewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.listviewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.listviewer.setSorter(new ViewerSorter());
        this.listviewer.setInput(this.words);
        return parent;
    }

    public void init(IWorkbench workbench) {
        this.words.clear();
        ArrayList<Word> wds = WordList.getAllWords(true);
        int i = 0;
        while (i < wds.size()) {
            this.words.add(wds.get(i).getWord());
            ++i;
        }
    }

    public boolean performOk() {
        WordList.removeAllRegisteredWord();
        int i = 0;
        while (i < this.words.size()) {
            WordList.addWordAsRegistered(this.words.get(i));
            ++i;
        }
        return super.performOk();
    }

    private class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ListLabelProvider
    implements ILabelProvider {
        private ListLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

