﻿module coneneko.dwtwindow;
public import
	coneneko.scenegraph, coneneko.units, coneneko.math,
	coneneko.glext, coneneko.nanami, coneneko.exunits, coneneko.texture,
	dwt.all, dwt.opengl.all;

private alias coneneko.scenegraph.Event Event;
private alias coneneko.exunits.Text Text;

/// できるだけautoで
class DwtWindow : Shell, Window
{
	alias Display.getDefault display;
	
	protected GlCanvas canvas; ///
	
	///
	this()
	{
		setSize(640, 480);
		initialize();
		Timer timer = new Timer(display);
		new Disposer(this, &timer.dispose);
		open();
	}
	
	~this()
	{
		display.dispose();
	}
	
	/// setLayout, canvas作成
	protected void initialize()
	{
		setLayout(new FillLayout());
		canvas = new GlCanvas(this);
	}
	
	void draw(Node a)
	{
		if (isDisposed) return;
		canvas.context.setCurrent();
		Unit vp = new Viewport(0, 0, width, height);
		vp.attach();
		a();
		vp.detach();
	}
	
	void flip()
	{
		if (isDisposed) return;
		canvas.context.setCurrent();
		canvas.context.swapBuffers();
		if (!display.readAndDispatch()) display.sleep();
	}
	
	bool alive()
	{
		return isDisposed() ? false : true;
	}
	
	uint width()
	{
		return canvas.getClientArea().width;
	}
	
	uint height()
	{
		return canvas.getClientArea().height;
	}
	
	
	private DwtEvent[] events;
	
	void opCatAssign(Event e)
	{
		DwtEvent de = cast(DwtEvent)e;
		if (!de) exception(__FILE__, __LINE__, this);
		de.attach(canvas);
		events ~= de;
	}
	
	void clearEvents()
	{
		if (isDisposed) return;
		foreach (DwtEvent a; events) a.detach(canvas);
		events = null;
	}
	
	Event popReachedEvent()
	{
		foreach (DwtEvent a; events)
		{
			if (a.popFlag()) return a;
		}
		return null;
	}
	
	
	///
	GLContext context()
	{
		return canvas.context;
	}
	
	
	MousePoint mousePoint()
	{
		return new class MousePoint
		{
			Point p;
			
			void update()
			{
				p = display.map(null, canvas, display.getCursorLocation());
			}
			
			int x()
			{
				update();
				return p.x;
			}
			
			int y()
			{
				update();
				return p.y;
			}
		};
	}
}

class Timer : Runnable
{
	private Display display;
	
	this(Display display)
	{
		this.display = display;
		run();
	}
	
	void run()
	{
		display.timerExec(1000 / 60, this);
	}
	
	void dispose()
	{
		display.timerExec(-1, this);
	}
}

private class GlCanvas : Canvas
{
	GLContext context;
	
	this(Shell parent)
	{
		super(parent, DWT.NONE);
		context = new GLContext(this);
		context.setCurrent();
		new Disposer(this, &context.dispose);
	}
}

private class Disposer : DisposeListener
{
	private final void delegate() execute;
	
	this(Control client, void delegate() execute)
	{
		this.execute = execute;
		client.addDisposeListener(this);
	}
	
	void widgetDisposed(DisposeEvent e)
	{
		execute();
	}
}

///
abstract class DwtEvent : Event
{
	void attach(Control owner); ///
	void detach(Control owner); ///
	bool popFlag(); ///
}

///
class DwtClickEvent : DwtEvent, MouseListener
{
	private int x, y, width, height;
	private bool flag = false;
	
	///
	this(int x, int y, int width, int height)
	{
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}
	
	void attach(Control owner)
	{
		owner.addMouseListener(this);
	}
	
	void detach(Control owner)
	{
		owner.removeMouseListener(this);
	}
	
	bool popFlag()
	{
		bool result = flag;
		flag = false;
		return result;
	}
	
	void mouseDown(MouseEvent e)
	{
		if (e.button == 1
			&& x <= e.x && e.x <= x + width
			&& y <= e.y && e.y <= y + height) flag = true;
	}
	
	void mouseDoubleClick(MouseEvent e) {}
	void mouseUp(MouseEvent e) {}
}

/// 左上(0, 0)、右下(800, 600)
class DwtClickEvent800x600 : DwtClickEvent, MouseMoveListener
{
	private Control owner;
	protected Point mousePoint;
	private void delegate() onClick;
	
	///
	this(int x, int y, int width, int height, void delegate() onClick = null)
	{
		super(x, y, width, height);
		mousePoint = new Point(0, 0);
		this.onClick = onClick;
	}
	
	override void attach(Control owner)
	{
		this.owner = owner;
		super.attach(owner);
		owner.addMouseMoveListener(this);
	}
	
	override void detach(Control owner)
	{
		super.detach(owner);
		owner.removeMouseMoveListener(this);
	}
	
	override void mouseDown(MouseEvent e)
	{
		if (e.button == 1 && isInner(e.x, e.y))
		{
			flag = true;
			if (onClick) onClick();
		}
	}
	
	protected bool isInner(int mouseX, int mouseY)
	{
		int canvasWidth = owner.getBounds().width;
		int canvasHeight = owner.getBounds().height;
		int x2 = x * canvasWidth / 800;
		int y2 = y * canvasHeight / 600;
		int width2 = width * canvasWidth / 800;
		int height2 = height * canvasHeight / 600;
		return x2 <= mouseX && mouseX <= x2 + width2
			&& y2 <= mouseY && mouseY <= y2 + height2;
	}
	
	void mouseMove(MouseEvent e)
	{
		mousePoint.x = e.x;
		mousePoint.y = e.y;
	}
}

/// 97 == 'a' CapsLockの影響を受けない
class DwtKeyDownEvent : DwtEvent, KeyListener
{
	static assert(97 == 'a');
	
	private final int keyCode;
	private bool flag = false;
	
	///
	this(int keyCode)
	{
		this.keyCode = keyCode;
	}
	
	void attach(Control owner)
	{
		owner.addKeyListener(this);
	}
	
	void detach(Control owner)
	{
		owner.removeKeyListener(this);
	}
	
	bool popFlag()
	{
		bool result = flag;
		flag = false;
		return result;
	}
	
	void keyPressed(KeyEvent e)
	{
		if (e.keyCode == keyCode) flag = true;
	}
	
	void keyReleased(KeyEvent e) {}
}

class DwtButtonEventFactory : ButtonEventFactory
{
	private DwtWindow wnd;
	
	this(DwtWindow wnd)
	{
		this.wnd = wnd;
	}
	
	Event create(int x, int y, int width, int height, void delegate() onClick)
	{
		return new DwtClickEvent800x600(x, y, width, height, onClick);
	}
	
	VirtualMousePoint virtualMousePoint()
	{
		return new VirtualMousePoint(wnd);
	}
}
