module coneneko.glext;
import std.string;
version (DWT_WINDOW)
{
	public import dwt.opengl.all;
}
else
{
	public import opengl, openglu;
}
extern(Windows):
void* wglGetProcAddress(char* proc);
private void loadGlextFunctions(void** f, char[] name)
{
	*f = wglGetProcAddress(toStringz(name));
}

//GL_ARB_vertex_buffer_object
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/vertex_buffer_object.txt
const GLenum GL_BUFFER_SIZE_ARB = 0x8764;
const GLenum GL_BUFFER_USAGE_ARB = 0x8765;
const GLenum GL_ARRAY_BUFFER_ARB = 0x8892;
const GLenum GL_ELEMENT_ARRAY_BUFFER_ARB = 0x8893;
const GLenum GL_ARRAY_BUFFER_BINDING_ARB = 0x8894;
const GLenum GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 0x8895;
const GLenum GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 0x8896;
const GLenum GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 0x8897;
const GLenum GL_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x8898;
const GLenum GL_INDEX_ARRAY_BUFFER_BINDING_ARB = 0x8899;
const GLenum GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 0x889A;
const GLenum GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 0x889B;
const GLenum GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x889C;
const GLenum GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 0x889D;
const GLenum GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 0x889E;
const GLenum GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 0x889F;
const GLenum GL_READ_ONLY_ARB = 0x88B8;
const GLenum GL_WRITE_ONLY_ARB = 0x88B9;
const GLenum GL_READ_WRITE_ARB = 0x88BA;
const GLenum GL_BUFFER_ACCESS_ARB = 0x88BB;
const GLenum GL_BUFFER_MAPPED_ARB = 0x88BC;
const GLenum GL_BUFFER_MAP_POINTER_ARB = 0x88BD;
const GLenum GL_STREAM_DRAW_ARB = 0x88E0;
const GLenum GL_STREAM_READ_ARB = 0x88E1;
const GLenum GL_STREAM_COPY_ARB = 0x88E2;
const GLenum GL_STATIC_DRAW_ARB = 0x88E4;
const GLenum GL_STATIC_READ_ARB = 0x88E5;
const GLenum GL_STATIC_COPY_ARB = 0x88E6;
const GLenum GL_DYNAMIC_DRAW_ARB = 0x88E8;
const GLenum GL_DYNAMIC_READ_ARB = 0x88E9;
const GLenum GL_DYNAMIC_COPY_ARB = 0x88EA;
void function (GLenum target, GLuint buffer) glBindBufferARB;
void function (GLenum target, GLsizeiptrARB size,  GLvoid* data, GLenum usage) glBufferDataARB;
void function (GLenum target, GLintptrARB offset, GLsizeiptrARB size,  GLvoid* data) glBufferSubDataARB;
void function (GLsizei n,  GLuint* buffers) glDeleteBuffersARB;
void function (GLsizei n, GLuint* buffers) glGenBuffersARB;
void function (GLenum target, GLenum pname, GLint* params) glGetBufferParameterivARB;
void function (GLenum target, GLenum pname, GLvoid** params) glGetBufferPointervARB;
void function (GLenum target, GLintptrARB offset, GLsizeiptrARB size, GLvoid* data) glGetBufferSubDataARB;
GLboolean function (GLuint buffer) glIsBufferARB;
GLvoid * function (GLenum target, GLenum access) glMapBufferARB;
GLboolean function (GLenum target) glUnmapBufferARB;
alias ptrdiff_t GLsizeiptrARB;
alias ptrdiff_t GLintptrARB;

void load_GL_ARB_vertex_buffer_object() /// loader
{
	loadGlextFunctions(cast(void**)&glBindBufferARB, "glBindBufferARB");
	loadGlextFunctions(cast(void**)&glBufferDataARB, "glBufferDataARB");
	loadGlextFunctions(cast(void**)&glBufferSubDataARB, "glBufferSubDataARB");
	loadGlextFunctions(cast(void**)&glDeleteBuffersARB, "glDeleteBuffersARB");
	loadGlextFunctions(cast(void**)&glGenBuffersARB, "glGenBuffersARB");
	loadGlextFunctions(cast(void**)&glGetBufferParameterivARB, "glGetBufferParameterivARB");
	loadGlextFunctions(cast(void**)&glGetBufferPointervARB, "glGetBufferPointervARB");
	loadGlextFunctions(cast(void**)&glGetBufferSubDataARB, "glGetBufferSubDataARB");
	loadGlextFunctions(cast(void**)&glIsBufferARB, "glIsBufferARB");
	loadGlextFunctions(cast(void**)&glMapBufferARB, "glMapBufferARB");
	loadGlextFunctions(cast(void**)&glUnmapBufferARB, "glUnmapBufferARB");
}

//GL_ARB_vertex_program
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/vertex_program.txt
const GLenum GL_COLOR_SUM_ARB = 0x8458;
const GLenum GL_VERTEX_PROGRAM_ARB = 0x8620;
const GLenum GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = 0x8622;
const GLenum GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = 0x8623;
const GLenum GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = 0x8624;
const GLenum GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = 0x8625;
const GLenum GL_CURRENT_VERTEX_ATTRIB_ARB = 0x8626;
const GLenum GL_PROGRAM_LENGTH_ARB = 0x8627;
const GLenum GL_PROGRAM_STRING_ARB = 0x8628;
const GLenum GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E;
const GLenum GL_MAX_PROGRAM_MATRICES_ARB = 0x862F;
const GLenum GL_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640;
const GLenum GL_CURRENT_MATRIX_ARB = 0x8641;
const GLenum GL_VERTEX_PROGRAM_POINT_SIZE_ARB = 0x8642;
const GLenum GL_VERTEX_PROGRAM_TWO_SIDE_ARB = 0x8643;
const GLenum GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = 0x8645;
const GLenum GL_PROGRAM_ERROR_POSITION_ARB = 0x864B;
const GLenum GL_PROGRAM_BINDING_ARB = 0x8677;
const GLenum GL_MAX_VERTEX_ATTRIBS_ARB = 0x8869;
const GLenum GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = 0x886A;
const GLenum GL_PROGRAM_ERROR_STRING_ARB = 0x8874;
const GLenum GL_PROGRAM_FORMAT_ASCII_ARB = 0x8875;
const GLenum GL_PROGRAM_FORMAT_ARB = 0x8876;
const GLenum GL_PROGRAM_INSTRUCTIONS_ARB = 0x88A0;
const GLenum GL_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1;
const GLenum GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2;
const GLenum GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3;
const GLenum GL_PROGRAM_TEMPORARIES_ARB = 0x88A4;
const GLenum GL_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5;
const GLenum GL_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6;
const GLenum GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7;
const GLenum GL_PROGRAM_PARAMETERS_ARB = 0x88A8;
const GLenum GL_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9;
const GLenum GL_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA;
const GLenum GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB;
const GLenum GL_PROGRAM_ATTRIBS_ARB = 0x88AC;
const GLenum GL_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD;
const GLenum GL_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE;
const GLenum GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF;
const GLenum GL_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B0;
const GLenum GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B1;
const GLenum GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B2;
const GLenum GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B3;
const GLenum GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4;
const GLenum GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5;
const GLenum GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6;
const GLenum GL_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7;
const GLenum GL_MATRIX0_ARB = 0x88C0;
const GLenum GL_MATRIX1_ARB = 0x88C1;
const GLenum GL_MATRIX2_ARB = 0x88C2;
const GLenum GL_MATRIX3_ARB = 0x88C3;
const GLenum GL_MATRIX4_ARB = 0x88C4;
const GLenum GL_MATRIX5_ARB = 0x88C5;
const GLenum GL_MATRIX6_ARB = 0x88C6;
const GLenum GL_MATRIX7_ARB = 0x88C7;
const GLenum GL_MATRIX8_ARB = 0x88C8;
const GLenum GL_MATRIX9_ARB = 0x88C9;
const GLenum GL_MATRIX10_ARB = 0x88CA;
const GLenum GL_MATRIX11_ARB = 0x88CB;
const GLenum GL_MATRIX12_ARB = 0x88CC;
const GLenum GL_MATRIX13_ARB = 0x88CD;
const GLenum GL_MATRIX14_ARB = 0x88CE;
const GLenum GL_MATRIX15_ARB = 0x88CF;
const GLenum GL_MATRIX16_ARB = 0x88D0;
const GLenum GL_MATRIX17_ARB = 0x88D1;
const GLenum GL_MATRIX18_ARB = 0x88D2;
const GLenum GL_MATRIX19_ARB = 0x88D3;
const GLenum GL_MATRIX20_ARB = 0x88D4;
const GLenum GL_MATRIX21_ARB = 0x88D5;
const GLenum GL_MATRIX22_ARB = 0x88D6;
const GLenum GL_MATRIX23_ARB = 0x88D7;
const GLenum GL_MATRIX24_ARB = 0x88D8;
const GLenum GL_MATRIX25_ARB = 0x88D9;
const GLenum GL_MATRIX26_ARB = 0x88DA;
const GLenum GL_MATRIX27_ARB = 0x88DB;
const GLenum GL_MATRIX28_ARB = 0x88DC;
const GLenum GL_MATRIX29_ARB = 0x88DD;
const GLenum GL_MATRIX30_ARB = 0x88DE;
const GLenum GL_MATRIX31_ARB = 0x88DF;
void function (GLenum target, GLuint program) glBindProgramARB;
void function (GLsizei n,  GLuint* programs) glDeleteProgramsARB;
void function (GLuint index) glDisableVertexAttribArrayARB;
void function (GLuint index) glEnableVertexAttribArrayARB;
void function (GLsizei n, GLuint* programs) glGenProgramsARB;
void function (GLenum target, GLuint index, GLdouble* params) glGetProgramEnvParameterdvARB;
void function (GLenum target, GLuint index, GLfloat* params) glGetProgramEnvParameterfvARB;
void function (GLenum target, GLuint index, GLdouble* params) glGetProgramLocalParameterdvARB;
void function (GLenum target, GLuint index, GLfloat* params) glGetProgramLocalParameterfvARB;
void function (GLenum target, GLenum pname, void* string) glGetProgramStringARB;
void function (GLenum target, GLenum pname, GLint* params) glGetProgramivARB;
void function (GLuint index, GLenum pname, GLvoid** pointer) glGetVertexAttribPointervARB;
void function (GLuint index, GLenum pname, GLdouble* params) glGetVertexAttribdvARB;
void function (GLuint index, GLenum pname, GLfloat* params) glGetVertexAttribfvARB;
void function (GLuint index, GLenum pname, GLint* params) glGetVertexAttribivARB;
GLboolean function (GLuint program) glIsProgramARB;
void function (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) glProgramEnvParameter4dARB;
void function (GLenum target, GLuint index,  GLdouble* params) glProgramEnvParameter4dvARB;
void function (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) glProgramEnvParameter4fARB;
void function (GLenum target, GLuint index,  GLfloat* params) glProgramEnvParameter4fvARB;
void function (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) glProgramLocalParameter4dARB;
void function (GLenum target, GLuint index,  GLdouble* params) glProgramLocalParameter4dvARB;
void function (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) glProgramLocalParameter4fARB;
void function (GLenum target, GLuint index,  GLfloat* params) glProgramLocalParameter4fvARB;
void function (GLenum target, GLenum format, GLsizei len,  void* string) glProgramStringARB;
void function (GLuint index, GLdouble x) glVertexAttrib1dARB;
void function (GLuint index,  GLdouble* v) glVertexAttrib1dvARB;
void function (GLuint index, GLfloat x) glVertexAttrib1fARB;
void function (GLuint index,  GLfloat* v) glVertexAttrib1fvARB;
void function (GLuint index, GLshort x) glVertexAttrib1sARB;
void function (GLuint index,  GLshort* v) glVertexAttrib1svARB;
void function (GLuint index, GLdouble x, GLdouble y) glVertexAttrib2dARB;
void function (GLuint index,  GLdouble* v) glVertexAttrib2dvARB;
void function (GLuint index, GLfloat x, GLfloat y) glVertexAttrib2fARB;
void function (GLuint index,  GLfloat* v) glVertexAttrib2fvARB;
void function (GLuint index, GLshort x, GLshort y) glVertexAttrib2sARB;
void function (GLuint index,  GLshort* v) glVertexAttrib2svARB;
void function (GLuint index, GLdouble x, GLdouble y, GLdouble z) glVertexAttrib3dARB;
void function (GLuint index,  GLdouble* v) glVertexAttrib3dvARB;
void function (GLuint index, GLfloat x, GLfloat y, GLfloat z) glVertexAttrib3fARB;
void function (GLuint index,  GLfloat* v) glVertexAttrib3fvARB;
void function (GLuint index, GLshort x, GLshort y, GLshort z) glVertexAttrib3sARB;
void function (GLuint index,  GLshort* v) glVertexAttrib3svARB;
void function (GLuint index,  GLbyte* v) glVertexAttrib4NbvARB;
void function (GLuint index,  GLint* v) glVertexAttrib4NivARB;
void function (GLuint index,  GLshort* v) glVertexAttrib4NsvARB;
void function (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) glVertexAttrib4NubARB;
void function (GLuint index,  GLubyte* v) glVertexAttrib4NubvARB;
void function (GLuint index,  GLuint* v) glVertexAttrib4NuivARB;
void function (GLuint index,  GLushort* v) glVertexAttrib4NusvARB;
void function (GLuint index,  GLbyte* v) glVertexAttrib4bvARB;
void function (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) glVertexAttrib4dARB;
void function (GLuint index,  GLdouble* v) glVertexAttrib4dvARB;
void function (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) glVertexAttrib4fARB;
void function (GLuint index,  GLfloat* v) glVertexAttrib4fvARB;
void function (GLuint index,  GLint* v) glVertexAttrib4ivARB;
void function (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) glVertexAttrib4sARB;
void function (GLuint index,  GLshort* v) glVertexAttrib4svARB;
void function (GLuint index,  GLubyte* v) glVertexAttrib4ubvARB;
void function (GLuint index,  GLuint* v) glVertexAttrib4uivARB;
void function (GLuint index,  GLushort* v) glVertexAttrib4usvARB;
void function (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride,  void* pointer) glVertexAttribPointerARB;

void load_GL_ARB_vertex_program() /// loader
{
	loadGlextFunctions(cast(void**)&glBindProgramARB, "glBindProgramARB");
	loadGlextFunctions(cast(void**)&glDeleteProgramsARB, "glDeleteProgramsARB");
	loadGlextFunctions(cast(void**)&glDisableVertexAttribArrayARB, "glDisableVertexAttribArrayARB");
	loadGlextFunctions(cast(void**)&glEnableVertexAttribArrayARB, "glEnableVertexAttribArrayARB");
	loadGlextFunctions(cast(void**)&glGenProgramsARB, "glGenProgramsARB");
	loadGlextFunctions(cast(void**)&glGetProgramEnvParameterdvARB, "glGetProgramEnvParameterdvARB");
	loadGlextFunctions(cast(void**)&glGetProgramEnvParameterfvARB, "glGetProgramEnvParameterfvARB");
	loadGlextFunctions(cast(void**)&glGetProgramLocalParameterdvARB, "glGetProgramLocalParameterdvARB");
	loadGlextFunctions(cast(void**)&glGetProgramLocalParameterfvARB, "glGetProgramLocalParameterfvARB");
	loadGlextFunctions(cast(void**)&glGetProgramStringARB, "glGetProgramStringARB");
	loadGlextFunctions(cast(void**)&glGetProgramivARB, "glGetProgramivARB");
	loadGlextFunctions(cast(void**)&glGetVertexAttribPointervARB, "glGetVertexAttribPointervARB");
	loadGlextFunctions(cast(void**)&glGetVertexAttribdvARB, "glGetVertexAttribdvARB");
	loadGlextFunctions(cast(void**)&glGetVertexAttribfvARB, "glGetVertexAttribfvARB");
	loadGlextFunctions(cast(void**)&glGetVertexAttribivARB, "glGetVertexAttribivARB");
	loadGlextFunctions(cast(void**)&glIsProgramARB, "glIsProgramARB");
	loadGlextFunctions(cast(void**)&glProgramEnvParameter4dARB, "glProgramEnvParameter4dARB");
	loadGlextFunctions(cast(void**)&glProgramEnvParameter4dvARB, "glProgramEnvParameter4dvARB");
	loadGlextFunctions(cast(void**)&glProgramEnvParameter4fARB, "glProgramEnvParameter4fARB");
	loadGlextFunctions(cast(void**)&glProgramEnvParameter4fvARB, "glProgramEnvParameter4fvARB");
	loadGlextFunctions(cast(void**)&glProgramLocalParameter4dARB, "glProgramLocalParameter4dARB");
	loadGlextFunctions(cast(void**)&glProgramLocalParameter4dvARB, "glProgramLocalParameter4dvARB");
	loadGlextFunctions(cast(void**)&glProgramLocalParameter4fARB, "glProgramLocalParameter4fARB");
	loadGlextFunctions(cast(void**)&glProgramLocalParameter4fvARB, "glProgramLocalParameter4fvARB");
	loadGlextFunctions(cast(void**)&glProgramStringARB, "glProgramStringARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib1dARB, "glVertexAttrib1dARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib1dvARB, "glVertexAttrib1dvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib1fARB, "glVertexAttrib1fARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib1fvARB, "glVertexAttrib1fvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib1sARB, "glVertexAttrib1sARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib1svARB, "glVertexAttrib1svARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib2dARB, "glVertexAttrib2dARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib2dvARB, "glVertexAttrib2dvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib2fARB, "glVertexAttrib2fARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib2fvARB, "glVertexAttrib2fvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib2sARB, "glVertexAttrib2sARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib2svARB, "glVertexAttrib2svARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib3dARB, "glVertexAttrib3dARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib3dvARB, "glVertexAttrib3dvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib3fARB, "glVertexAttrib3fARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib3fvARB, "glVertexAttrib3fvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib3sARB, "glVertexAttrib3sARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib3svARB, "glVertexAttrib3svARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NbvARB, "glVertexAttrib4NbvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NivARB, "glVertexAttrib4NivARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NsvARB, "glVertexAttrib4NsvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NubARB, "glVertexAttrib4NubARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NubvARB, "glVertexAttrib4NubvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NuivARB, "glVertexAttrib4NuivARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4NusvARB, "glVertexAttrib4NusvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4bvARB, "glVertexAttrib4bvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4dARB, "glVertexAttrib4dARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4dvARB, "glVertexAttrib4dvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4fARB, "glVertexAttrib4fARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4fvARB, "glVertexAttrib4fvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4ivARB, "glVertexAttrib4ivARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4sARB, "glVertexAttrib4sARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4svARB, "glVertexAttrib4svARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4ubvARB, "glVertexAttrib4ubvARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4uivARB, "glVertexAttrib4uivARB");
	loadGlextFunctions(cast(void**)&glVertexAttrib4usvARB, "glVertexAttrib4usvARB");
	loadGlextFunctions(cast(void**)&glVertexAttribPointerARB, "glVertexAttribPointerARB");
}

//GL_ARB_shader_objects
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/shader_objects.txt
const GLenum GL_PROGRAM_OBJECT_ARB = 0x8B40;
const GLenum GL_SHADER_OBJECT_ARB = 0x8B48;
const GLenum GL_OBJECT_TYPE_ARB = 0x8B4E;
const GLenum GL_OBJECT_SUBTYPE_ARB = 0x8B4F;
const GLenum GL_FLOAT_VEC2_ARB = 0x8B50;
const GLenum GL_FLOAT_VEC3_ARB = 0x8B51;
const GLenum GL_FLOAT_VEC4_ARB = 0x8B52;
const GLenum GL_INT_VEC2_ARB = 0x8B53;
const GLenum GL_INT_VEC3_ARB = 0x8B54;
const GLenum GL_INT_VEC4_ARB = 0x8B55;
const GLenum GL_BOOL_ARB = 0x8B56;
const GLenum GL_BOOL_VEC2_ARB = 0x8B57;
const GLenum GL_BOOL_VEC3_ARB = 0x8B58;
const GLenum GL_BOOL_VEC4_ARB = 0x8B59;
const GLenum GL_FLOAT_MAT2_ARB = 0x8B5A;
const GLenum GL_FLOAT_MAT3_ARB = 0x8B5B;
const GLenum GL_FLOAT_MAT4_ARB = 0x8B5C;
const GLenum GL_SAMPLER_1D_ARB = 0x8B5D;
const GLenum GL_SAMPLER_2D_ARB = 0x8B5E;
const GLenum GL_SAMPLER_3D_ARB = 0x8B5F;
const GLenum GL_SAMPLER_CUBE_ARB = 0x8B60;
const GLenum GL_SAMPLER_1D_SHADOW_ARB = 0x8B61;
const GLenum GL_SAMPLER_2D_SHADOW_ARB = 0x8B62;
const GLenum GL_SAMPLER_2D_RECT_ARB = 0x8B63;
const GLenum GL_SAMPLER_2D_RECT_SHADOW_ARB = 0x8B64;
const GLenum GL_OBJECT_DELETE_STATUS_ARB = 0x8B80;
const GLenum GL_OBJECT_COMPILE_STATUS_ARB = 0x8B81;
const GLenum GL_OBJECT_LINK_STATUS_ARB = 0x8B82;
const GLenum GL_OBJECT_VALIDATE_STATUS_ARB = 0x8B83;
const GLenum GL_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84;
const GLenum GL_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85;
const GLenum GL_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86;
const GLenum GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87;
const GLenum GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88;
void function (GLhandleARB containerObj, GLhandleARB obj) glAttachObjectARB;
void function (GLhandleARB shaderObj) glCompileShaderARB;
GLhandleARB function () glCreateProgramObjectARB;
GLhandleARB function (GLenum shaderType) glCreateShaderObjectARB;
void function (GLhandleARB obj) glDeleteObjectARB;
void function (GLhandleARB containerObj, GLhandleARB attachedObj) glDetachObjectARB;
void function (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei* length, GLint *size, GLenum *type, GLcharARB *name) glGetActiveUniformARB;
void function (GLhandleARB containerObj, GLsizei maxCount, GLsizei* count, GLhandleARB *obj) glGetAttachedObjectsARB;
GLhandleARB function (GLenum pname) glGetHandleARB;
void function (GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB *infoLog) glGetInfoLogARB;
void function (GLhandleARB obj, GLenum pname, GLfloat* params) glGetObjectParameterfvARB;
void function (GLhandleARB obj, GLenum pname, GLint* params) glGetObjectParameterivARB;
void function (GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB *source) glGetShaderSourceARB;
GLint function (GLhandleARB programObj,  GLcharARB* name) glGetUniformLocationARB;
void function (GLhandleARB programObj, GLint location, GLfloat* params) glGetUniformfvARB;
void function (GLhandleARB programObj, GLint location, GLint* params) glGetUniformivARB;
void function (GLhandleARB programObj) glLinkProgramARB;
void function (GLhandleARB shaderObj, GLsizei count,  GLcharARB ** string,  GLint *length) glShaderSourceARB;
void function (GLint location, GLfloat v0) glUniform1fARB;
void function (GLint location, GLsizei count,  GLfloat* value) glUniform1fvARB;
void function (GLint location, GLint v0) glUniform1iARB;
void function (GLint location, GLsizei count,  GLint* value) glUniform1ivARB;
void function (GLint location, GLfloat v0, GLfloat v1) glUniform2fARB;
void function (GLint location, GLsizei count,  GLfloat* value) glUniform2fvARB;
void function (GLint location, GLint v0, GLint v1) glUniform2iARB;
void function (GLint location, GLsizei count,  GLint* value) glUniform2ivARB;
void function (GLint location, GLfloat v0, GLfloat v1, GLfloat v2) glUniform3fARB;
void function (GLint location, GLsizei count,  GLfloat* value) glUniform3fvARB;
void function (GLint location, GLint v0, GLint v1, GLint v2) glUniform3iARB;
void function (GLint location, GLsizei count,  GLint* value) glUniform3ivARB;
void function (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) glUniform4fARB;
void function (GLint location, GLsizei count,  GLfloat* value) glUniform4fvARB;
void function (GLint location, GLint v0, GLint v1, GLint v2, GLint v3) glUniform4iARB;
void function (GLint location, GLsizei count,  GLint* value) glUniform4ivARB;
void function (GLint location, GLsizei count, GLboolean transpose,  GLfloat* value) glUniformMatrix2fvARB;
void function (GLint location, GLsizei count, GLboolean transpose,  GLfloat* value) glUniformMatrix3fvARB;
void function (GLint location, GLsizei count, GLboolean transpose,  GLfloat* value) glUniformMatrix4fvARB;
void function (GLhandleARB programObj) glUseProgramObjectARB;
void function (GLhandleARB programObj) glValidateProgramARB;
alias char GLcharARB;
alias uint GLhandleARB;

void load_GL_ARB_shader_objects() /// loader
{
	loadGlextFunctions(cast(void**)&glAttachObjectARB, "glAttachObjectARB");
	loadGlextFunctions(cast(void**)&glCompileShaderARB, "glCompileShaderARB");
	loadGlextFunctions(cast(void**)&glCreateProgramObjectARB, "glCreateProgramObjectARB");
	loadGlextFunctions(cast(void**)&glCreateShaderObjectARB, "glCreateShaderObjectARB");
	loadGlextFunctions(cast(void**)&glDeleteObjectARB, "glDeleteObjectARB");
	loadGlextFunctions(cast(void**)&glDetachObjectARB, "glDetachObjectARB");
	loadGlextFunctions(cast(void**)&glGetActiveUniformARB, "glGetActiveUniformARB");
	loadGlextFunctions(cast(void**)&glGetAttachedObjectsARB, "glGetAttachedObjectsARB");
	loadGlextFunctions(cast(void**)&glGetHandleARB, "glGetHandleARB");
	loadGlextFunctions(cast(void**)&glGetInfoLogARB, "glGetInfoLogARB");
	loadGlextFunctions(cast(void**)&glGetObjectParameterfvARB, "glGetObjectParameterfvARB");
	loadGlextFunctions(cast(void**)&glGetObjectParameterivARB, "glGetObjectParameterivARB");
	loadGlextFunctions(cast(void**)&glGetShaderSourceARB, "glGetShaderSourceARB");
	loadGlextFunctions(cast(void**)&glGetUniformLocationARB, "glGetUniformLocationARB");
	loadGlextFunctions(cast(void**)&glGetUniformfvARB, "glGetUniformfvARB");
	loadGlextFunctions(cast(void**)&glGetUniformivARB, "glGetUniformivARB");
	loadGlextFunctions(cast(void**)&glLinkProgramARB, "glLinkProgramARB");
	loadGlextFunctions(cast(void**)&glShaderSourceARB, "glShaderSourceARB");
	loadGlextFunctions(cast(void**)&glUniform1fARB, "glUniform1fARB");
	loadGlextFunctions(cast(void**)&glUniform1fvARB, "glUniform1fvARB");
	loadGlextFunctions(cast(void**)&glUniform1iARB, "glUniform1iARB");
	loadGlextFunctions(cast(void**)&glUniform1ivARB, "glUniform1ivARB");
	loadGlextFunctions(cast(void**)&glUniform2fARB, "glUniform2fARB");
	loadGlextFunctions(cast(void**)&glUniform2fvARB, "glUniform2fvARB");
	loadGlextFunctions(cast(void**)&glUniform2iARB, "glUniform2iARB");
	loadGlextFunctions(cast(void**)&glUniform2ivARB, "glUniform2ivARB");
	loadGlextFunctions(cast(void**)&glUniform3fARB, "glUniform3fARB");
	loadGlextFunctions(cast(void**)&glUniform3fvARB, "glUniform3fvARB");
	loadGlextFunctions(cast(void**)&glUniform3iARB, "glUniform3iARB");
	loadGlextFunctions(cast(void**)&glUniform3ivARB, "glUniform3ivARB");
	loadGlextFunctions(cast(void**)&glUniform4fARB, "glUniform4fARB");
	loadGlextFunctions(cast(void**)&glUniform4fvARB, "glUniform4fvARB");
	loadGlextFunctions(cast(void**)&glUniform4iARB, "glUniform4iARB");
	loadGlextFunctions(cast(void**)&glUniform4ivARB, "glUniform4ivARB");
	loadGlextFunctions(cast(void**)&glUniformMatrix2fvARB, "glUniformMatrix2fvARB");
	loadGlextFunctions(cast(void**)&glUniformMatrix3fvARB, "glUniformMatrix3fvARB");
	loadGlextFunctions(cast(void**)&glUniformMatrix4fvARB, "glUniformMatrix4fvARB");
	loadGlextFunctions(cast(void**)&glUseProgramObjectARB, "glUseProgramObjectARB");
	loadGlextFunctions(cast(void**)&glValidateProgramARB, "glValidateProgramARB");
}

//GL_ARB_vertex_shader
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/vertex_shader.txt
const GLenum GL_VERTEX_SHADER_ARB = 0x8B31;
const GLenum GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = 0x8B4A;
const GLenum GL_MAX_VARYING_FLOATS_ARB = 0x8B4B;
const GLenum GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = 0x8B4C;
const GLenum GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = 0x8B4D;
const GLenum GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = 0x8B89;
const GLenum GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = 0x8B8A;
void function (GLhandleARB programObj, GLuint index,  GLcharARB* name) glBindAttribLocationARB;
void function (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei* length, GLint *size, GLenum *type, GLcharARB *name) glGetActiveAttribARB;
GLint function (GLhandleARB programObj,  GLcharARB* name) glGetAttribLocationARB;

void load_GL_ARB_vertex_shader() /// loader
{
	loadGlextFunctions(cast(void**)&glBindAttribLocationARB, "glBindAttribLocationARB");
	loadGlextFunctions(cast(void**)&glGetActiveAttribARB, "glGetActiveAttribARB");
	loadGlextFunctions(cast(void**)&glGetAttribLocationARB, "glGetAttribLocationARB");
}

//GL_ARB_fragment_shader
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/fragment_shader.txt
const GLenum GL_FRAGMENT_SHADER_ARB = 0x8B30;
const GLenum GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = 0x8B49;
const GLenum GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = 0x8B8B;

void load_GL_ARB_fragment_shader() /// loader
{
}

//GL_ARB_multitexture
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/multitexture.txt
const GLenum GL_TEXTURE0_ARB = 0x84C0;
const GLenum GL_TEXTURE1_ARB = 0x84C1;
const GLenum GL_TEXTURE2_ARB = 0x84C2;
const GLenum GL_TEXTURE3_ARB = 0x84C3;
const GLenum GL_TEXTURE4_ARB = 0x84C4;
const GLenum GL_TEXTURE5_ARB = 0x84C5;
const GLenum GL_TEXTURE6_ARB = 0x84C6;
const GLenum GL_TEXTURE7_ARB = 0x84C7;
const GLenum GL_TEXTURE8_ARB = 0x84C8;
const GLenum GL_TEXTURE9_ARB = 0x84C9;
const GLenum GL_TEXTURE10_ARB = 0x84CA;
const GLenum GL_TEXTURE11_ARB = 0x84CB;
const GLenum GL_TEXTURE12_ARB = 0x84CC;
const GLenum GL_TEXTURE13_ARB = 0x84CD;
const GLenum GL_TEXTURE14_ARB = 0x84CE;
const GLenum GL_TEXTURE15_ARB = 0x84CF;
const GLenum GL_TEXTURE16_ARB = 0x84D0;
const GLenum GL_TEXTURE17_ARB = 0x84D1;
const GLenum GL_TEXTURE18_ARB = 0x84D2;
const GLenum GL_TEXTURE19_ARB = 0x84D3;
const GLenum GL_TEXTURE20_ARB = 0x84D4;
const GLenum GL_TEXTURE21_ARB = 0x84D5;
const GLenum GL_TEXTURE22_ARB = 0x84D6;
const GLenum GL_TEXTURE23_ARB = 0x84D7;
const GLenum GL_TEXTURE24_ARB = 0x84D8;
const GLenum GL_TEXTURE25_ARB = 0x84D9;
const GLenum GL_TEXTURE26_ARB = 0x84DA;
const GLenum GL_TEXTURE27_ARB = 0x84DB;
const GLenum GL_TEXTURE28_ARB = 0x84DC;
const GLenum GL_TEXTURE29_ARB = 0x84DD;
const GLenum GL_TEXTURE30_ARB = 0x84DE;
const GLenum GL_TEXTURE31_ARB = 0x84DF;
const GLenum GL_ACTIVE_TEXTURE_ARB = 0x84E0;
const GLenum GL_CLIENT_ACTIVE_TEXTURE_ARB = 0x84E1;
const GLenum GL_MAX_TEXTURE_UNITS_ARB = 0x84E2;
void function (GLenum texture) glActiveTextureARB;
void function (GLenum texture) glClientActiveTextureARB;
void function (GLenum target, GLdouble s) glMultiTexCoord1dARB;
void function (GLenum target,  GLdouble *v) glMultiTexCoord1dvARB;
void function (GLenum target, GLfloat s) glMultiTexCoord1fARB;
void function (GLenum target,  GLfloat *v) glMultiTexCoord1fvARB;
void function (GLenum target, GLint s) glMultiTexCoord1iARB;
void function (GLenum target,  GLint *v) glMultiTexCoord1ivARB;
void function (GLenum target, GLshort s) glMultiTexCoord1sARB;
void function (GLenum target,  GLshort *v) glMultiTexCoord1svARB;
void function (GLenum target, GLdouble s, GLdouble t) glMultiTexCoord2dARB;
void function (GLenum target,  GLdouble *v) glMultiTexCoord2dvARB;
void function (GLenum target, GLfloat s, GLfloat t) glMultiTexCoord2fARB;
void function (GLenum target,  GLfloat *v) glMultiTexCoord2fvARB;
void function (GLenum target, GLint s, GLint t) glMultiTexCoord2iARB;
void function (GLenum target,  GLint *v) glMultiTexCoord2ivARB;
void function (GLenum target, GLshort s, GLshort t) glMultiTexCoord2sARB;
void function (GLenum target,  GLshort *v) glMultiTexCoord2svARB;
void function (GLenum target, GLdouble s, GLdouble t, GLdouble r) glMultiTexCoord3dARB;
void function (GLenum target,  GLdouble *v) glMultiTexCoord3dvARB;
void function (GLenum target, GLfloat s, GLfloat t, GLfloat r) glMultiTexCoord3fARB;
void function (GLenum target,  GLfloat *v) glMultiTexCoord3fvARB;
void function (GLenum target, GLint s, GLint t, GLint r) glMultiTexCoord3iARB;
void function (GLenum target,  GLint *v) glMultiTexCoord3ivARB;
void function (GLenum target, GLshort s, GLshort t, GLshort r) glMultiTexCoord3sARB;
void function (GLenum target,  GLshort *v) glMultiTexCoord3svARB;
void function (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q) glMultiTexCoord4dARB;
void function (GLenum target,  GLdouble *v) glMultiTexCoord4dvARB;
void function (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q) glMultiTexCoord4fARB;
void function (GLenum target,  GLfloat *v) glMultiTexCoord4fvARB;
void function (GLenum target, GLint s, GLint t, GLint r, GLint q) glMultiTexCoord4iARB;
void function (GLenum target,  GLint *v) glMultiTexCoord4ivARB;
void function (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q) glMultiTexCoord4sARB;
void function (GLenum target,  GLshort *v) glMultiTexCoord4svARB;

void load_GL_ARB_multitexture() /// loader
{
	loadGlextFunctions(cast(void**)&glActiveTextureARB, "glActiveTextureARB");
	loadGlextFunctions(cast(void**)&glClientActiveTextureARB, "glClientActiveTextureARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1dARB, "glMultiTexCoord1dARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1dvARB, "glMultiTexCoord1dvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1fARB, "glMultiTexCoord1fARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1fvARB, "glMultiTexCoord1fvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1iARB, "glMultiTexCoord1iARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1ivARB, "glMultiTexCoord1ivARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1sARB, "glMultiTexCoord1sARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord1svARB, "glMultiTexCoord1svARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2dARB, "glMultiTexCoord2dARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2dvARB, "glMultiTexCoord2dvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2fARB, "glMultiTexCoord2fARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2fvARB, "glMultiTexCoord2fvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2iARB, "glMultiTexCoord2iARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2ivARB, "glMultiTexCoord2ivARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2sARB, "glMultiTexCoord2sARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord2svARB, "glMultiTexCoord2svARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3dARB, "glMultiTexCoord3dARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3dvARB, "glMultiTexCoord3dvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3fARB, "glMultiTexCoord3fARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3fvARB, "glMultiTexCoord3fvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3iARB, "glMultiTexCoord3iARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3ivARB, "glMultiTexCoord3ivARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3sARB, "glMultiTexCoord3sARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord3svARB, "glMultiTexCoord3svARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4dARB, "glMultiTexCoord4dARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4dvARB, "glMultiTexCoord4dvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4fARB, "glMultiTexCoord4fARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4fvARB, "glMultiTexCoord4fvARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4iARB, "glMultiTexCoord4iARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4ivARB, "glMultiTexCoord4ivARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4sARB, "glMultiTexCoord4sARB");
	loadGlextFunctions(cast(void**)&glMultiTexCoord4svARB, "glMultiTexCoord4svARB");
}

//GL_EXT_framebuffer_object
//http://oss.sgi.com/projects/ogl-sample/registry/EXT/framebuffer_object.txt
const GLenum GL_INVALID_FRAMEBUFFER_OPERATION_EXT = 0x0506;
const GLenum GL_MAX_RENDERBUFFER_SIZE_EXT = 0x84E8;
const GLenum GL_FRAMEBUFFER_BINDING_EXT = 0x8CA6;
const GLenum GL_RENDERBUFFER_BINDING_EXT = 0x8CA7;
const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 0x8CD0;
const GLenum GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 0x8CD1;
const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 0x8CD2;
const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 0x8CD3;
const GLenum GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 0x8CD4;
const GLenum GL_FRAMEBUFFER_COMPLETE_EXT = 0x8CD5;
const GLenum GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 0x8CD6;
const GLenum GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 0x8CD7;
const GLenum GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 0x8CD9;
const GLenum GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 0x8CDA;
const GLenum GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 0x8CDB;
const GLenum GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 0x8CDC;
const GLenum GL_FRAMEBUFFER_UNSUPPORTED_EXT = 0x8CDD;
const GLenum GL_MAX_COLOR_ATTACHMENTS_EXT = 0x8CDF;
const GLenum GL_COLOR_ATTACHMENT0_EXT = 0x8CE0;
const GLenum GL_COLOR_ATTACHMENT1_EXT = 0x8CE1;
const GLenum GL_COLOR_ATTACHMENT2_EXT = 0x8CE2;
const GLenum GL_COLOR_ATTACHMENT3_EXT = 0x8CE3;
const GLenum GL_COLOR_ATTACHMENT4_EXT = 0x8CE4;
const GLenum GL_COLOR_ATTACHMENT5_EXT = 0x8CE5;
const GLenum GL_COLOR_ATTACHMENT6_EXT = 0x8CE6;
const GLenum GL_COLOR_ATTACHMENT7_EXT = 0x8CE7;
const GLenum GL_COLOR_ATTACHMENT8_EXT = 0x8CE8;
const GLenum GL_COLOR_ATTACHMENT9_EXT = 0x8CE9;
const GLenum GL_COLOR_ATTACHMENT10_EXT = 0x8CEA;
const GLenum GL_COLOR_ATTACHMENT11_EXT = 0x8CEB;
const GLenum GL_COLOR_ATTACHMENT12_EXT = 0x8CEC;
const GLenum GL_COLOR_ATTACHMENT13_EXT = 0x8CED;
const GLenum GL_COLOR_ATTACHMENT14_EXT = 0x8CEE;
const GLenum GL_COLOR_ATTACHMENT15_EXT = 0x8CEF;
const GLenum GL_DEPTH_ATTACHMENT_EXT = 0x8D00;
const GLenum GL_STENCIL_ATTACHMENT_EXT = 0x8D20;
const GLenum GL_FRAMEBUFFER_EXT = 0x8D40;
const GLenum GL_RENDERBUFFER_EXT = 0x8D41;
const GLenum GL_RENDERBUFFER_WIDTH_EXT = 0x8D42;
const GLenum GL_RENDERBUFFER_HEIGHT_EXT = 0x8D43;
const GLenum GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = 0x8D44;
const GLenum GL_STENCIL_INDEX1_EXT = 0x8D46;
const GLenum GL_STENCIL_INDEX4_EXT = 0x8D47;
const GLenum GL_STENCIL_INDEX8_EXT = 0x8D48;
const GLenum GL_STENCIL_INDEX16_EXT = 0x8D49;
const GLenum GL_RENDERBUFFER_RED_SIZE_EXT = 0x8D50;
const GLenum GL_RENDERBUFFER_GREEN_SIZE_EXT = 0x8D51;
const GLenum GL_RENDERBUFFER_BLUE_SIZE_EXT = 0x8D52;
const GLenum GL_RENDERBUFFER_ALPHA_SIZE_EXT = 0x8D53;
const GLenum GL_RENDERBUFFER_DEPTH_SIZE_EXT = 0x8D54;
const GLenum GL_RENDERBUFFER_STENCIL_SIZE_EXT = 0x8D55;
void function (GLenum target, GLuint framebuffer) glBindFramebufferEXT;
void function (GLenum target, GLuint renderbuffer) glBindRenderbufferEXT;
GLenum function (GLenum target) glCheckFramebufferStatusEXT;
void function (GLsizei n,  GLuint* framebuffers) glDeleteFramebuffersEXT;
void function (GLsizei n,  GLuint* renderbuffers) glDeleteRenderbuffersEXT;
void function (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) glFramebufferRenderbufferEXT;
void function (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) glFramebufferTexture1DEXT;
void function (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) glFramebufferTexture2DEXT;
void function (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) glFramebufferTexture3DEXT;
void function (GLsizei n, GLuint* framebuffers) glGenFramebuffersEXT;
void function (GLsizei n, GLuint* renderbuffers) glGenRenderbuffersEXT;
void function (GLenum target) glGenerateMipmapEXT;
void function (GLenum target, GLenum attachment, GLenum pname, GLint* params) glGetFramebufferAttachmentParameterivEXT;
void function (GLenum target, GLenum pname, GLint* params) glGetRenderbufferParameterivEXT;
GLboolean function (GLuint framebuffer) glIsFramebufferEXT;
GLboolean function (GLuint renderbuffer) glIsRenderbufferEXT;
void function (GLenum target, GLenum internalformat, GLsizei width, GLsizei height) glRenderbufferStorageEXT;

void load_GL_EXT_framebuffer_object() /// loader
{
	loadGlextFunctions(cast(void**)&glBindFramebufferEXT, "glBindFramebufferEXT");
	loadGlextFunctions(cast(void**)&glBindRenderbufferEXT, "glBindRenderbufferEXT");
	loadGlextFunctions(cast(void**)&glCheckFramebufferStatusEXT, "glCheckFramebufferStatusEXT");
	loadGlextFunctions(cast(void**)&glDeleteFramebuffersEXT, "glDeleteFramebuffersEXT");
	loadGlextFunctions(cast(void**)&glDeleteRenderbuffersEXT, "glDeleteRenderbuffersEXT");
	loadGlextFunctions(cast(void**)&glFramebufferRenderbufferEXT, "glFramebufferRenderbufferEXT");
	loadGlextFunctions(cast(void**)&glFramebufferTexture1DEXT, "glFramebufferTexture1DEXT");
	loadGlextFunctions(cast(void**)&glFramebufferTexture2DEXT, "glFramebufferTexture2DEXT");
	loadGlextFunctions(cast(void**)&glFramebufferTexture3DEXT, "glFramebufferTexture3DEXT");
	loadGlextFunctions(cast(void**)&glGenFramebuffersEXT, "glGenFramebuffersEXT");
	loadGlextFunctions(cast(void**)&glGenRenderbuffersEXT, "glGenRenderbuffersEXT");
	loadGlextFunctions(cast(void**)&glGenerateMipmapEXT, "glGenerateMipmapEXT");
	loadGlextFunctions(cast(void**)&glGetFramebufferAttachmentParameterivEXT, "glGetFramebufferAttachmentParameterivEXT");
	loadGlextFunctions(cast(void**)&glGetRenderbufferParameterivEXT, "glGetRenderbufferParameterivEXT");
	loadGlextFunctions(cast(void**)&glIsFramebufferEXT, "glIsFramebufferEXT");
	loadGlextFunctions(cast(void**)&glIsRenderbufferEXT, "glIsRenderbufferEXT");
	loadGlextFunctions(cast(void**)&glRenderbufferStorageEXT, "glRenderbufferStorageEXT");
}

//GL_ARB_texture_float
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/texture_float.txt
const GLenum GL_RGBA32F_ARB = 0x8814;
const GLenum GL_RGB32F_ARB = 0x8815;
const GLenum GL_ALPHA32F_ARB = 0x8816;
const GLenum GL_INTENSITY32F_ARB = 0x8817;
const GLenum GL_LUMINANCE32F_ARB = 0x8818;
const GLenum GL_LUMINANCE_ALPHA32F_ARB = 0x8819;
const GLenum GL_RGBA16F_ARB = 0x881A;
const GLenum GL_RGB16F_ARB = 0x881B;
const GLenum GL_ALPHA16F_ARB = 0x881C;
const GLenum GL_INTENSITY16F_ARB = 0x881D;
const GLenum GL_LUMINANCE16F_ARB = 0x881E;
const GLenum GL_LUMINANCE_ALPHA16F_ARB = 0x881F;
const GLenum GL_TEXTURE_RED_TYPE_ARB = 0x8C10;
const GLenum GL_TEXTURE_GREEN_TYPE_ARB = 0x8C11;
const GLenum GL_TEXTURE_BLUE_TYPE_ARB = 0x8C12;
const GLenum GL_TEXTURE_ALPHA_TYPE_ARB = 0x8C13;
const GLenum GL_TEXTURE_LUMINANCE_TYPE_ARB = 0x8C14;
const GLenum GL_TEXTURE_INTENSITY_TYPE_ARB = 0x8C15;
const GLenum GL_TEXTURE_DEPTH_TYPE_ARB = 0x8C16;
const GLenum GL_UNSIGNED_NORMALIZED_ARB = 0x8C17;

void load_GL_ARB_texture_float() /// loader
{
}

//GL_ARB_depth_texture
//http://oss.sgi.com/projects/ogl-sample/registry/ARB/depth_texture.txt
const GLenum GL_DEPTH_COMPONENT16_ARB = 0x81A5;
const GLenum GL_DEPTH_COMPONENT24_ARB = 0x81A6;
const GLenum GL_DEPTH_COMPONENT32_ARB = 0x81A7;
const GLenum GL_TEXTURE_DEPTH_SIZE_ARB = 0x884A;
const GLenum GL_DEPTH_TEXTURE_MODE_ARB = 0x884B;

void load_GL_ARB_depth_texture() /// loader
{
}

