﻿/**
pngファイル読み書き、r8g8b8a8だけ対応
PNG_COLOR_TYPE_RGB_ALPHAとPNG_COLOR_TYPE_RGBを読める
*/
module coneneko.pngfile;
private import std.string;

extern (C)
{
	void* createAndGetSizePngReader(char* pngFileName, uint* width, uint* height);
	void readAndDeletePngReader(void* handle, void* buffer);
	bool writePngWriter(char* fileName, void* buffer, uint width, uint height);
}

///
uint[] readPng(char[] pngFileName, out uint width, out uint height)
{
	void* handle = createAndGetSizePngReader(toStringz(pngFileName), &width, &height);
	assert(handle);
	uint[] result = new uint[width * height];
	readAndDeletePngReader(handle, result);
	return result;
}

///
void writePng(char[] pngFileName, uint[] buffer, uint width, uint height)
{
	bit b = writePngWriter(toStringz(pngFileName), buffer, width, height);
	assert(b);
}
