﻿module coneneko.sjis2utf8;
private import std.utf;
version (Windows) private import std.c.windows.windows;

unittest
{
	const char[] sjis = [ 0x82, 0xA0, 0x82, 0xA2, 0x82, 0xA4 ]; // あいう
	assert("あいう" == sjisToUtf8(sjis));
}

char[] sjisToUtf8(char[] sjis) ///
{
	version (Windows)
	{
		if (sjis.length == 0) return "";
		wchar[] result;
		result.length = MultiByteToWideChar(0, 0, sjis, sjis.length, null, 0);
		uint resultLength = MultiByteToWideChar(0, 0, &sjis[0], sjis.length, &result[0], result.length);
		assert(resultLength == result.length);
		return toUTF8(result);
	}
	else
	{
		throw new Error("変換できない");
	}
}
