﻿import coneneko.all;
import sdl;
import opengl;
import std.string, std.math, std.cstream, std.path, std.file;

int main(char[][] args)
{
	Window wnd;
	Waiter waiter;
	Nanami nanami;
	Unit shader;
	try
	{
		if (args.length < 2) throw new Error("file name not found");
		foreach (inout char[] a; args) a = sjisToUtf8(a);
		isfile(args[1]);
		chdir(getDirName(args[0]));
		
		wnd = new SdlWindow();
		waiter = new Waiter(wnd);
		nanami = new Nanami(args[1]);
		bool hasMotion = nanami.matrixArray ? true : false;
		
		// "smesh_toon.vert"のmatrixArrayの長さと同じ
		const uint BONE_LENGTH_LIMIT = 34;
		uint boneLength = nanami.matrixArray.length >= 1 ? nanami.matrixArray[0][0].length : 0;
		if (boneLength > BONE_LENGTH_LIMIT)
		{
			dout.writefln("boneLength=%d >= LIMIT", boneLength);
			dout.writeLine("continue?(y/n)");
			if ("y" != din.readLine()) throw new Error("bone length limit over");
		}
		
		CheckButton[][] buttons;
		ButtonEventFactory buttonEventFactory = new SdlButtonEventFactory(cast(SdlWindow)wnd);
		buttons.length = 3;
		buttons[0].length = hasMotion ? 1 + nanami.matrixArray.length : 0;
		buttons[1].length = nanami.subset.length >= 2 ? nanami.subset[1].length : 0;
		buttons[2].length = nanami.subset.length >= 3 ? nanami.subset.length - 2 : 0;
		for (int i = 0; i < buttons[0].length; i++)
		{
			buttons[0][i] = new CheckButton(
				new Text(48 * i, 0, toString(i)), buttonEventFactory, 48, 32
			);
		}
		if (buttons[0].length >= 1) buttons[0][0].value = true;
		uint currentMotion = 0;
		for (int i = 0; i < buttons[1].length; i++)
		{
			buttons[1][i] = new CheckButton(
				new Text(48 * i, 32, toString(i)), buttonEventFactory, 48, 32
			);
		}
		for (int i = 0; i < buttons[2].length; i++)
		{
			buttons[2][i] = new CheckButton(
				new Text(48 * i, 64, toString(i)), buttonEventFactory, 48, 32
			);
		}
		
		SdlCamera camera = new SdlCamera();
		
		Matrix[] identityArray;
		//SkinnedMeshToonShader smesh;
		SkinnedMeshHsvToonShader smesh;
		if (hasMotion)
		{
			//smesh = new SkinnedMeshToonShader();
			smesh = new SkinnedMeshHsvToonShader();
			smesh.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
			shader = smesh;
			
			nanami.matrixIndexLocation = smesh.matrixIndexLocation;
			nanami.weightLocation = smesh.weightLocation;
			identityArray = new Matrix[nanami.matrixArray[0][0].length];
			identityArray[] = Matrix.identity;
			smesh.matrixArray = identityArray;
		}
		else
		{
			//ToonShader toon = new ToonShader();
			HsvToonShader toon = new HsvToonShader();
			toon.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
			shader = toon;
		}
		
		Node rootNode = new Node(new Clear());
		Node nanamiNode = new Node(
			new UnitMerger(
				new Enable(GL_CULL_FACE),
				new CullFace(GL_FRONT),
				new Enable(GL_DEPTH_TEST),
				new MatrixMode(GL_PROJECTION),
				new LoadMatrix(Matrix.perspectiveFov),
				new MatrixMode(GL_MODELVIEW),
				camera,
				shader,
				nanami
			)
		);
		Node buttonsNode = new Node();
		foreach (CheckButton[] a; buttons)
		{
			foreach (CheckButton b; a) buttonsNode ~= new Node(b);
		}
		
		rootNode ~= nanamiNode;
		rootNode ~= buttonsNode;
		
		waiter.addEvent(0, camera);
		foreach (CheckButton a; buttons[0]) waiter.addEvent(1, a.clickEvent);
		foreach (CheckButton a; buttons[1]) waiter.addEvent(2, a.clickEvent);
		foreach (CheckButton a; buttons[2]) waiter.addEvent(3, a.clickEvent);
		waiter.killTime = delegate uint(RenderTarget rt)
		{
			uint[uint] morphIterator;
			for (int i = 0; i < buttons[2].length; i++)
			{
				if (buttons[2][i].value) morphIterator[i] = 0;
			}
			
			uint t = 0;
			
			while (true)
			{
				foreach (uint key; morphIterator.keys)
				{
					nanami.subset[2 + key][morphIterator[key]].visible = false;
					
					morphIterator[key]++;
					if (nanami.subset[2 + key].length <= morphIterator[key])
					{
						morphIterator[key] = 0;
					}
					
					nanami.subset[2 + key][morphIterator[key]].visible = true;
				}
				
				if (hasMotion)
				{
					t++;
					if (currentMotion == 0)
					{
						smesh.matrixArray = identityArray;
					}
					else
					{
						if (t >= nanami.matrixArray[currentMotion - 1].length) t = 0;
						smesh.matrixArray = nanami.matrixArray[currentMotion - 1][t];
					}
				}
				
				rt.draw(rootNode);
				rt.flip();
				SDL_Delay(1000 / 60);
			}
			return 0;
		};
		while (true)
		{
			switch (waiter.wait())
			{
				case 1:
					uint trueCount = 0;
					foreach (CheckButton a; buttons[0]) if (a.value) trueCount++;
					if (trueCount == 0) buttons[0][currentMotion].value = true;
					else if (trueCount == 2)
					{
						buttons[0][currentMotion].value = false;
						for (int i = 0; i < buttons[0].length; i++)
						{
							if (buttons[0][i].value)
							{
								currentMotion = i;
								break;
							}
						}
					}
					else exception(__FILE__, __LINE__);
					break;
					
				case 2:
					for (int i = 0; i < nanami.subset[1].length; i++)
					{
						nanami.subset[1][i].visible = buttons[1][i].value;
					}
					break;
					
				case 3:
					for (int i = 2; i < nanami.subset.length; i++)
					{
						for (int j = 0; j < nanami.subset[i].length; j++)
						{
							nanami.subset[i][j].visible = false;
						}
					}
					break;
			}
		}
	}
	catch (WindowDeadException e)
	{
		e.print();
	}
	catch (Exception e)
	{
		dout.flush();
		derr.writeLine(e.toString());
		dout.writeLine("---- failed ----");
		din.readLine();
		dout.writeLine("end of process");
	}
	finally
	{
		delete shader;
		delete nanami;
		delete wnd;
	}
	return 0;
}
