﻿import coneneko.sceneview;
import std.date;
import std.random;
import std.file;
import std.cstream;
import std.path;
import std.gc;
import coneneko.scenegraph;
import coneneko.math;
import coneneko.sdlwindow;
import opengl;
import coneneko.units;
import coneneko.exunits;
import coneneko.texture;

int main()
{
	try
	{
		SceneView3 view = new SceneView3(new SdlWindow());
		while (true)
		{
			view.initialize();
			try
			{
				main2(view);
				if (view.loadingTarget)
				{
					view.message("load失敗", vector(0, 0, 1, 0.5));
					view.loadingTarget = null;
				}
			}
			catch (LoadEvent e) {}
		}
	}
	catch (Exception e)
	{
		e.print();
	}
	finally
	{
		fullCollect();
	}
	return 0;
}

void main2(SceneView3 view)
{
	view.serif = "start";
	view.waitClick();
	
	view.doLongScene(
		`..\resource\room.773`,
		`..\resource\human.773`, Matrix.translation(0, 100.0, 0),
		`..\resource\human.773`, Matrix.translation(-100, 100.0, -100),
		`..\resource\furimua`, `..\resource\furimub`
	);
	
	view.serif = "end";
	view.waitClick();
}

///
class SceneView3 : SceneView2
{
	this(Window wnd)
	{
		super(wnd);
	}
	
	void doLongScene(char[] background773,
		char[] human1_773, Matrix human1Matrix,
		char[] human2_773, Matrix human2Matrix,
		char[] sePathA, char[] sePathB)
	{
		// 強or弱 -> fin -> rev * 2 + 1
		// 音声ファイル ディレクトリ指定のファイル名で分類 a b -> c d -> e -> f
		
		Node lsrootNode = new Node(new Clear());
		
		CameraNode cameraNode = new CameraNode();
		lsrootNode ~= cameraNode;
		cameraNode ~= new BackgroundNode(background773);
		HumanNode human1 = new HumanNode(human1_773, human1Matrix);
		HumanNode human2 = new HumanNode(human2_773, human2Matrix);
		cameraNode ~= human1;
		cameraNode ~= human2;
		
		SdlCheckButton[] buttons;
		buttons ~= new SdlCheckButton(new DefaultFont(), 700, 0, "0");
		buttons ~= new SdlCheckButton(new DefaultFont(), 750, 0, "1");
		buttons ~= new SdlCheckButton(new DefaultFont(), 700, 50, "弱");
		buttons ~= new SdlCheckButton(new DefaultFont(), 750, 50, "強");
		buttons ~= new SdlCheckButton(new DefaultFont(), 700, 100, "消去");
		buttons[0].value = true;
		buttons[2].value = true;
		
		SdlButton nextButton = new SdlButton(new DefaultFont(), 700, 550, "next");
		
		ProgressBar progressBar = new ProgressBar(
			50, 550, 500, 20, vector(1, 0, 0, 1), vector(1, 1, 1, 1)
		);
		progressBar.value = 0.0;
		
		Node controlsNode = new Node();
		lsrootNode ~= controlsNode;
		foreach (SdlCheckButton a; buttons) controlsNode ~= new Node(a);
		controlsNode ~= new Node(nextButton);
		controlsNode ~= new Node(progressBar);
		
		Morph[] morphs;
		morphs ~= new Morph(human1.nanami.subset[3], 80, 40, 80, 40); // 口
		morphs ~= new Morph(human1.nanami.subset[4], 60, 20, 60, 20); // 目
		morphs ~= new Morph(human1.nanami.subset[5], 50, 70, 20, 50); // まぶた
		morphs ~= new Morph(human1.nanami.subset[6], 50, 50, 50, 50); // まゆげ
		
		bool toRight = true;
		bool secondHalf = false;
		
		SdlSoundEffect se;
		SeFileList seListA = new SeFileList(sePathA);
		SeFileList seListB = new SeFileList(sePathB);
		
		Waiter waiter = new Waiter(this);
		waiter.addEvent(0, cameraNode.event);
		for (int i = 0; i < buttons.length; i++) waiter.addEvent(1 + i, buttons[i]);
		waiter.addEvent(6, nextButton);
		waiter.killTime = delegate uint(RenderTarget rt)
		{
			const float DELTA = 0.0005;
			while (true)
			{
				float pbv = progressBar.value;
				if (toRight && !secondHalf && pbv < 0.5 && 0.5 <= pbv + DELTA) return 7;
				else if (toRight && 1.0 < pbv + DELTA) return 8;
				else if (!toRight && pbv - DELTA < 0.0) return 9;
				
				float delta2 = (toRight ? 1 : -1) * DELTA * (!toRight || buttons[3].value ? 2 : 1);
				progressBar.value = pbv + delta2;
				
				// subset[2]:ほお
				human1.ho = progressBar.value;
				
				foreach (Morph a; morphs) a.tick();
				
				if (!se || se.stopped)
				{
					SeFileList sfl = buttons[0].value ? seListA : seListB;
					char[] fileName;
					if (toRight)
					{
						if (buttons[2].value && !secondHalf) fileName = sfl.a;
						else if (buttons[3].value && !secondHalf) fileName = sfl.b;
						else if (buttons[2].value && secondHalf) fileName = sfl.c;
						else if (buttons[3].value && secondHalf) fileName = sfl.d;
					}
					else
					{
						fileName = sfl.f;
					}
					if (fileName) se = new SdlSoundEffect(fileName);
				}
				
				rt.draw(lsrootNode);
				rt.flip();
			}
			return 0;
		};
		while (true)
		{
			switch (waiter.wait())
			{
				case 1: // "0"
					if (toRight && buttons[1].value) human2.eventMotion = human1.eventMotion = 9;
					buttons[0].value = true;
					buttons[1].value = false;
					break;
					
				case 2: // "1"
					if (toRight && buttons[0].value) human2.eventMotion = human1.eventMotion = 4;
					buttons[0].value = false;
					buttons[1].value = true;
					break;
					
				case 3: // "弱"
					buttons[2].value = true;
					buttons[3].value = false;
					break;
					
				case 4: // "強"
					buttons[2].value = false;
					buttons[3].value = true;
					break;
					
				case 5: // "消去"
					human2.visible = !buttons[4].value;
					break;
					
				case 6: // "next"
					return;
					
				case 7: // 後半
					secondHalf = true;
					human2.highSpeed = human1.highSpeed = true;
					break;
					
				case 8: // end
					toRight = false;
					secondHalf = false;
					human2.highSpeed = human1.highSpeed = false;
					human2.eventMotion = human1.eventMotion = buttons[0].value ? 2 : 7;
					
					delete se;
					char[] fileName = buttons[0].value ? seListA.e : seListB.e;
					if (fileName) se = new SdlSoundEffect(fileName);
					break;
					
				case 9: // begin
					toRight = true;
					break;
			}
			
			uint motionIndex = 0;
			if (buttons[1].value) motionIndex += 5;
			if (toRight && buttons[3].value) motionIndex += 1;
			if (!toRight) motionIndex += 3;
			human1.currentMotion = motionIndex;
			human2.currentMotion = motionIndex;
		}
	}
}

class SeFileList
{
	alias char[] string;
	alias string[] slist;
	private slist[char] list;
	
	this(char[] path)
	{
		list['a'] = null;
		list['b'] = null;
		list['c'] = null;
		list['d'] = null;
		list['e'] = null;
		list['f'] = null;
		try
		{
			isdir(path);
		}
		catch (FileException e)
		{
			e.print();
			return;
		}
		foreach (char[] a; listdir(path, "*.wav"))
		{
			list[a.getBaseName()[0]] ~= a;
		}
	}
	
	private static char[] getRandom(char[][] a)
	{
		if (a.length == 0) return "";
		return a[rand() % a.length];
	}
	
	char[] a()
	{
		return getRandom(list['a']);
	}
	
	char[] b()
	{
		return getRandom(list['b']);
	}
	
	char[] c()
	{
		return getRandom(list['c']);
	}
	
	char[] d()
	{
		return getRandom(list['d']);
	}
	
	char[] e()
	{
		return getRandom(list['e']);
	}
	
	char[] f()
	{
		return getRandom(list['f']);
	}
}

class HumanNode : Node
{
	private Nanami nanami;
	private SkinnedMeshShader shader;
	private long beginTime;
	private uint _currentMotion;
	bool highSpeed = false;
	int eventMotion = -1;
	bool visible = true;
	
	this(char[] nanamiFileName, Matrix matrix)
	{
		nanami = new Nanami(nanamiFileName);
		shader = new SkinnedMeshShader(); //new SkinnedMeshShader2();
		shader.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
		nanami.matrixIndexLocation = shader.matrixIndexLocation;
		nanami.weightLocation = shader.weightLocation;
		super(
			new UnitMerger(
				new MultMatrix(matrix),
				shader,
				nanami
			)
		);
		currentMotion = 0;
	}
	
	void currentMotion(uint a)
	{
		if (nanami.matrixArray.length <= a) throw new Error("Nanami2");
		beginTime = getUTCtime();
		_currentMotion = a;
	}
	
	override void opCall()
	{
		long rangeTime = 1000 / 60;
		if (highSpeed) rangeTime /= 2;
		
		if (eventMotion != -1)
		{
			int frameLength = nanami.matrixArray[eventMotion].length;
			if ((getUTCtime() - beginTime) / rangeTime < frameLength)
			{
				long t = (getUTCtime() - beginTime) / rangeTime % frameLength;
				shader.matrixArray = nanami.matrixArray[eventMotion][t];
			}
			else
			{
				eventMotion = -1;
				beginTime = getUTCtime();
			}
		}
		else
		{
			long t = (getUTCtime() - beginTime)
				/ rangeTime % nanami.matrixArray[_currentMotion].length;
			shader.matrixArray = nanami.matrixArray[_currentMotion][t];
		}
		if (visible) super.opCall();
	}
	
	void ho(float a)
	{
		a = clamp(a, 0.0, 1.0);
		Subset[] hoList = nanami.subset[2];
		int index = cast(int)(a * hoList.length);
		if (index == hoList.length) index--;
		for (int i = 0; i < hoList.length; i++) hoList[i].visible = false;
		hoList[index].visible = true;
	}
}

// A -> AB -> B -> BC -> C
//   <- BA <-   <- CB <-
// A, B, Cから一定確率で遷移する
class Morph
{
	private Subset[] list;
	private ubyte ab, bc, cb, ba; // 確率
	
	enum State
	{
		WAIT, AB, BC, CB, BA
	}
	private State state = State.WAIT;
	
	private uint index;
	private int tickCount = 0;
	
	this(Subset[] list, ubyte ab, ubyte bc, ubyte cb, ubyte ba) // [0, 100] per 60 frame
	{
		this.list = list;
		this.ab = ab;
		this.bc = bc;
		this.cb = cb;
		this.ba = ba;
		index = bIndex;
	}
	
	void tick()
	{
		if (state == State.WAIT)
		{
			if (index == aIndex)
			{
				if (boolRand(ab)) state = State.AB;
			}
			else if (index == bIndex)
			{
				if (tickCount % 2 == 0) // 評価頻度を均等にする
				{
					if (boolRand(bc)) state = State.BC;
					else if (boolRand(ba)) state = State.BA;
				}
				else
				{
					if (boolRand(ba)) state = State.BA;
					else if (boolRand(bc)) state = State.BC;
				}
			}
			else if (index == cIndex)
			{
				if (boolRand(cb)) state = State.CB;
			}
		}
		
		const int F = 10; // 遷移の速さ
		if (state == State.AB || state == State.BC)
		{
			if (tickCount % F == 0)
			{
				index++;
				if (index == bIndex || index == cIndex) state = State.WAIT;
			}
		}
		else if (state == State.CB || state == State.BA)
		{
			if (tickCount % F == 0)
			{
				index--;
				if (index == aIndex || index == bIndex) state = State.WAIT;
			}
		}
		
		foreach (Subset a; list) a.visible = false;
		list[index].visible = true;
		
		tickCount++;
	}
	
	private bool boolRand(ubyte frequency)
	{
		static assert(rand().max == uint.max);
		float r = cast(float)rand() / uint.max; // [0.0, 1.0]
		return r < ab * 0.01 / 60.0;
	}
	
	private uint aIndex()
	{
		return 0;
	}
	
	private uint bIndex()
	{
		return list.length / 2;
	}
	
	private uint cIndex()
	{
		return list.length - 1;
	}
}

class CameraNode : Node
{
	SdlEvent event;
	
	this()
	{
		SdlCamera camera = new SdlCamera();
		event = camera;
		super(
			new UnitMerger(
				new Enable(GL_CULL_FACE),
				new CullFace(GL_FRONT),
				new Enable(GL_DEPTH_TEST),
				new MatrixMode(GL_PROJECTION),
				new LoadMatrix(Matrix.perspectiveFov),
				new MatrixMode(GL_MODELVIEW),
				camera,
				new MultMatrix(Matrix.translation(0, -100, 0))
			)
		);
	}
}

class BackgroundNode : Node
{
	this(char[] background773)
	{
		ToonShader toon = new ToonShader(); // ToonShader2
		toon.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
		super(
			new UnitMerger(
				toon,
				new Nanami(background773)
			)
		);
	}
}
