﻿import coneneko.math, coneneko.sdlwindow;
import std.cstream, std.math;
import opengl;

int main()
{
	//return 0; //
	Window wnd = new SdlWindow(); // openglの初期化が必要
	try
	{
		Matrix m;
		glMatrixMode(GL_MODELVIEW_MATRIX);
		glLoadIdentity();
		glTranslatef(1, 0, 0);
		glRotatef(90, 1, 0, 0);
		glGetFloatv(GL_MODELVIEW_MATRIX, cast(float*)&m);
		//m.print();
		
		Matrix m2 = Matrix.identity;
		m2 *= Matrix.translation(1, 0, 0);
		m2 *= Matrix.rotationX(PI_2);
		//m2.print();
		
		bool eq(Matrix a, Matrix b)
		{
			for (int i = 0; i < 4; i++)
			{
				for (int j = 0; j < 4; j++)
				{
					if (fdim(a.m[i][j], b.m[i][j]) > 0.0001)
					{
						dout.writefln("%f ", fdim(a.m[i][j], b.m[i][j]));
						dout.writefln("%f != %f", a.m[i][j], b.m[i][j]);
						a.print();
						b.print();
						return false;
					}
				}
			}
			return true;
		}
		
		assert(eq(m, m2));
	}
	catch (Exception e)
	{
		e.print();
	}
	finally
	{
		delete wnd;
	}
	return 0;
}

unittest
{
	assert(
		matrix(
			0, 1, 2, 3,
			4, 5, 6, 7,
			8, 9, 10, 11,
			12, 13, 14, 15
		) == matrix(
			0, 1, 2, 3,
			4, 5, 6, 7,
			8, 9, 10, 11,
			12, 13, 14, 15
		)
	);
}
