﻿import coneneko.pngfile;
import std.cstream;

int main()
{
	writePngTest();
	readPngTest();
	return 0;
}

uint toColor(ubyte r, ubyte g, ubyte b, ubyte a)
{
	ubyte[4] result;
	result[0] = r;
	result[1] = g;
	result[2] = b;
	result[3] = a;
	return *(cast(uint*)&result[0]);
}

uint[] testData(out uint width, out uint height)
{
	const uint WIDTH = 256, HEIGHT = 256;
	width = WIDTH;
	height = HEIGHT;
	uint[] result = new uint[WIDTH * HEIGHT];
	for (int y = 0; y < HEIGHT; y++)
	{
		for (int x = 0; x < WIDTH; x++)
		{
			result[y * WIDTH + x] = toColor(cast(ubyte)x, cast(ubyte)y, 255, 255);
		}
	}
	return result;
}

void writePngTest()
{
	uint width, height;
	uint[] data = testData(width, height);
	writePng("pngtest2.png", data, width, height);
	dout.writeLine("writePngTest end");
}

void readPngTest()
{
	uint width, height, width2, height2;
	uint[] buffer = readPng("pngtest2.png", width, height);
	uint[] data = testData(width2, height2);
	assert(width2 == width);
	assert(height2 == height);
	for (int i = 0; i < data.length; i++)
	{
		assert(data[i] == buffer[i]);
	}
	dout.writeLine("readPngTest end");
}
