﻿module test.scene.blendtexture;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawBlendTexture(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

const char[] textureBlend_vert =
"void main()
{
	gl_Position = gl_ModelViewMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;
}
";

const char[] textureBlend_frag =
"uniform sampler2D texture0, texture1;
void main()
{
	gl_FragColor = texture2D(texture0, gl_TexCoord[0].xy) * 0.5
		+ texture2D(texture1, gl_TexCoord[0].xy) * 0.5;
}
";

void drawBlendTexture(Window wnd)
{
	const float[] positions = [ 0, 1, 0,  1, -1, 0,  -1, -1, 0 ];
	auto PositionBuffer pb = new PositionBuffer(positions);
	
	const float[] texCoords = [ 0.5, 0,  1, 1,  0, 1];
	auto TexCoordBuffer tb = new TexCoordBuffer(texCoords);
	
	auto Shader shader = new Shader(textureBlend_vert, textureBlend_frag);
	shader.setInt("texture0", 0);
	shader.setInt("texture1", 1);
	
	auto Texture texture0 = new ImageTexture(`..\resource\test0.png`, 0);
	auto Texture texture1 = new ImageTexture(`..\resource\test1.png`, 1);
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			shader,
			texture0,
			texture1,
			tb,
			pb
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
