﻿module test.scene.blendvertex;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawBlendVertex(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

const char[] vertexBlend_vert =
"uniform mat4 matrixArray[2];
attribute vec2 matrixIndex;
attribute float weight;
void main()
{
	vec4 p0 = matrixArray[int(matrixIndex.x)] * gl_Vertex;
	vec4 p1 = matrixArray[int(matrixIndex.y)] * gl_Vertex;
	gl_Position = p0 * weight + p1 * (1.0 - weight);
	gl_FrontColor = vec4(weight, 1.0, 1.0, 1.0);
}
";

const char[] vertexBlend_frag =
"void main()
{
	gl_FragColor = gl_Color;
}
";

void drawBlendVertex(Window wnd)
{
	float[] floats(float[] a ...) { return a.dup; }
	float[] positions, matrixIndices, weights;
	const float RANGE = 0.1;
	for (float y = 0; y < 1.0; y += RANGE)
	{
		positions ~= floats(0, y, 0,  0, y + RANGE, 0,  0.02, y, 0);
		matrixIndices ~= floats(0, 1,  0, 1,  0, 1);
		weights ~= floats(1 - y,  clamp(1 - y - RANGE, 0, 1),  1 - y);
	}
	
	auto Shader shader = new Shader(vertexBlend_vert, vertexBlend_frag);
	auto PositionBuffer pBuffer = new PositionBuffer(positions);
	
	auto MatrixIndexBuffer miBuffer = new MatrixIndexBuffer(matrixIndices);
	miBuffer.location = shader.getAttributeLocation("matrixIndex");
	
	auto WeightBuffer wBuffer = new WeightBuffer(weights);
	wBuffer.location = shader.getAttributeLocation("weight");
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			shader,
			wBuffer,
			miBuffer,
			pBuffer
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		float f = 0.0;
		Matrix[] matrix = new Matrix[2]; // Matrix[2] matrix;では動かない
		matrix[0] = Matrix.identity;
		while (true)
		{
			f -= 0.01;
			matrix[1] = Matrix.rotationZ(f);
			shader.setMatrixArray("matrixArray", matrix);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
	
	delete wBuffer;
	delete miBuffer;
	delete pBuffer;
	delete shader;
}


const char[] textureBlend_vert =
"void main()
{
	gl_Position = gl_ModelViewMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;
}
";

const char[] textureBlend_frag =
"uniform sampler2D texture0, texture1;
void main()
{
	gl_FragColor = texture2D(texture0, gl_TexCoord[0].xy) * 0.5
		+ texture2D(texture1, gl_TexCoord[0].xy) * 0.5;
}
";

void drawTest0Test1(Window wnd)
{
	const float[] positions = [ 0, 1, 0,  1, -1, 0,  -1, -1, 0 ];
	auto PositionBuffer pb = new PositionBuffer(positions);
	
	const float[] texCoords = [ 0.5, 0,  1, 1,  0, 1];
	auto TexCoordBuffer tb = new TexCoordBuffer(texCoords);
	
	auto Shader shader = new Shader(textureBlend_vert, textureBlend_frag);
	shader.setInt("texture0", 0);
	shader.setInt("texture1", 1);
	
	auto Texture texture0 = new ImageTexture(`..\resource\test0.png`, 0);
	auto Texture texture1 = new ImageTexture(`..\resource\test1.png`, 1);
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			shader,
			texture0,
			texture1,
			tb,
			pb
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
