﻿module test.scene.fbo;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawFbo(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

class Triangle : Unit
{
	void attach()
	{
		glBegin(GL_TRIANGLES);
		glColor3d(1.0, 0.0, 0.0);
		glVertex3f(0.0, 1.0, 0.0);
		glColor3d(0.0, 1.0, 0.0);
		glVertex3f(1.0, -1.0, 0.0);
		glColor3d(0.0, 0.0, 1.0);
		glVertex3f(-1.0, -1.0, 0.0);
		glEnd();
	}
	
	void detach() {}
}

void drawFbo(Window wnd)
{
	Fbo texture = new Fbo(256, 256, 0, false);
	//Fbo texture = new FloatFbo(256, 256, 0, false);
	
	texture.draw(
		new Node(
			new UnitMerger(
				new Viewport(0, 0, 256, 256),
				new ClearColor(1, 1, 1),
				new Clear(),
				new Triangle()
			)
		)
	);
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			texture,
			new Quadrangle800x600(0, 0, 256, 256)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
	
	delete texture;
	
	texture = new Fbo(256, 256, 0, true);
	//texture = new FloatFbo(256, 256, 0, true);
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		float angle = 0.0;
		while (true)
		{
			angle += 0.2;
			texture.draw(
				new Node(
					new UnitMerger(
						new Viewport(0, 0, 256, 256),
						new ClearColor(1, 1, 1),
						new Clear(),
						new Enable(GL_DEPTH_TEST),
						new Rotate(angle, 0.0, 1.0, 0.0),
						new Triangle(),
						new LoadIdentity(),
						new Translate(0.5, 0.0, 0.0),
						new Triangle()
					)
				)
			);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
	
	delete texture;
}
