﻿module test.scene.itexture;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawImageTexture(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

void drawImageTexture(Window wnd)
{
	auto ImageTexture texture = new ImageTexture(`..\resource\castle001.jpg`, 0);
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			texture,
			new Quadrangle800x600(0, 0, texture.imageWidth, texture.imageHeight)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
