﻿module test.scene.quadrangle;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawQuadrangle(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

void drawQuadrangle(Window wnd)
{
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			new Quadrangle800x600(20, 10, 200, 100)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
