﻿module test.scene.rtexture;
import coneneko.sdlwindow;
import std.random;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawRandomTexture(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

class RandomRgba : Rgba
{
	uint width() { return 4; }
	uint height() { return 4; }
	
	uint[] pixels()
	{
		uint[] result = new uint[width * height];
		foreach (inout uint a; result) a = rand();
		return result;
	}
}

void drawRandomTexture(Window wnd)
{
	auto Texture texture = new Texture(new RandomRgba(), 0);
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			texture,
			new Quadrangle800x600(20, 10, 200, 100)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
