﻿module test.scene.smesh;
import coneneko.sdlwindow;
import std.date;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawNanami(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

void drawNanami(Window wnd)
{
	Nanami nanami = new Nanami(`..\resource\test_pcnt.773`);
	nanami.subset[1][0].visible = true;
	ToonShader toon = new ToonShader();
	//ToonShader2 toon = new ToonShader2();
	toon.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			new Enable(GL_DEPTH_TEST),
			new MatrixMode(GL_PROJECTION),
			new LoadMatrix(Matrix.perspectiveFov)
		)
	);
	Node nnode = new Node();
	root ~= nnode;
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			float a = cast(float)(getUTCtime() % 1000000) * 0.001;
			nnode.unit = new UnitMerger(
				new MatrixMode(GL_MODELVIEW),
				new LoadMatrix(
					Matrix.rotationY(a) * Matrix.lookAt(0, 0, 1250,  0, 0, 0)
				),
				toon,
				nanami
			);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
	
	delete toon;
	delete nanami;
	
	SkinnedMeshShader smesh = new SkinnedMeshShader();
	//SkinnedMeshShader2 smesh = new SkinnedMeshShader2();
	smesh.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
	OpenglError.check(__FILE__, __LINE__);
	nanami = new Nanami(`..\resource\test_pcntmw.773`);
	nanami.matrixIndexLocation = smesh.matrixIndexLocation;
	nanami.weightLocation = smesh.weightLocation;
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		const MOTION_INDEX = 4;
		while (true)
		{
			float a = cast(float)(getUTCtime() % 1000000) * 0.001;
			uint t = (getUTCtime() / 10) % nanami.matrixArray[MOTION_INDEX].length;
			assert(t < nanami.matrixArray[MOTION_INDEX].length);
			smesh.matrixArray = nanami.matrixArray[MOTION_INDEX][t];
			nnode.unit = new UnitMerger(
				new MatrixMode(GL_MODELVIEW),
				new LoadMatrix(
					Matrix.rotationY(a) * Matrix.lookAt(0, 0, 1250,  0, 0, 0)
				),
				smesh,
				nanami
			);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
	
	delete nanami;
	delete smesh;
}
