﻿module test.scene.text;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawText(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

void drawText(Window wnd)
{
	auto Unit text = new Text800x600(new DefaultFont(), 20, 10, "Abcあいう");
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			text
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
