﻿module test.scene.triangle;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawTriangle(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

class Triangle : Unit
{
	void attach()
	{
		glBegin(GL_TRIANGLES);
		glColor3d(0.5, 0.5, 1.0);
		glVertex3f(0.0f, 0.5f, -3.0f);
		glColor3d(0.5, 1.0, 0.5);
		glVertex3f(-1.0f, -0.5f, -3.0f);
		glColor3d(1.0, 0.5, 0.5);
		glVertex3f(1.0f, -0.5f, -3.0f);
		glEnd();
	}
	
	void detach() {}
}

void drawTriangle(Window wnd)
{
	Node root = new Node(
		new UnitMerger(
			new Viewport(0, 0, wnd.width, wnd.height),
			new MatrixMode(GL_PROJECTION),
			new LoadIdentity(),
			new Perspective(45.0, cast(double)wnd.width / cast(double)wnd.height, 0.1, 100.0),
			new ClearColor(),
			new Enable(GL_DEPTH_TEST),
			new Enable(GL_CULL_FACE),
			new CullFace(GL_BACK),
			new Clear(),
			new Triangle()
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget a)
	{
		while (true)
		{
			a.draw(root);
			a.flip();
		}
		return 0;
	};
	
	waiter.wait();
}
