﻿module test.scene.vertexbuffer;
import coneneko.sdlwindow;

version (TEST)
{
	int main()
	{
		try
		{
			auto SdlWindow wnd = new SdlWindow();
			drawVertexBuffer(wnd);
		}
		catch (Exception e)
		{
			e.print();
		}
		return 0;
	}
}

void drawVertexBuffer(Window wnd)
{
	// root - texture - texCood - color - position
	Node root = new Node(new Clear());
	Node positionNode = new Node();
	Node colorNode = new Node();
	Node normalNode = new Node();
	Node texCoordNode = new Node();
	Node textureNode = new Node();
	root ~= textureNode;
	textureNode ~= texCoordNode;
	texCoordNode ~= colorNode;
	colorNode ~= positionNode;
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new SdlClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new SdlKeyDownEvent(13)); // ENTER
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	
	const float[] positions = [ 0, 1, 0,  1, -1, 0,  -1, -1, 0 ];
	auto PositionBuffer pb = new PositionBuffer(positions);
	positionNode.unit = pb;
	
	waiter.wait();
	
	const float[] colors = [ 1, 0, 0, 1,  0, 1, 0, 1,  0, 0, 1, 1 ];
	auto ColorBuffer cb = new ColorBuffer(colors);
	colorNode.unit = cb;
	
	waiter.wait();
	
	const float[] texCoords = [ 0.5, 0,  1, 1,  0, 1];
	auto TexCoordBuffer tb = new TexCoordBuffer(texCoords);
	texCoordNode.unit = tb;
	auto Texture texture = new ImageTexture(`..\resource\castle001.jpg`, 0);
	textureNode.unit = texture;
	
	waiter.wait();
}
