﻿import std.cstream;
import std.random;
import std.utf;
import std.string;
import std.date;
import sdl;

version (SDL_WINDOW)
{
	import coneneko.sdlwindow;
	import opengl;
	alias SdlClickEvent ClickEvent;
	alias SdlKeyDownEvent KeyDownEvent;
}
version (DWT_WINDOW)
{
	import coneneko.dwtwindow;
	alias DwtClickEvent ClickEvent;
	alias DwtKeyDownEvent KeyDownEvent;
	private alias coneneko.exunits.Text Text;
	private alias coneneko.exunits.Button Button;
}

int main()
{
	version (SDL_WINDOW)
	{
		SdlWindow wnd = new SdlWindow();
		ButtonEventFactory factory = new SdlButtonEventFactory(wnd);
	}
	version (DWT_WINDOW)
	{
		DwtWindow wnd = new DwtWindow();
		ButtonEventFactory factory = new DwtButtonEventFactory(wnd);
	}
	try
	{
		Node root = new Node(new Clear());
		
		Waiter waiter = new Waiter(wnd);
		Button addButton(uint result, uint x, uint y, char[] text)
		{
			Button button = new Button(new Text(x, y, text), factory);
			root ~= new Node(button);
			waiter.addEvent(result, button.clickEvent);
			return button;
		}
		
		Button[] list;
		list ~= addButton(1, 10, 10, "triangleTest");
		list ~= addButton(2, 10, 50, "pixelRectangleTest");
		list ~= addButton(3, 10, 90, "randomTextureTest");
		list ~= addButton(4, 10, 130, "textTest");
		list ~= addButton(5, 10, 170, "imageTextureTest");
		list ~= addButton(6, 10, 210, "vertexBufferTest");
		list ~= addButton(7, 10, 250, "shaderTest");
		list ~= addButton(8, 10, 290, "vertexBlendTest");
		list ~= addButton(9, 10, 330, "fboTest");
		list ~= addButton(10, 10, 370, "nanamiTest");
		
		VirtualMousePoint mp = new VirtualMousePoint(wnd);
		
		root ~= new Node(new ButtonFocus(list, mp, vector(1, 0, 0, 1)));
		
		waiter.killTime = delegate uint(RenderTarget rt)
		{
			while (true)
			{
				SDL_Delay(1000 / 60);
				rt.draw(root);
				rt.flip();
			}
			return 0;
		};
		
		uint wr = waiter.wait();
		if (wr == 1) triangleTest(wnd);
		else if (wr == 2) pixelRectangleTest(wnd);
		else if (wr == 3) randomTextureTest(wnd);
		else if (wr == 4) textTest(wnd);
		else if (wr == 5) imageTextureTest(wnd);
		else if (wr == 6) vertexBufferTest(wnd);
		else if (wr == 7) shaderTest(wnd);
		else if (wr == 8) vertexBlendTest(wnd);
		else if (wr == 9) fboTest(wnd);
		else if (wr == 10) nanamiTest(wnd);
	}
	catch (Exception e)
	{
		e.print();
	}
	finally
	{
		delete wnd;
	}
	return 0;
}

class TestTriangle : Unit
{
	void attach()
	{
		glBegin(GL_TRIANGLES);
		glColor3d(0.5, 0.5, 1.0);
		glVertex3f(0.0f, 0.5f, -3.0f);
		glColor3d(0.5, 1.0, 0.5);
		glVertex3f(-1.0f, -0.5f, -3.0f);
		glColor3d(1.0, 0.5, 0.5);
		glVertex3f(1.0f, -0.5f, -3.0f);
		glEnd();
	}
	
	void detach() {}
}

void triangleTest(Window wnd)
{
	class DefaultPerspective : UnitMerger
	{
		this(int width, int height)
		{
			super(
				new Viewport(0, 0, width, height),
				new MatrixMode(GL_PROJECTION),
				new LoadIdentity(),
				new Perspective(45.0, cast(double)width / cast(double)height, 0.1, 100.0),
				new MatrixMode(GL_MODELVIEW),
				new LoadMatrix(Matrix.translation(1, 0, 0)),
				new MultMatrix(Matrix.translation(0, 1, 0))
			);
		}
	}
	
	Node root = new DotNode("root");
	root ~= new DotNode(
		"triangle",
		new UnitMerger(
			new ClearColor(),
			new Enable(GL_DEPTH_TEST),
			new Enable(GL_CULL_FACE),
			new CullFace(GL_BACK),
			new Clear(),
			new TestTriangle()
		)
	);
	root.print();
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.killTime = delegate uint(RenderTarget a)
	{
		for (int i = 0; i < 1000; i++)
		{
			root.unit = new DefaultPerspective(wnd.width, wnd.height);
			a.draw(root);
			a.flip();
		}
		return 0;
	};
	switch (waiter.wait())
	{
		case 0:
			dout.writeLine("end");
			break;
			
		case 1:
			dout.writeLine("event closed");
			break;
			
		default:
			break;
	}
}

void pixelRectangleTest(Window wnd)
{
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			new Quadrangle(20, 10, 200, 100)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
}

void randomTextureTest(Window wnd)
{
	class RandomRgba : Rgba
	{
		uint width() { return 4; }
		uint height() { return 4; }
		uint[] pixels()
		{
			uint[] result = new uint[width * height];
			foreach (inout uint a; result) a = rand();
			return result;
		}
	}
	
	Texture texture = new Texture(new RandomRgba(), 0);
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			texture,
			new Quadrangle(20, 10, 200, 100)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete texture;
}

void textTest(Window wnd)
{
	Unit text = new Text(20, 10, "Abcあいう");
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			text
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete text;
}

void imageTextureTest(Window wnd)
{
	//ImageTexture texture = new ImageTexture(`..\resource\test0.png`, 0);
	ImageTexture texture = new ImageTexture(`..\resource\castle001.jpg`, 0);
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			texture,
			new Quadrangle(0, 0, texture.imageWidth, texture.imageHeight)
			//new Quadrangle(0, 0, texture.imageWidth / 2, texture.imageHeight / 2)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete texture;
}

void vertexBufferTest(Window wnd)
{
	const float[] positions = [ 0, 1, 0,  1, -1, 0,  -1, -1, 0 ];
	PositionBuffer pb = new PositionBuffer(positions);
	Node root = new Node(new Clear());
	Node colorNode = new Node();
	Node normalNode = new Node();
	Node texCoordNode = new Node();
	Node textureNode = new Node();
	root ~= textureNode;
	textureNode ~= texCoordNode;
	texCoordNode ~= colorNode;
	colorNode ~= new Node(pb);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	
	const float[] colors = [ 1, 0, 0, 1,  0, 1, 0, 1,  0, 0, 1, 1 ];
	ColorBuffer cb = new ColorBuffer(colors);
	colorNode.unit = cb;
	waiter.wait();
	
	const float[] texCoords = [ 0.5, 0,  1, 1,  0, 1];
	TexCoordBuffer tb = new TexCoordBuffer(texCoords);
	texCoordNode.unit = tb;
	Texture texture = new ImageTexture(`..\resource\castle001.jpg`, 0);
	textureNode.unit = texture;
	waiter.wait();
	
	delete texture;
	delete tb;
	delete cb;
	delete pb;
}

const char[] textureBlend_vert =
"void main()
{
	gl_Position = gl_ModelViewMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;
}
";

const char[] textureBlend_frag =
"uniform sampler2D texture0, texture1;
void main()
{
	gl_FragColor = texture2D(texture0, gl_TexCoord[0].xy) * 0.5
		+ texture2D(texture1, gl_TexCoord[0].xy) * 0.5;
}
";

void shaderTest(Window wnd)
{
	const float[] positions = [ 0, 1, 0,  1, -1, 0,  -1, -1, 0 ];
	PositionBuffer pb = new PositionBuffer(positions);
	
	const float[] texCoords = [ 0.5, 0,  1, 1,  0, 1];
	TexCoordBuffer tb = new TexCoordBuffer(texCoords);
	
	Shader shader = new Shader(textureBlend_vert, textureBlend_frag);
	shader.setInt("texture0", 0);
	shader.setInt("texture1", 1);
	
	Texture texture0 = new ImageTexture(`..\resource\test0.png`, 0);
	Texture texture1 = new ImageTexture(`..\resource\test1.png`, 1);
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			shader,
			texture0,
			texture1,
			tb,
			pb
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	
	delete texture1;
	delete texture0;
	delete shader;
	delete tb;
	delete pb;
}

const char[] vertexBlend_vert =
"uniform mat4 matrixArray[2];
attribute vec2 matrixIndex;
attribute float weight;
void main()
{
	vec4 p0 = matrixArray[int(matrixIndex.x)] * gl_Vertex;
	vec4 p1 = matrixArray[int(matrixIndex.y)] * gl_Vertex;
	gl_Position = p0 * weight + p1 * (1.0 - weight);
	gl_FrontColor = vec4(weight, 1.0, 1.0, 1.0);
}
";

const char[] vertexBlend_frag =
"void main()
{
	gl_FragColor = gl_Color;
}
";

void vertexBlendTest(Window wnd)
{
	float[] floats(float[] a ...) { return a.dup; }
	float[] positions, matrixIndices, weights;
	const float RANGE = 0.1;
	for (float y = 0; y < 1.0; y += RANGE)
	{
		positions ~= floats(0, y, 0,  0, y + RANGE, 0,  0.02, y, 0);
		matrixIndices ~= floats(0, 1,  0, 1,  0, 1);
		weights ~= floats(1 - y,  clamp(1 - y - RANGE, 0, 1),  1 - y);
	}
	
	Shader shader = new Shader(vertexBlend_vert, vertexBlend_frag);
	PositionBuffer pBuffer = new PositionBuffer(positions);
	
	MatrixIndexBuffer miBuffer = new MatrixIndexBuffer(matrixIndices);
	miBuffer.location = shader.getAttributeLocation("matrixIndex");
	
	WeightBuffer wBuffer = new WeightBuffer(weights);
	wBuffer.location = shader.getAttributeLocation("weight");
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			shader,
			wBuffer,
			miBuffer,
			pBuffer
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		float f = 0.0;
		Matrix[] matrix = new Matrix[2]; // Matrix[2] matrix;では動かない
		matrix[0] = Matrix.identity;
		while (true)
		{
			f -= 0.01;
			matrix[1] = Matrix.rotationZ(f);
			shader.setMatrixArray("matrixArray", matrix);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	
	delete wBuffer;
	delete miBuffer;
	delete pBuffer;
	delete shader;
}

class TestTriangle2 : Unit
{
	void attach()
	{
		glBegin(GL_TRIANGLES);
		glColor3d(1.0, 0.0, 0.0);
		glVertex3f(0.0, 1.0, 0.0);
		glColor3d(0.0, 1.0, 0.0);
		glVertex3f(1.0, -1.0, 0.0);
		glColor3d(0.0, 0.0, 1.0);
		glVertex3f(-1.0, -1.0, 0.0);
		glEnd();
	}
	
	void detach() {}
}

void fboTest(Window wnd)
{
	Fbo texture = new Fbo(256, 256, 0, false);
	//Fbo texture = new FloatFbo(256, 256, 0, false);
	
	texture.draw(
		new Node(
			new UnitMerger(
				new Viewport(0, 0, 256, 256),
				new ClearColor(1, 1, 1),
				new Clear(),
				new TestTriangle2()
			)
		)
	);
	
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			texture,
			new Quadrangle(0, 0, 256, 256)
		)
	);
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete texture;
	
	
	texture = new Fbo(256, 256, 0, true);
	//texture = new FloatFbo(256, 256, 0, true);
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		float angle = 0.0;
		while (true)
		{
			angle += 0.2;
			texture.draw(
				new Node(
					new UnitMerger(
						new Viewport(0, 0, 256, 256),
						new ClearColor(1, 1, 1),
						new Clear(),
						new Enable(GL_DEPTH_TEST),
						new Rotate(angle, 0.0, 1.0, 0.0),
						new TestTriangle2(),
						new LoadIdentity(),
						new Translate(0.5, 0.0, 0.0),
						new TestTriangle2()
					)
				)
			);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete texture;
}

void nanamiTest(Window wnd)
{
	Nanami nanami = new Nanami(`..\resource\test_pcnt.773`);
	nanami.subset[1][0].visible = true;
	ToonShader toon = new ToonShader();
	//HsvToonShader toon = new HsvToonShader();
	toon.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
	Node root = new Node(
		new UnitMerger(
			new Clear(),
			new Enable(GL_DEPTH_TEST),
			new MatrixMode(GL_PROJECTION),
			new LoadMatrix(Matrix.perspectiveFov)
		)
	);
	Node nnode = new Node();
	root ~= nnode;
	
	Waiter waiter = new Waiter(wnd);
	waiter.addEvent(1, new ClickEvent(0, 0, wnd.width, wnd.height));
	waiter.addEvent(1, new KeyDownEvent(13)); // ENTER
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			float a = cast(float)(getUTCtime() % 1000000) * 0.001;
			nnode.unit = new UnitMerger(
				new MatrixMode(GL_MODELVIEW),
				new LoadMatrix(
					Matrix.rotationY(a) * Matrix.lookAt(0, 0, 1250,  0, 0, 0)
				),
				toon,
				nanami
			);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete toon;
	delete nanami;
	
	SkinnedMeshToonShader smesh = new SkinnedMeshToonShader();
	//SkinnedMeshHsvToonShader smesh = new SkinnedMeshHsvToonShader();
	smesh.lightDirection = normalize(vector(-1.0, -1.0, 0.0));
	glErrorCheck(__FILE__, __LINE__);
	nanami = new Nanami(`..\resource\test_pcntmw.773`);
	nanami.matrixIndexLocation = smesh.matrixIndexLocation;
	nanami.weightLocation = smesh.weightLocation;
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		const MOTION_INDEX = 4;
		while (true)
		{
			float a = cast(float)(getUTCtime() % 1000000) * 0.001;
			uint t = (getUTCtime() / 10) % nanami.matrixArray[MOTION_INDEX].length;
			assert(t < nanami.matrixArray[MOTION_INDEX].length);
			smesh.matrixArray = nanami.matrixArray[MOTION_INDEX][t];
			nnode.unit = new UnitMerger(
				new MatrixMode(GL_MODELVIEW),
				new LoadMatrix(
					Matrix.rotationY(a) * Matrix.lookAt(0, 0, 1250,  0, 0, 0)
				),
				smesh,
				nanami
			);
			rt.draw(root);
			rt.flip();
		}
		return 0;
	};
	waiter.wait();
	delete nanami;
	delete smesh;
}
