﻿// TODO 能動的Objectのまとめ
// それぞれのシーンはNodeから派生した能動的Objectで構成されるべきか?
// シーンの遷移はトップメソッドで行い、
// 各シーンは混沌としたコードから能動的Objectへと収束していく。
import coneneko.sdlwindow, std.random, std.math;
import sdl;
import opengl;

int main()
{
	try
	{
		SdlWindow wnd = new SdlWindow();
		Node background = new Node(
			new UnitMerger(
				new ImageTexture(`..\resource\castle001.jpg`, 0),
				new Quadrangle800x600(0, 0, 640, 480)
			)
		);
		
		while (true)
		{
			title(new Waiter(wnd), background);
			game(new Waiter(wnd), background);
		}
	}
	catch (Exception e)
	{
		e.print();
	}
	return 0;
}

void title(Waiter waiter, Node background)
{
	Node root = new Node(new Clear());
	root ~= background;
	root ~= new Node(new MovableText());
	
	waiter.addEvent(1, new SdlKeyDownEvent('z'));
	waiter.addEvent(1, new SdlJoystickButtonEvent(3));
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		while (true)
		{
			rt.draw(root);
			rt.flip();
			SdlWindow.sleep(1000 / 60);
		}
		return 0;
	};
	
	waiter.wait();
}

class MovableText : Text800x600
{
	this()
	{
		super(new DefaultFont(), 280, 220, `push "z"`);
	}
	
	override void attach()
	{
		Translate t = new Translate(0, SDL_GetTicks() % 1000 * -0.0001, 0);
		t.attach();
		super.attach();
		t.detach();
	}
}

void game(Waiter waiter, Node background)
{
	MainArea mainArea = new MainArea();
	Score score = new Score();
	Blocks blocks = new Blocks();
	Quartet nextQuartet = new Quartet();
	Quartet currentQuartet = new Quartet();
	currentQuartet.moveCenterPosition();
	Effect effect = new Effect(10, 10, 90, 90, `..\resource\effect2.png`, 120);
	effect.disable();
	Effect effect2 = new Effect(200, 10, 240, 60, `..\resource\effect2.png`, 120);
	effect2.disable();
	
	Node nextQuartetNode = new Node(nextQuartet);
	Node currentQuartetNode = new Node(currentQuartet);
	
	Node root = new Node(new Clear());
	root ~= background;
	root ~= new Node(mainArea);
	root ~= new Node(score);
	root ~= new Node(blocks);
	root ~= new Node(new NextArea());
	root ~= nextQuartetNode;
	root ~= currentQuartetNode;
	root ~= new Node(effect);
	root ~= new Node(effect2);
	
	waiter.addEvent(1, new SdlKeyDownEvent(SDLK_LEFT));
	waiter.addEvent(2, new SdlKeyDownEvent(SDLK_RIGHT));
	waiter.addEvent(3, new SdlKeyDownEvent(SDLK_DOWN));
	waiter.addEvent(4, new SdlKeyDownEvent('z'));
	waiter.addEvent(5, new SdlKeyDownEvent('x'));
	waiter.addEvent(1, new SdlJoystickLeftEvent());
	waiter.addEvent(2, new SdlJoystickRightEvent());
	//waiter.addEvent(3, new SdlJoystickDownEvent());
	waiter.addEvent(3, new SdlJoystickButtonEvent(2));
	waiter.addEvent(4, new SdlJoystickButtonEvent(1));
	waiter.addEvent(5, new SdlJoystickButtonEvent(3));
	
	waiter.killTime = delegate uint(RenderTarget rt)
	{
		int s = 0;
		while (true)
		{
			s++;
			if (s > 24) return 0;
			
			rt.draw(root);
			rt.flip();
			SDL_Delay(1000 / 60);
		}
		return 0;
	};
	
	while (true)
	{
		uint id = waiter.wait();
		bool lrMoveOrRotate = id == 1 || id == 2 || id == 4 || id == 5;
		if (lrMoveOrRotate)
		{
			alias currentQuartet cq;
			cq.save();
			switch (id)
			{
				case 1: cq.moveLeft(); break;
				case 2: cq.moveRight(); break;
				case 4: cq.rotateLeft(); break;
				case 5: cq.rotateRight(); break;
			}
			if (cq.isOutside || blocks.isIntersect(cq)) cq.load();
			continue;
		}
		
		bool landing;
		switch (id)
		{
			case 0:
				currentQuartet.save();
				currentQuartet.moveDown();
				if (currentQuartet.isOutside || blocks.isIntersect(currentQuartet))
				{
					currentQuartet.load();
					landing = true;
				}
				break;
				
			case 3:
				while (true)
				{
					currentQuartet.save();
					currentQuartet.moveDown();
					if (currentQuartet.isOutside || blocks.isIntersect(currentQuartet))
					{
						currentQuartet.load();
						break;
					}
				}
				landing = true;
				break;
		}
		if (!landing) continue;
		
		effect.x = 200 + 30 * currentQuartet.x - 30;
		effect.y = 30 + 30 * currentQuartet.y - 30;
		effect.reset();
		new SdlSoundEffect(`..\resource\hit_p03_c.wav`);
		
		for (int i = 0; i < 4; i++) blocks.add(currentQuartet[i]);
		uint n = blocks.eraseScan();
		if (n != 0)
		{
			score += n;
			
			mainArea.shake();
			
			effect2.y = 30 + 30 * currentQuartet.y + 30;
			effect2.reset();
			new SdlSoundEffect(`..\resource\bosu35.wav`);
		}
		
		currentQuartet = nextQuartet;
		currentQuartet.moveCenterPosition();
		nextQuartet = new Quartet();
		currentQuartetNode.unit = currentQuartet;
		nextQuartetNode.unit = nextQuartet;
		
		if (blocks.isGameOver)
		{
			new SdlSoundEffect(`..\resource\bom35.wav`);
			break;
		}
	}
}

class NextArea : Quadrangle800x600
{
	this()
	{
		super(470, 30, 120, 60, vector(0, 0, 0, 1));
	}
}

enum
{
	WIDTH_OF_DRAW_BLOCK = 8,
	HEIGHT_OF_DRAW_BLOCK = 14,
}

class Block : Unit
{
	int x, y;
	private int stockX, stockY;
	private final Quadrangle800x600 pr;
	
	this(int x, int y)
	in
	{
		assert(0 <= x && x < WIDTH_OF_DRAW_BLOCK);
		assert(0 <= y && y < HEIGHT_OF_DRAW_BLOCK);
	}
	body
	{
		this.x = x;
		this.y = y;
		pr = new Quadrangle800x600(0, 0, 30, 30);
	}
	
	bool isOutside()
	{
		return x < 0 || WIDTH_OF_DRAW_BLOCK <= x
			|| y < 0 || HEIGHT_OF_DRAW_BLOCK <= y;
	}
	
	void save()
	{
		stockX = x;
		stockY = y;
	}
	
	void load()
	{
		x = stockX;
		y = stockY;
	}
	
	void attach()
	{
		pr.x = 200 + 30 * x;
		pr.y = 30 + 30 * y;
		pr.attach();
	}
	
	void detach()
	{
		pr.detach();
	}
}

class Blocks : Unit
{
	private bool[Block] blocks;
	
	bool isGameOver()
	{
		foreach (Block a; blocks.keys) if (a.y == 0) return true;
		return false;
	}
	
	private bool lineIsComplete(int y)
	{
		int counter = 0;
		foreach (Block a; blocks.keys) if (a.y == y) counter++;
		return counter == WIDTH_OF_DRAW_BLOCK;
	}

	private void eraseLine(int y)
	{
		bool[Block] removeSet;
		foreach (Block a; blocks.keys) if (a.y == y) removeSet[a] = true;
		foreach (Block a; removeSet.keys) blocks.remove(a);
	}
	
	private void moveDown(int to)
	{
		foreach (Block a; blocks.keys) if (a.y <= to) a.y++;
	}
	
	uint eraseScan()
	{
		uint result = 0;
		for (int y = 0; y < HEIGHT_OF_DRAW_BLOCK; y++)
		{
			if (lineIsComplete(y))
			{
				result++;
				eraseLine(y);
				moveDown(y);
			}
		}
		return result;
	}
	
	void add(Block a)
	{
		blocks[a] = true;
	}
	
	void attach()
	{
		foreach (Block a; blocks.keys) a.attach();
	}
	
	void detach()
	{
		foreach (Block a; blocks.keys) a.detach();
	}
	
	bool isIntersect(Quartet quartet)
	{
		foreach (Block a; blocks.keys)
		{
			for (int i = 0; i < 4; i++)
			{
				if (a.x == quartet[i].x && a.y == quartet[i].y) return true;
			}
		}
		return false;
	}
}

class Quartet : UnitMerger
{
	private Block[4] blocks;
	private int x = 1, y = 1;
	private int stockX, stockY;
	
	this()
	{
		real r = rand() % 8;
		if (r < 1)
		{
			// **
			// **
			initialize(0, 0,  1, 0,  0, 1,  1, 1);
		}
		else if (r < 2)
		{
			// ****
			initialize(0, 0,  1, 0,  2, 0,  3, 0);
		}
		else if (r < 3)
		{
			// ***
			//   *
			initialize(0, 0,  1, 0,  2, 0,  2, 1);
		}
		else if (r < 4)
		{
			// ***
			// *
			initialize(0, 0,  1, 0,  2, 0,  0, 1);
		}
		else if (r < 5)
		{
			// **
			//  **
			initialize(0, 0,  1, 0,  1, 1,  2, 1);
		}
		else if (r < 6)
		{
			//  **
			// **
			initialize(1, 0,  2, 0,  0, 1,  1, 1);
		}
		else // (r < 7)
		{
			//  *
			// ***
			initialize(1, 0,  0, 1,  1, 1,  2, 1);
		}
		
		for (int i = 0; i < 9; i++) moveRight();
		super(blocks[0], blocks[1], blocks[2], blocks[3]);
	}
	
	private void initialize(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3)
	{
		blocks[0] = new Block(x0, y0);
		blocks[1] = new Block(x1, y1);
		blocks[2] = new Block(x2, y2);
		blocks[3] = new Block(x3, y3);
	}
	
	void save()
	{
		foreach (Block a; blocks) a.save();
		stockX = x;
		stockY = y;
	}
	
	void load()
	{
		foreach (Block a; blocks) a.load();
		x = stockX;
		y = stockY;
	}
	
	void moveRight()
	{
		foreach (Block a; blocks) a.x++;
		x++;
	}
	
	void moveLeft()
	{
		foreach (Block a; blocks) a.x--;
		x--;
	}
	
	void moveDown()
	{
		foreach (Block a; blocks) a.y++;
		y++;
	}
	
	Block opIndex(int i)
	{
		return blocks[i];
	}
	
	bool isOutside()
	{
		foreach (Block a; blocks) if (a.isOutside()) return true;
		return false;
	}
	
	void rotateRight()
	{
		Matrix rz = Matrix.rotationZ(PI_2);
		foreach (Block a; blocks)
		{
			Vector v = vector(a.x - x, a.y - y);
			v = mul(v, rz, true);
			a.x = iround(v.x) + x;
			a.y = iround(v.y) + y;
		}
	}
	
	void rotateLeft()
	{
		Matrix rz = Matrix.rotationZ(-PI_2);
		foreach (Block a; blocks)
		{
			Vector v = vector(a.x - x, a.y - y);
			v = mul(v, rz, true);
			a.x = iround(v.x) + x;
			a.y = iround(v.y) + y;
		}
	}
	
	private int iround(float a)
	{
		return cast(int)round(a);
	}
	
	void moveCenterPosition()
	{
		for (int i = 0; i < 7; i++) moveLeft();
	}
}

class Effect : Unit
{
	uint x, y, width, height;
	private final Texture texture;
	private final uint frameLength;
	private final float tcwidth;
	
	private float tcx = 0.0;
	private long preTime;
	private final uint timeRange;
	
	private final Enable alphaEnable;
	private final BlendFunc blendFunc;
	
	this(uint x, uint y, uint width, uint height, char[] textureFileName, uint framePerSecond)
	{
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		texture = new ImageTexture(textureFileName, 0);
		frameLength = texture.width / texture.height;
		tcwidth = 1.0 / cast(float)frameLength;
		timeRange = 1000 / framePerSecond;
		preTime = SDL_GetTicks();
		alphaEnable = new Enable(GL_BLEND);
		blendFunc = new BlendFunc();
	}
	
	void attach()
	{
		if (tcx >= 1.0) return;
		
		alphaEnable.attach();
		blendFunc.attach();
		texture.attach();
		
		int[4] viewport;
		glGetIntegerv(GL_VIEWPORT, viewport.ptr);
		
		glPushMatrix();
		glTranslatef(-1.0, 1.0, 0.0);
		glScalef(2.0 / viewport[2], -2.0 / viewport[3], 1.0);
		glBegin(GL_QUADS);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		glNormal3f(0.0, 0.0, 0.0);
		
		glTexCoord2f(tcx, 0.0);
		glVertex2f(x, y);
		
		glTexCoord2f(tcx + tcwidth, 0.0);
		glVertex2f(x + width, y);
		
		glTexCoord2f(tcx + tcwidth, 1.0);
		glVertex2f(x + width, y + height);
		
		glTexCoord2f(tcx, 1.0);
		glVertex2f(x, y + height);
		
		glEnd();
		glPopMatrix();
	}
	
	void detach()
	{
		if (tcx >= 1.0) return;
		texture.detach();
		blendFunc.detach();
		alphaEnable.detach();
		
		if (preTime + timeRange < SDL_GetTicks())
		{
			tcx += tcwidth;
			preTime = SDL_GetTicks();
		}
	}
	
	void reset()
	{
		tcx = 0.0;
	}
	
	void disable()
	{
		tcx = 1.0;
	}
}

class Score : Unit
{
	private uint value;
	private Text800x600 text;
	
	this()
	{
		update();
	}
	
	~this()
	{
		delete text;
	}
	
	void opAddAssign(uint a)
	{
		value += a;
		update();
	}
	
	private void update()
	{
		delete text;
		text = new Text800x600(new DefaultFont(), 0, 0, std.string.toString(value));
	}
	
	void attach()
	{
		if (text) text.attach();
	}
	
	void detach()
	{
		if (text) text.detach();
	}
}

class MainArea : Quadrangle800x600
{
	private int shakingValue = 0;
	
	this()
	{
		super(200, 30, 240, 420, vector(0, 0, 0, 1));
	}
	
	void shake()
	{
		shakingValue = 20;
	}
	
	void attach()
	{
		uint stockY = y;
		if (shakingValue != 0)
		{
			y += shakingValue;
			shakingValue--;
		}
		super.attach();
		y = stockY;
	}
}
