/*
 * Decompiled with CFR 0.152.
 */
package nga.model;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import nga.model.TreeNode;
import nga.model.UpdatableByText;
import nga.servlet.NameUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<T>
implements UpdatableByText {
    private TreeNode<T> rootNode;
    private TreeNode<T> selectedNode;
    private Map<String, TreeNode<T>> nodeMap = new HashMap<String, TreeNode<T>>();

    public TreeNode<T> createNode(T nodeValue, boolean leaf) {
        String id = NameUtil.getId();
        TreeNode<T> node = new TreeNode<T>(this, id, nodeValue, leaf);
        this.nodeMap.put(id, node);
        return node;
    }

    public TreeNode<T> getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(TreeNode<T> rootNode) {
        this.rootNode = rootNode;
    }

    public TreeNode<T> createRootNode(T nodeValue) {
        TreeNode<T> node = this.createNode(nodeValue, false);
        this.setRootNode(node);
        return node;
    }

    public void setSelectedNode(TreeNode<T> node) {
        node.select();
        this.selectedNode = node;
    }

    public TreeNode<T> getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNodeById(String id) {
        this.setSelectedNode(this.getNodeById(id));
    }

    public TreeNode<T> getNodeById(String id) {
        return this.nodeMap.get(id);
    }

    @Override
    public void update(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            this.setSelectedNodeById(st.nextToken());
        }
    }
}

