/*
 * Decompiled with CFR 0.152.
 */
package nga.model;

import java.util.ArrayList;
import java.util.List;
import nga.model.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode<T> {
    private final Tree<T> tree;
    private String id;
    private T nodeValue;
    private TreeNode<T> parent;
    private List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
    private boolean leaf;
    private boolean opened;
    private boolean loaded;
    private String nodeType;

    TreeNode(Tree<T> tree, String id, T nodeValue, boolean leaf) {
        this.tree = tree;
        this.id = id;
        this.nodeValue = nodeValue;
        this.leaf = leaf;
    }

    public T getNodeValue() {
        return this.nodeValue;
    }

    public String getId() {
        return this.id;
    }

    public void add(TreeNode<T> node) {
        node.parent = this;
        this.children.add(node);
    }

    public TreeNode<T> add(T nodeValue) {
        return this.add(nodeValue, false);
    }

    public TreeNode<T> add(T nodeValue, boolean leaf) {
        TreeNode<T> node = this.tree.createNode(nodeValue, leaf);
        this.add(node);
        return node;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.isLeaf() || this.hasChildren() || this.loaded;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        if (!this.isLeaf()) {
            this.opened = opened;
        }
    }

    public void select() {
        this.setOpened(!this.isOpened());
    }

    public boolean isRootNode() {
        return this.tree.getRootNode() == this;
    }
}

