/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.ServletException;
import nga.model.Formattable;
import nga.model.SelectableList;
import nga.servlet.config.TargetInfo;
import nga.util.FormatUtil;
import nga.util.MethodOperator;
import nga.util.UserLocale;

public class WriterUtil {
    private WriterUtil() {
    }

    public static String format(Object obj, String format) {
        if (format == null) {
            return WriterUtil.format(obj);
        }
        if (obj instanceof Date) {
            obj = FormatUtil.format((Date)obj, format);
        } else if (obj instanceof BigDecimal) {
            obj = FormatUtil.format((BigDecimal)obj, format);
        } else if (obj instanceof Number) {
            obj = FormatUtil.format(((Number)obj).doubleValue(), format);
        } else if (obj instanceof Formattable) {
            obj = ((Formattable)obj).format(UserLocale.getLocale(), format);
        }
        return WriterUtil.format(obj);
    }

    public static String attr(String attrName, Object obj) {
        if (obj == null || attrName == null) {
            return "";
        }
        return attrName + "=\"" + WriterUtil.format(obj) + "\"";
    }

    public static String attr(String attrName, TargetInfo targetInfo, Object valueObject) {
        return WriterUtil.attr(attrName, targetInfo.getAttribute(attrName, valueObject));
    }

    public static void attr(PrintWriter writer, String attrName, Object obj) {
        WriterUtil.attr(writer, attrName, obj, null);
    }

    public static void attr(PrintWriter writer, String attrName, Object obj, String fmt) {
        if (obj != null && attrName != null) {
            writer.print(" ");
            writer.print(attrName);
            writer.print("=\"");
            if (fmt != null) {
                writer.print(WriterUtil.format(obj, fmt));
            } else {
                writer.print(WriterUtil.format(obj));
            }
            writer.print("\"");
        }
    }

    public static void attr(PrintWriter writer, String attrName, TargetInfo targetInfo, Object valueObject) {
        WriterUtil.attr(writer, attrName, targetInfo, valueObject, null);
    }

    public static void attr(PrintWriter writer, String attrName, TargetInfo targetInfo, Object valueObject, String fmt) {
        WriterUtil.attr(writer, attrName, targetInfo.getAttribute(attrName, valueObject), fmt);
    }

    public static String format(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        block6: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(str.charAt(i));
                }
            }
        }
        return new String(sb);
    }

    public static String format(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return WriterUtil.format((String)obj);
        }
        return WriterUtil.format(obj.toString());
    }

    public static String toSelected(Object list, int index) {
        if (list instanceof SelectableList && ((SelectableList)list).getSelectedIndex() == index) {
            return "selected";
        }
        return "";
    }

    public static String property(String name, Object instance) throws ServletException {
        return WriterUtil.property(name, instance, null);
    }

    public static void property(PrintWriter writer, String name, Object instance) throws ServletException {
        writer.print(WriterUtil.property(name, instance));
    }

    public static String property(String name, Object instance, String format) throws ServletException {
        try {
            return WriterUtil.format(MethodOperator.get(name, instance), format);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getCause());
        }
    }

    public static void property(PrintWriter writer, String name, Object instance, String format) throws ServletException {
        writer.print(WriterUtil.property(name, instance, format));
    }
}

