/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.adapter;

import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import nga.servlet.CongaServlet;
import nga.servlet.ServiceInfo;
import nga.servlet.spi.CongaServletAdapter;

public class InfoLogger
extends CongaServletAdapter {
    private long beginingTime;
    private long checkingTime;

    public void init(CongaServlet servlet) throws ServletException {
        servlet.log("init");
    }

    public void destroy(CongaServlet servlet) {
        servlet.log("destroy");
    }

    public void sessionCreated(ServiceInfo serviceInfo) throws ServletException {
        serviceInfo.getServlet().log("sessionCreated (" + serviceInfo.getSession().getId() + ") " + serviceInfo.getRequestId());
    }

    public void sessionDestroyed(CongaServlet servlet, HttpSession session) {
        servlet.log("sessionDestroyed (" + session.getId() + ")");
    }

    public void begin(ServiceInfo serviceInfo) throws ServletException {
        serviceInfo.getServlet().log("begin: " + serviceInfo.getRequestId());
        this.beginingTime = System.currentTimeMillis();
    }

    public void end(ServiceInfo serviceInfo, String requestId) {
        serviceInfo.getServlet().log("end:   " + requestId + " [" + (System.currentTimeMillis() - this.beginingTime) + "ms]");
    }

    public void abort(ServiceInfo serviceInfo, Throwable exception) throws ServletException {
        serviceInfo.getServlet().log("abort: " + serviceInfo.getRequestId() + " [" + (System.currentTimeMillis() - this.beginingTime) + "ms]");
    }

    public boolean checkParameter(ServiceInfo serviceInfo, Object controller, Method method, Object[] param) throws ServletException {
        serviceInfo.getServlet().log("exec-s:" + serviceInfo.getRequestId() + " (" + method.getDeclaringClass().getName() + "." + method.getName() + ")");
        this.checkingTime = System.currentTimeMillis();
        return true;
    }

    public void editResult(ServiceInfo serviceInfo, Object controller, Method method, Object resultObject) throws ServletException {
        serviceInfo.getServlet().log("exec-e:" + serviceInfo.getRequestId() + " (" + method.getDeclaringClass().getName() + "." + method.getName() + ") [" + (System.currentTimeMillis() - this.checkingTime) + "ms]");
    }

    public void forwarding(ServiceInfo serviceInfo, String oldRequestId, String newRequestId) throws ServletException {
        serviceInfo.getServlet().log("fwd   :" + oldRequestId + " -> " + newRequestId);
    }
}

