/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.Downloader;
import nga.servlet.dsp.writer.TargetValueWriter;
import nga.util.ConfigurationException;
import nga.util.FormatUtil;
import nga.util.MethodOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVDownloader
extends Downloader {
    private QuoteType quoteType = QuoteType.NO;
    private String delimiter = ",";
    private ServletOutputStream outputStream;
    private TargetInfoList targetInfoList;
    private ModuleInfo moduleInfo;

    private void setQuoteType(String type) {
        this.quoteType = "AUTO".equals(type) ? QuoteType.AUTO : ("STRING".equals(type) ? QuoteType.STRING : QuoteType.NO);
    }

    protected void println() throws IOException {
        this.outputStream.println();
    }

    private void print(String text, boolean quote) throws IOException {
        this.outputStream.print(this.convert(text, quote));
        if (this.getDelimiter() != null) {
            this.outputStream.print(this.getDelimiter());
        }
    }

    private String convert(String text, boolean quote) {
        if (text == null) {
            text = "";
        }
        boolean qt = false;
        if (this.quoteType == QuoteType.STRING && quote) {
            qt = true;
        } else if (this.quoteType == QuoteType.NO) {
            qt = false;
        } else if (this.getDelimiter() != null) {
            boolean bl = qt = text.indexOf(this.getDelimiter()) >= 0;
        }
        if (qt) {
            return "\"" + text + "\"";
        }
        return text;
    }

    public void print(String value) throws IOException {
        this.print(value, true);
    }

    public void print(long value) throws IOException {
        this.print(String.valueOf(value), false);
    }

    public void print(double value) throws IOException {
        this.print(String.valueOf(value), false);
    }

    public void print(BigDecimal value) throws IOException {
        if (value == null) {
            this.print("", false);
        } else {
            this.print(value.toString(), false);
        }
    }

    public void print(BigDecimal value, int scale) throws IOException {
        if (value == null) {
            value = new BigDecimal("0");
        }
        this.print(value.setScale(scale, 1).toString(), false);
    }

    public void print(Date value, String fmt) throws IOException {
        if (value == null) {
            this.print("", true);
        } else {
            this.print(FormatUtil.format(value, fmt), true);
        }
    }

    public QuoteType getQuoteType() {
        return this.quoteType;
    }

    protected boolean hasHeader() {
        for (TargetInfo targetInfo : this.targetInfoList) {
            if (TargetValueWriter.getLabel(targetInfo) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void write(ResultInfo resultInfo, ServletOutputStream outputStream, Object resultObject) throws IOException, ServletException {
        this.setDelimiter(resultInfo.get("delimiter", ","));
        this.setQuoteType(resultInfo.get("quote-type", "NO"));
        this.outputStream = outputStream;
        this.moduleInfo = resultInfo.getModuleInfo();
        this.targetInfoList = resultInfo.getTargetInfoList();
        String target = resultInfo.get("target", null);
        if (target != null) {
            resultObject = this.getResultObject(target, resultObject);
        }
        this.print(resultObject);
    }

    private Object getResultObject(String target, Object resultObject) throws ServletException {
        for (TargetInfo info : this.targetInfoList) {
            if (!target.equals(info.getId())) continue;
            try {
                this.targetInfoList = info.getChildren();
                return MethodOperator.get(info.getValue(), resultObject);
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServletException(e.getCause());
            }
        }
        return resultObject;
    }

    protected void print(Object resultObject) throws IOException, ServletException {
        if (this.hasHeader()) {
            this.printHeader();
        }
        this.printDetail(resultObject);
    }

    protected void printHeader() throws IOException, ServletException {
        for (TargetInfo targetInfo : this.targetInfoList) {
            this.print(TargetValueWriter.getLabel(targetInfo));
        }
        this.println();
    }

    protected void printDetail(Object resultObject) throws IOException, ServletException {
        if (resultObject == null) {
            return;
        }
        if (resultObject.getClass().isArray()) {
            this.printArray(resultObject);
        } else {
            if (!(resultObject instanceof List)) {
                throw new ConfigurationException(this.moduleInfo.getMessage("dspm.invalid_list_type", "Object", resultObject.getClass().getName()));
            }
            this.printList((List)resultObject);
        }
    }

    private void printArray(Object resultObject) throws IOException, ServletException {
        Map<String, Method> methodMap = MethodOperator.getGetterMethods(resultObject.getClass().getComponentType());
        int len = Array.getLength(resultObject);
        for (int i = 0; i < len; ++i) {
            this.printLine(methodMap, Array.get(resultObject, i));
            this.println();
        }
    }

    private void printList(List resultObject) throws IOException, ServletException {
        for (int i = 0; i < resultObject.size(); ++i) {
            Object line = resultObject.get(i);
            if (line != null) {
                this.printLine(MethodOperator.getGetterMethods(line.getClass()), line);
            }
            this.println();
        }
    }

    private void printLine(Map<String, Method> methodMap, Object line) throws IOException, ServletException {
        for (int i = 0; i < this.targetInfoList.size(); ++i) {
            TargetInfo ti = (TargetInfo)this.targetInfoList.get(i);
            Object o = null;
            try {
                String valueName = ti.getValue();
                if (valueName != null) {
                    o = MethodOperator.get(methodMap.get(valueName), line);
                }
                if (o == null) {
                    this.print("");
                    continue;
                }
                if (o instanceof String) {
                    this.print((String)o);
                    continue;
                }
                if (o instanceof Date) {
                    this.print((Date)o, TargetValueWriter.getFormat(ti, "yyyy/MM/dd"));
                    continue;
                }
                if (o instanceof BigDecimal) {
                    int scale = TargetValueWriter.getScale(ti);
                    if (scale == -1) {
                        this.print((BigDecimal)o);
                        continue;
                    }
                    this.print((BigDecimal)o, scale);
                    continue;
                }
                this.print(String.valueOf(o), false);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ServletException(e.getCause());
            }
        }
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QuoteType {
        AUTO,
        STRING,
        NO;

    }
}

