/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import nga.model.SelectableList;
import nga.model.SelectableTable;
import nga.servlet.NameUtil;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.TargetValue;
import nga.servlet.dsp.writer.TargetValueWriter;

public class CelcelWriter
extends TargetValueWriter {
    protected TargetInfo tableInfo;
    protected TargetInfoList colInfoList;
    protected String tableName;
    protected List list;
    protected String rowHeight;
    protected String id;
    protected int fixRows;
    protected int fixCols;
    private boolean isSelectableList;
    private boolean isSelectableTable;

    public void writeAttribute() throws IOException, ServletException {
        this.init(this.targetValue);
        this.initFixCells();
        if (this.fixRows > 0) {
            this.attr("fix-rows", this.fixRows);
        }
        if (this.fixCols > 0) {
            this.attr("fix-cols", this.fixCols);
        }
    }

    protected void initFixCells() {
        for (TargetInfo colInfo : this.colInfoList) {
            if (CelcelWriter.getLabel(colInfo) != null && this.fixRows != 1) {
                this.fixRows = 1;
            }
            if (!CelcelWriter.isFixed(colInfo)) continue;
            ++this.fixCols;
        }
    }

    public void write() throws IOException, ServletException {
        this.print("<div").attr("id", this.tableInfo.getId()).println(">");
        if (this.isSelectableList()) {
            this.writeSelectionHolder();
        }
        if (this.fixRows > 0 && this.fixCols > 0) {
            this.writeHeaderTable();
        }
        if (this.fixRows > 0) {
            this.writeColHeaderTable();
        }
        if (this.fixCols > 0) {
            this.writeRowHeaderTable();
        }
        this.writeDetailTable();
        this.print("</div>");
    }

    protected void writeSelectionHolder() {
        this.print("<input").attr("type", "hidden").attr("name", this.tableInfo.getValue()).println(">");
    }

    protected void init(TargetValue resultValue) {
        this.tableInfo = resultValue.getTargetInfo();
        this.colInfoList = this.tableInfo.getChildren();
        this.tableName = this.tableInfo.getValue();
        this.list = (List)resultValue.getValue();
        this.isSelectableList = this.list instanceof SelectableList;
        this.isSelectableTable = this.list instanceof SelectableTable;
        this.rowHeight = CelcelWriter.getRowHeight(this.tableInfo);
        this.id = this.tableInfo.getId();
        this.fixCols = 0;
        this.fixRows = 0;
    }

    protected void writeTableTag(String idSuffix) {
        this.print("<table").attr("id", this.id + idSuffix).println(">");
    }

    protected void writeTableEndTag() {
        this.println("</table>");
    }

    protected void writeColTags(int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            this.print("<col style=\"width:").print(this.getWidth(i)).println("\">");
        }
    }

    protected void writeHeaderTable() {
        this.writeTableTag("-header");
        this.writeColTags(0, 1);
        this.print("<tr><th");
        this.attr("rowspan", this.fixRows);
        this.attr("colspan", this.fixCols);
        this.attr("onclick", "Celcel.header_onclick(event)");
        this.print("></th></tr>");
        this.writeTableEndTag();
    }

    protected void writeCell(Object rowData, TargetInfo colInfo, boolean header, int rowIndex, int colIndex) throws ServletException {
        String propertyName = colInfo.getValue();
        if (header) {
            this.print("<th");
            if (colIndex == 0 && this.isSelectableList()) {
                this.attr("id", this.id + "-" + rowIndex);
                this.attr("onclick", "Celcel.rowHeader_onclick(event)");
            }
        } else {
            this.print("<td");
        }
        this.attr("onmouseover", "Celcel.cell_onmouseover(event)");
        this.attr("class", CelcelWriter.getClass(colInfo)).print(">");
        String propertyValue = propertyName != null ? WriterUtil.property(propertyName, rowData, CelcelWriter.getFormat(colInfo)) : String.valueOf(rowIndex + 1);
        boolean editable = CelcelWriter.isEditable(colInfo);
        if (editable || !header) {
            this.print("<input type=\"text\"");
            this.attr("value", propertyValue);
            if (editable) {
                this.attr("name", NameUtil.name(this.tableName, rowIndex, propertyName));
            } else {
                this.attr("readonly", "readonly");
            }
            this.attr("onkeydown", "Celcel.input_onkeydown(event)");
            this.attr("onfocus", "Celcel.input_onfocus(event)");
            this.attr("onclick", "Celcel.input_onclick(event)");
            this.attr("onmouseover", "Celcel.cell_onmouseover(event)");
            this.print(">");
        } else {
            this.print(propertyValue);
        }
        if (header) {
            this.print("</th>");
        } else {
            this.print("</td>");
        }
    }

    protected void writeTrTag() {
        this.print("<tr style=\"height:").print(this.rowHeight).print("\">");
    }

    protected void writeTrEndTag() {
        this.println("</tr>");
    }

    protected void writeRows(int startRowIndex, int endRowIndex, int startColIndex, int endColIndex, boolean header) throws ServletException {
        for (int i = startRowIndex; i < endRowIndex; ++i) {
            this.writeTrTag();
            Object data = this.list.get(i);
            for (int j = startColIndex; j < endColIndex; ++j) {
                this.writeCell(data, (TargetInfo)this.colInfoList.get(j), header, i, j);
            }
            this.writeTrEndTag();
        }
    }

    protected void writeColHeaderTable() throws ServletException {
        this.writeTableTag("-columnHeader");
        this.writeColTags(this.fixCols, this.colInfoList.size());
        for (int i = this.fixCols; i < this.colInfoList.size(); ++i) {
            TargetInfo colInfo = (TargetInfo)this.colInfoList.get(i);
            this.print("<th");
            if (this.isSelectableTable()) {
                this.attr("id", this.id + "-" + colInfo.getValue());
                this.attr("onclick", "Celcel.columnHeader_onclick(event)");
            }
            this.print(">").format(CelcelWriter.getLabel(colInfo)).print("</th>");
        }
        this.writeTrEndTag();
        this.writeTableEndTag();
    }

    protected void writeRowHeaderTable() throws ServletException {
        this.writeTableTag("-rowHeader");
        this.writeColTags(0, this.fixCols);
        this.writeRows(0, this.list.size(), 0, this.fixCols, true);
        this.writeTableEndTag();
    }

    protected void writeDetailTable() throws ServletException {
        this.writeTableTag("-detail");
        this.writeColTags(this.fixCols, this.colInfoList.size());
        this.writeRows(0, this.list.size(), this.fixCols, this.colInfoList.size(), false);
        this.writeTableEndTag();
    }

    protected String getWidth(int colIndex) {
        return CelcelWriter.getWidth((TargetInfo)this.colInfoList.get(colIndex));
    }

    protected boolean isSelectableList() {
        return this.isSelectableList;
    }

    protected boolean isSelectableTable() {
        return this.isSelectableTable;
    }

    public static boolean isFixed(TargetInfo targetInfo) {
        return targetInfo.get("fixed", false);
    }

    public static String getWidth(TargetInfo targetInfo) {
        return targetInfo.get("width", "20px");
    }

    public static String getRowHeight(TargetInfo targetInfo) {
        return targetInfo.get("row-height", "20px");
    }

    public static boolean isEditable(TargetInfo targetInfo) {
        return targetInfo.get("editable", false);
    }
}

