/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.servlet.dsp.writer.TargetValueWriter;

public class SelectWriter
extends TargetValueWriter {
    public void write() throws IOException, ServletException {
        TargetInfo ti = this.targetValue.getTargetInfo();
        Object resultObject = this.targetValue.getResultObject();
        this.writeSelectTag(ti, resultObject);
        this.writeOptionTags(ti, resultObject);
        this.print("</select>");
    }

    protected void writeSelectTag(TargetInfo ti, Object resultObject) {
        this.print("<select").attr("id", ti.getId()).attr("name", ti.getValue());
        this.attr("class", ti, resultObject);
        if (!ti.getAttribute("visible", resultObject, true)) {
            this.attr("style", "display:none");
        }
        if (ti.getAttribute("disabled", resultObject, false)) {
            this.attr("disabled", "disabled");
        }
        this.attr("size", ti.get("size"));
        Object onchanged = ti.getAttribute("onchanged", resultObject);
        if (onchanged == null) {
            onchanged = ti.getAttribute("onchange", resultObject);
        }
        if (onchanged != null) {
            this.attr("onchange", onchanged);
        } else {
            this.printRequest("request-onchanged", "onchange", ti, resultObject);
        }
        this.print(">");
    }

    protected void writeOptionTags(TargetInfo ti, Object resultObject) {
        TargetInfoList children = ti.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                String value;
                TargetInfo child = (TargetInfo)children.get(i);
                this.print("<option");
                if (child.getAttribute("selected", resultObject, false)) {
                    this.attr("selected", "selected");
                }
                if ((value = child.get("value")) == null) {
                    value = child.get("id");
                }
                if (value == null) {
                    value = String.valueOf(i);
                }
                this.attr("value", value);
                this.print(">");
                this.format(child.get("label"), ti.get("format"));
                this.print("</option>");
            }
        } else {
            List list = (List)this.targetValue.getValue();
            for (int i = 0; i < list.size(); ++i) {
                this.print("<option");
                this.print(WriterUtil.toSelected(list, i));
                this.attr("value", String.valueOf(i));
                this.print(">");
                this.format(list.get(i), ti.get("format"));
                this.print("</option>");
            }
        }
    }
}

