/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet.dsp.writer;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import nga.servlet.ErrorInfo;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.dsp.writer.TargetValue;

public abstract class TargetValueWriter {
    protected TargetValue targetValue;
    protected PrintWriter writer;

    public boolean isCdataSection() {
        return true;
    }

    public void setTargetValue(TargetValue targetValue) {
        this.targetValue = targetValue;
        this.writer = targetValue.getWriter();
    }

    public void writeAttribute() throws IOException, ServletException {
    }

    public abstract void write() throws IOException, ServletException;

    protected Object getErrorValue() {
        ErrorInfo.Item errorItem = this.getErrorItem();
        if (errorItem != null) {
            return errorItem.getValue();
        }
        return null;
    }

    protected ErrorInfo.Item getErrorItem() {
        return (ErrorInfo.Item)this.targetValue.getErrorInfo().get(this.targetValue.getTargetInfo().getValue());
    }

    protected boolean printErrorValue() {
        Object o = this.getErrorValue();
        if (o != null) {
            this.writer.print(WriterUtil.format(o));
            return true;
        }
        return false;
    }

    protected TargetValueWriter println() {
        this.writer.println();
        return this;
    }

    protected TargetValueWriter println(String s) {
        this.writer.println(s);
        return this;
    }

    protected TargetValueWriter print(String s) {
        this.writer.print(s);
        return this;
    }

    protected TargetValueWriter println(Object o) {
        this.writer.println(o);
        return this;
    }

    protected TargetValueWriter print(Object o) {
        this.writer.print(o);
        return this;
    }

    protected TargetValueWriter format(Object o) {
        this.writer.print(WriterUtil.format(o));
        return this;
    }

    protected TargetValueWriter format(Object o, String fmt) {
        this.writer.print(WriterUtil.format(o, fmt));
        return this;
    }

    protected TargetValueWriter attr(String name, Object value) {
        WriterUtil.attr(this.writer, name, value);
        return this;
    }

    protected TargetValueWriter attr(String name, Object value, String fmt) {
        WriterUtil.attr(this.writer, name, value, fmt);
        return this;
    }

    protected TargetValueWriter attr(String name, TargetInfo targetInfo, Object valueObject) {
        WriterUtil.attr(this.writer, name, targetInfo, valueObject);
        return this;
    }

    protected TargetValueWriter attr(String name, TargetInfo targetInfo, Object valueObject, String fmt) {
        WriterUtil.attr(this.writer, name, targetInfo, valueObject, fmt);
        return this;
    }

    protected TargetValueWriter printRequest(String requestConfigAttr, String htmlAttr, TargetInfo targetInfo, Object resultObject) {
        Object request = targetInfo.getAttribute(requestConfigAttr, resultObject);
        if (request != null) {
            this.attr(htmlAttr, "new CongaRequest().send('" + request + "');");
        }
        return this;
    }

    public static String getLabel(TargetInfo targetInfo) {
        return targetInfo.get("label");
    }

    public static String getLabel(TargetInfo targetInfo, Object valueObject) {
        return (String)targetInfo.getAttribute("label", valueObject);
    }

    public static String getFormat(TargetInfo targetInfo, String defaultFormat) {
        return targetInfo.get("format", defaultFormat);
    }

    public static String getFormat(TargetInfo targetInfo) {
        return TargetValueWriter.getFormat(targetInfo, null);
    }

    public static int getScale(TargetInfo targetInfo) {
        return targetInfo.get("scale", -1);
    }

    public static String getClass(TargetInfo targetInfo) {
        return targetInfo.get("class", null);
    }
}

