/*
 * Decompiled with CFR 0.152.
 */
package nga.sql;

import java.sql.Connection;
import nga.sql.Caller;
import nga.sql.Selecter;
import nga.sql.Updater;
import nga.sql.impl.CallerImpl;
import nga.sql.impl.SelecterImpl;
import nga.sql.impl.UpdaterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQL {
    private static boolean debugMode;

    private SQL() {
    }

    public static boolean getDefaultDebugMode() {
        return debugMode;
    }

    public static void setDefaultDebugMode(boolean mode) {
        debugMode = mode;
    }

    public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql) {
        SelecterImpl<R> select = new SelecterImpl<R>(connection, resultClass, sql);
        select.setDebugMode(SQL.getDefaultDebugMode());
        return select;
    }

    public static <R> Selecter<R> createSelecter(Connection connection, Class<? extends R> resultClass, String sql, Object ... parameterObject) {
        SelecterImpl<R> select = new SelecterImpl<R>(connection, resultClass, sql, parameterObject);
        select.setDebugMode(SQL.getDefaultDebugMode());
        return select;
    }

    public static Updater createUpdater(Connection connection, String sql) {
        UpdaterImpl update = new UpdaterImpl(connection, sql);
        update.setDebugMode(SQL.getDefaultDebugMode());
        return update;
    }

    public static Caller createCaller(Connection connection, String sql) {
        CallerImpl caller = new CallerImpl(connection, sql);
        caller.setDebugMode(SQL.getDefaultDebugMode());
        return caller;
    }
}

