/*
 * Decompiled with CFR 0.152.
 */
package nga.sql.impl;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import nga.sql.DuplicatedException;
import nga.sql.Updater;
import nga.sql.impl.SQLImplBase;
import nga.util.ConfigurationException;

public class UpdaterImpl
extends SQLImplBase
implements Updater {
    public UpdaterImpl(Connection con, String sql) {
        super(con, sql);
    }

    public Updater add(String s) {
        return (Updater)((Object)super.handleAdd(s));
    }

    public Updater and(String s) {
        return (Updater)((Object)super.handleAnd(s));
    }

    public Updater or(String s) {
        return (Updater)((Object)super.handleOr(s));
    }

    public int[] execute(List params) throws DuplicatedException, SQLException {
        return this.execute(params, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] execute(List params, int batchSize) throws DuplicatedException, SQLException {
        try {
            if (this.connection.getMetaData().supportsBatchUpdates() && batchSize > 1) {
                int[] nArray = this.executeBatch1(params, batchSize);
                return nArray;
            }
            int[] nArray = this.executeBatch2(params);
            return nArray;
        }
        finally {
            this.close();
        }
    }

    private int[] executeBatch1(List params, int batchSize) throws DuplicatedException, SQLException {
        long startTime = this.start();
        Class<?> c = null;
        if (params.size() > 0) {
            c = params.get(0).getClass();
        }
        int[] rc = new int[params.size()];
        String sql = this.getParsedSQL(c);
        try {
            int[] r;
            PreparedStatement ps = this.prepareStatement(sql);
            for (int i = 0; i < params.size(); ++i) {
                this.setParameter(ps, params.get(i));
                this.printSQL(sql, params.get(i));
                ps.addBatch();
                if (i == 0 || i % batchSize != 0) continue;
                r = ps.executeBatch();
                System.arraycopy(r, 0, rc, i - batchSize, batchSize);
            }
            int rest = (params.size() - 1) % batchSize;
            if (rest > 0) {
                r = ps.executeBatch();
                System.arraycopy(r, 0, rc, rc.length - r.length, r.length);
            }
            int[] nArray = rc;
            return nArray;
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1) {
                throw new DuplicatedException(e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        finally {
            this.end(startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeBatch2(List params) throws DuplicatedException, SQLException {
        long startTime = this.start();
        Class<?> c = null;
        if (params.size() > 0) {
            c = params.get(0).getClass();
        }
        String sql = this.getParsedSQL(c);
        try {
            int[] rc = new int[params.size()];
            for (int i = 0; i < rc.length; ++i) {
                rc[i] = this.execute(params.get(i), sql);
            }
            int[] nArray = rc;
            return nArray;
        }
        finally {
            this.end(startTime);
        }
    }

    public int execute() throws DuplicatedException, SQLException {
        return this.execute((Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object params) throws DuplicatedException, SQLException {
        long startTime = this.start();
        Class<?> c = null;
        if (params != null) {
            c = params.getClass();
        }
        String sql = this.getParsedSQL(c);
        try {
            int n = this.execute(params, sql);
            return n;
        }
        finally {
            this.end(startTime);
            this.close();
        }
    }

    private int execute(Object params, String sql) throws DuplicatedException, SQLException {
        try {
            PreparedStatement ps = this.prepareStatement(sql);
            if (params != null) {
                this.setParameter(ps, params);
            }
            this.printSQL(sql, params);
            return this.executeUpdate(ps, params);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException(e.getCause().getMessage(), e.getCause());
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1) {
                throw new DuplicatedException(e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    protected int executeUpdate(PreparedStatement ps, Object params) throws SQLException, IllegalAccessException, InvocationTargetException {
        return ps.executeUpdate();
    }
}

