/*
 * Decompiled with CFR 0.152.
 */
package nga.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class UserLocale {
    private static ThreadLocal<Locale> userLocale = new ThreadLocal();
    private static Map<Locale, String[]> suffixes = new HashMap<Locale, String[]>();

    public static Locale getLocale() {
        Locale locale = userLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static void setLocale(Locale locale) {
        userLocale.set(locale);
    }

    public static String[] getFileSuffix() {
        Locale locale = UserLocale.getLocale();
        String[] s = suffixes.get(locale);
        if (s == null) {
            s = UserLocale.createFileSuffix(locale);
            suffixes.put(locale, s);
        }
        return s;
    }

    private static String[] createFileSuffix(Locale locale) {
        String[] s;
        s = new String[]{"", "_" + locale.getLanguage(), s[1] + "_" + locale.getCountry()};
        return s;
    }
}

