/**
 * IContainer を作成する。
 * @param htmlElement コンテナに格納する HTML 要素。
 */
function IContainer(htmlElement) {

	//// 変数定義
	var handler = this;

	//// プロパティ定義

	/**
	 * HTML実体要素オブジェクト。
	 */
	this.htmlElement = htmlElement;

	//// public メソッド定義

	/**
	 * 幅設定を行なう。
	 * @param width 幅。
	 */
	this.setWidth = function(width) {
		htmlElement.onresize = null;
		IWidget.setWidth(htmlElement, width);
		return handler;
	}

	/**
	 * 高さ設定を行なう。
	 * @param height 高さ。
	 */
	this.setHeight = function(height) {
		htmlElement.onresize = null;
		IWidget.setHeight(htmlElement, height);
		return handler;
	}

	/**
	 * 幅と高さを設定する。
	 * @param width 幅。
	 * @param height 高さ。
	 */
	this.setSize = function(width, height) {
		handler.setWidth(width);
		handler.setHeight(height);
		return handler;
	}

	this.pack = function() {
		handler.setClientWidth(htmlElement.offsetWidth - IWidget.getMarginWidth(htmlElement));
		handler.setClientHeight(htmlElement.offsetHeight - IWidget.getMarginHeight(htmlElement));
	}

	/**
	 * コンテナ内コンポーネントの幅を設定する。
	 * @param width 幅。
	 * @return 指定された幅が設定できた場合は true。できなかった場合は false。
	 */
	this.setClientWidth = function(width) {
		if(htmlElement.childNodes.length == 1 && 
				htmlElement.firstChild.nodeType==1) {
			return IWidget.setWidth(htmlElement.firstChild, width);
		}
		else {
			return true;
		}
	}

	/**
	 * コンテナ内コンポーネントの高さを設定する。
	 * @param htmlElement 設定するHTML要素。
	 * @param height 高さ。
	 * @return 指定された高さが設定できた場合は true。できなかった場合は false。
	 */
	this.setClientHeight = function(height) {
		if(htmlElement.childNodes.length == 1 && 
				htmlElement.firstChild.nodeType==1) {
			return IWidget.setHeight(htmlElement.firstChild, height);
		}
		else {
			return true;
		}
	}


	//// ローカルメソッド定義

	/**
	 * IContainer を作成する。
	 * @param htmlElement コンテナに格納する HTML 要素。
	 */
	function init() {
		IWidget.initHtmlElement(handler, htmlElement);
		htmlElement.style.overflow = "auto";
		htmlElement.style.width = "100%";
		htmlElement.style.height = "100%";
		htmlElement.onresize = function(event) {
			try{handler.pack();}
			catch(e){}
		}
		handler.pack();
	}


	//// インスタンスの初期化
	init();
}


