/**
 * IDebug。
 */
function IDebug() {

	//// public メソッド定義

	/**
	 * デバッグ出力を行なう。
	 * @param obj 出力内容。
	 */
	IDebug.print = function(obj) {
		var dbg = document.getElementById("_iwidgets_dbg");
		if(!dbg) {
			var debugWindow = new IWindow("debug");
			debugWindow.setContent(
				"<div id='_iwidgets_dbg'></div>"+
				"<input type='button' value='clear' onclick='IDebug.clear()'/>"
			);
			debugWindow.setBounds(600,20,200,200);
			document.getElementById("_iwidgets_dbg").innerHTML = obj;
		}
		else {
			dbg.innerHTML = dbg.innerHTML + "<br>" + obj;
			dbg.parentNode.scrollTop = dbg.parentNode.scrollHeight;
		}
	}

	/**
	 * デバッグ出力のクリアを行なう。
	 */
	IDebug.clear = function () {
		var dbg = document.getElementById("_iwidgets_dbg");
		if(dbg) {
			dbg.innerHTML="";
		}
	}
}
new IDebug();


