/**
 * IResource。
 */
function IResource() {

	//// public メソッド定義

	/**
	 * リソース登録されている値を取得する。
	 * @param key 登録キー。
	 * @param defaultValue 登録されていない場合にデフォルト表示する値。
	 *                    [デフォルト=登録キー]
	 * @return リソース登録されている値。
	 */
	IResource.get = getText;
	IResource.getText = getText;

	/**
	 * メッセージを取得する。
	 * @param key メッセージ登録キー。
	 * @return リソース登録されているメッセージ。
	 */
	IResource.message = getMessage;
	IResource.getMessage = getMessage;

	/**
	 * リソース登録を行なう。
	 * @param key 登録キー。
	 * @param value 登録する値。
	 */
	IResource.add = function(key, value, lang) {
		if(!IResource.resource) {
			IResource.resource = new Array();
		}
		if(!lang) {
			lang = "__"; // デフォルト
		}

		var resource = IResource.resource[lang];
		if(!resource) {
			resource = new Array();
			IResource.resource[lang] = resource;
		}
		resource[key] = value;
	}


	//// ローカルメソッド定義

	/**
	 * リソース登録されている値を取得する。
	 * @param key 登録キー。
	 * @param defaultValue 登録されていない場合にデフォルト表示する値。
	 *                    [デフォルト=登録キー]
	 * @return リソース登録されている値。
	 */
	function getText(key, defaultValue) {
		var lang;
		if(navigator.language) {
			lang = navigator.language.substring(0, 2);
		}
		else {
			lang = navigator.userLanguage.substring(0, 2);
		}

		var resource = IResource.resource[lang];
		if(!resource) {
			resource = IResource.resource["__"]; // デフォルト
		}

		if(resource) {
			if(!defaultValue) {
				defaultValue = key;
			}
			var value = resource[key];
			if(!value) {
				value = IResource.resource["__"][key]
			}
			return (value)? value : defaultValue;
		}
		else {
			return key;
		}
	}


	/**
	 * メッセージを取得する。
	 * @param key メッセージ登録キー。
	 * @return リソース登録されているメッセージ。
	 */
	function getMessage(key) {
		var text = getText(key);
		if(arguments.length > 1) {
			for(var i=1; i<arguments.length; i++) {
				text = text.replace("%"+i, arguments[i]);
			}
		}
		return text;
	}
}
new IResource();


