package nga.model;

import java.util.ArrayList;
import java.util.List;

/**
 * c[m[hB
 */
public class TreeNode<T> {

	/**
	 * c[B
	 */
	private final Tree<T> tree;

	/**
	 * m[hIDB
	 */
	private String id;
	
	/**
	 * m[h̒lB
	 */
	private T nodeValue;
	
	/**
	 * em[hB
	 */
	private TreeNode<T> parent;

	/**
	 * qm[hB
	 */
	private List<TreeNode<T>> children = new ArrayList<TreeNode<T>>();
	
	/**
	 * tm[hǂB
	 */
	private boolean leaf;
	
	/**
	 * I[vĂ邩ǂB
	 */
	private boolean opened;

	/**
	 * qm[h[hς݂ǂB
	 */
	private boolean loaded;
	
	/**
	 * m[h^CvB
	 */
	private String nodeType;

	/**
	 * TreeNode 쐬B
	 * @param tree c[B
	 * @param id m[hIDB
	 * @param nodeValue m[h̒lB
	 * @param leaf tm[hǂB
	 */
	TreeNode(Tree<T> tree, String id, T nodeValue, boolean leaf) {
		this.tree = tree;
		this.id = id;
		this.nodeValue = nodeValue;
		this.leaf = leaf;
	}
	
	/**
	 * m[h̒l擾B
	 * @return m[h̒lB
	 */
	public T getNodeValue() {
		return nodeValue;
	}

	/**
	 * m[h ID 擾B
	 * @return m[hIDB
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * qm[hǉB
	 * @param node ǉqm[hB
	 */
	public void add(TreeNode<T> node) {
		node.parent = this;
		children.add(node);
	}

	/**
	 * qm[h쐬ĒǉB
	 * node.add(tree.createNode(nodeValue, false)) ̃V[gJbgB
	 * @param nodeValue ǉqm[h̒lB
	 * @return 쐬qm[hB
	 */
	public TreeNode<T> add(T nodeValue) {
		return add(nodeValue, false);
	}

	/**
	 * qm[h쐬ĒǉB
	 * node.add(tree.createNode(nodeValue, leaf)) ̃V[gJbgB
	 * @param nodeValue ǉqm[h̒lB
	 * @param leaf tm[hǂB
	 * @return 쐬qm[hB
	 */
	public TreeNode<T> add(T nodeValue, boolean leaf) {
		TreeNode<T> node = this.tree.createNode(nodeValue, leaf);
		add(node);
		return node;
	}

	/**
	 * qm[h擾B
	 * @return qm[hB
	 */
	public List<TreeNode<T>> getChildren() {
		return children;
	}
	
	/**
	 * em[h擾B
	 * @return em[hB
	 */
	public TreeNode<T> getParent() {
		return parent;
	}
	
	/**
	 * ̃m[htm[hǂB
	 * @return tm[h̏ꍇ trueB
	 */
	public boolean isLeaf() {
		return leaf;
	}
	
	/**
	 * qm[hǂB
	 * @return qm[hꍇ trueB
	 */
	public boolean hasChildren() {
		return !children.isEmpty();
	}
	
	/**
	 * qm[h̃[hς݃tOZbgB
	 */
	public void setLoaded() {
		loaded = true;
	}
	
	/**
	 * qm[h[hς݂ǂ𒲂ׂB<br>
	 * setLoaded() ĂяoꂽCqm[h݂ꍇ true ԂB
	 * ܂Ctm[hꍇ true ԂB
	 */
	public boolean isLoaded() {
		return isLeaf() || hasChildren() || loaded;
	}
	
	/**
	 * m[h^Cvݒ肷B
	 * @param nodeType m[h^CvB
	 */
	public void setNodeType(String nodeType) {
		this.nodeType = nodeType;
	}
	
	/**
	 * m[h^Cv擾B
	 * @return m[h^CvB
	 */
	public String getNodeType() {
		return nodeType;
	}
	
	/**
	 * I[vĂ邩ǂԂB
	 * @return I[vĂ邩ǂB
	 */
	public boolean isOpened() {
		return opened;
	}

	/**
	 * I[vĂ邩ǂݒ肷B
	 * @param opened I[vĂ邩ǂB
	 */
	public void setOpened(boolean opened) {
		if(!isLeaf()) {
			this.opened = opened;
		}
	}
	
	/**
	 * ̃m[hIB
	 */
	public void select() {
		setOpened(!isOpened());
	}
	
	/**
	 * ̃m[h[gm[hǂ𒲂ׂB
	 * @return [gm[h̏ꍇ trueB
	 */
	public boolean isRootNode() {
		return tree.getRootNode()==this;
	}

}