/*
 *WriterUtil.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Date;

import javax.servlet.ServletException;

import nga.model.Formattable;
import nga.model.SelectableList;
import nga.servlet.config.TargetInfo;
import nga.util.FormatUtil;
import nga.util.MethodOperator;
import nga.util.UserLocale;

/**
 * C^ / JSP p[eBeBB
 */
public class WriterUtil {

	/**
	 * WriterUtil 쐬B
	 */
	private WriterUtil() {
	}

	/**
	 * w肳ꂽIuWFNg {@link nga.model.Formattable },Numbar, Date ŁC format Ɏw肳ꂽ
	 *  null łȂꍇCw肳ꂽŕϊĕԂB
	 * ȊȌꍇ́C{@link #format(Object)} ̌ʂԂB
	 * @param obj ϊIuWFNgB
	 * @param format B
	 * @return ϊʁB
	 */
	public static String format(Object obj, String format){
		if(format==null) {
			return format(obj);
		}
		
		if(obj instanceof Date) {
			obj = FormatUtil.format((Date)obj, format);
		}
		else if(obj instanceof BigDecimal) {
			obj = FormatUtil.format((BigDecimal)obj, format);
		}
		else if(obj instanceof Number) {
			obj = FormatUtil.format(((Number)obj).doubleValue(), format);
		}
		else if(obj instanceof Formattable) {
			obj = ((Formattable)obj).format(UserLocale.getLocale(), format);
		}
		
		return format(obj);
	}
	
	/**
	 * iattrName="obj" `̕jԂB
	 * attrName  obj  null ̏ꍇ "" ԂB
	 * @param attrName B
	 * @param obj LqeB
	 * @return (attrName="obj") `̕
	 */
	public static String attr(String attrName, Object obj) {
		if(obj==null || attrName==null) {
			return "";
		}
		else {
			return attrName + "=\"" + format(obj) + "\"";
		}
	}
	
	/**
	 * iattrName="obj" `̕jԂB
	 * obj  {@link TargetInfo#getAttribute(String, Object) targetInfo.getAttribute(attrName, valueObject)}
	 * ̌ʂgpB
	 * attrName  obj  null ̏ꍇ "" ԂB
	 * @param attrName B
	 * @param targetInfo target ^OB
	 * @param valueObject lIuWFNgB
	 * @return (attrName="obj") `̕
	 */
	public static String attr(String attrName, TargetInfo targetInfo, Object valueObject) {
		return attr(attrName, targetInfo.getAttribute(attrName, valueObject));
	}
	
	/**
	 * i attrName="obj" `̕jo͂B
	 * attrName  obj  null ̏ꍇ͉o͂ȂB
	 * @param writer o͐B
	 * @param attrName B
	 * @param obj LqeB
	 */
	public static void attr(PrintWriter writer, String attrName, Object obj) {
		attr(writer, attrName, obj, null);
	}

	/**
	 * i attrName="obj" `̕jo͂B
	 * attrName  obj  null ̏ꍇ͉o͂ȂB
	 * @param writer o͐B
	 * @param attrName B
	 * @param obj LqeB
	 * @param fmt B
	 */
	public static void attr(PrintWriter writer, String attrName, Object obj, String fmt) {
		if(obj!=null && attrName!=null) {
			writer.print(" ");
			writer.print(attrName);
			writer.print("=\"");
			if(fmt!=null) {
				writer.print(format(obj, fmt));
			}
			else {
				writer.print(format(obj));
			}
			writer.print("\"");
		}
	}

	/**
	 * iattrName="obj" `̕jo͂B
	 * obj  {@link TargetInfo#getAttribute(String, Object) targetInfo.getAttribute(attrName, valueObject)}
	 * ̌ʂgpB
	 * attrName  obj  null ̏ꍇ "" ԂB
	 * @param writer o͐B
	 * @param attrName B
	 * @param targetInfo target ^OB
	 * @param valueObject lIuWFNgB
	 */
	public static void attr(PrintWriter writer, String attrName, TargetInfo targetInfo, Object valueObject) {
		attr(writer, attrName, targetInfo, valueObject, null);
	}
	
	/**
	 * iattrName="obj" `̕jo͂B
	 * obj  {@link TargetInfo#getAttribute(String, Object) targetInfo.getAttribute(attrName, valueObject)}
	 * ̌ʂgpB
	 * attrName  obj  null ̏ꍇ "" ԂB
	 * @param writer o͐B
	 * @param attrName B
	 * @param targetInfo target ^OB
	 * @param valueObject lIuWFNgB
	 */
	public static void attr(PrintWriter writer, String attrName, TargetInfo targetInfo, Object valueObject, String fmt) {
		attr(writer, attrName, targetInfo.getAttribute(attrName, valueObject), fmt);
	}
	
	/**
	 * w肳ꂽ̒Ɋ܂܂
	 * ' ', '<', '>', '&', '"'  &nbsp;, &lt;, &gt;, &amp;, &quot; ɕϊB
	 * w肳ꂽ null ̏ꍇ́C"" ɕϊB
	 * @param str ϊ镶B
	 * @return ϊʁB
	 */
	public static String format(String str){
		if(str==null) {
			return "";
		}
	
		StringBuilder sb = new StringBuilder();
		int len = str.length();
		for(int i=0; i<len; i++){
			switch(str.charAt(i)){
				case '<' :
					sb.append("&lt;");
					break;
				case '>' :
					sb.append("&gt;");
					break;
				case '&' :
					sb.append("&amp;");
					break;
				case '\"' :
					sb.append("&quot;");
					break;
				default :
					sb.append(str.charAt(i));
				break;
			}
		}
		return new String(sb);
	}

	/**
	 * w肳ꂽIuWFNg̏ꍇC̒̕Ɋ܂܂
	 * ' ', '<', '>', '&', '"'  &nbsp;, &lt;, &gt;, &amp;, &quot; ɕϊB
	 * w肳ꂽIuWFNg null ̏ꍇ́C"" ɕϊB
	 * w肳ꂽIuWFNgłȂꍇ́CtoString() ĂL̕ϊsȂBB
	 * @param obj ϊIuWFNgB
	 * @return ϊʁB
	 */
	public static String format(Object obj) {
		if(obj==null) {
			return "";
		}
		else if(obj instanceof String) {
			return format((String)obj);
		}
		else {
			return format(obj.toString());
		}
	}
	
	/**
	 * w肳ꂽ list  SelectableList ŁCCindex==list.getSelectedIndex()
	 * ̏ꍇɂ "selected" ƂԂB
	 * ȊȌꍇ "" ԂB
	 * @param list
	 * @param index
	 * @return "selected" ܂ ""B
	 */
	@SuppressWarnings("unchecked")
	public static String toSelected(Object list, int index) {
		if(list instanceof SelectableList) {
			if(((SelectableList)list).getSelectedIndex()==index) {
				return "selected";
			}
		}
		return "";
	}
	
	/**
	 * w肳ꂽIuWFNgCX^X̒w肳ꂽÕvpeB擾B
	 * 擾ʂ {@link #format(Object)} ĕԂB
	 * @param name vpeBB
	 * @param instance IuWFNgCX^XB
	 * @return 擾lB
	 */
	public static String property(String name, Object instance) throws ServletException {
		return property(name, instance, null);
	}

	/**
	 * w肳ꂽIuWFNgCX^X̒w肳ꂽÕvpeB擾C
	 * 擾ʂ {@link #format(Object, String)} ďo͂B
	 * @param writer o͐B
	 * @param name vpeBB
	 * @param instance IuWFNgCX^XB
	 */
	public static void property(PrintWriter writer, String name, Object instance) throws ServletException {
		writer.print(property(name, instance));
	}

	/**
	 * w肳ꂽIuWFNgCX^X̒w肳ꂽÕvpeB擾C
	 * 擾ʂ {@link #format(Object, String)} ĕԂB
	 * @param name vpeBB
	 * @param instance IuWFNgCX^XB
	 * @param format B
	 * @return 擾lB
	 */
	public static String property(String name, Object instance, String format) throws ServletException {
		try {
			return format(MethodOperator.get(name, instance), format);
		}
		catch (IllegalAccessException e) {
			throw new ServletException(e);
		}
		catch (InvocationTargetException e) {
			throw new ServletException(e.getCause());
		}
	}

	/**
	 * w肳ꂽIuWFNgCX^X̒w肳ꂽÕvpeB擾C
	 * 擾ʂ {@link #format(Object, String)} ďo͂B
	 * @param writer o͐B
	 * @param name vpeBB
	 * @param instance IuWFNgCX^XB
	 * @param format B
	 */
	public static void property(PrintWriter writer, String name, Object instance, String format) throws ServletException {
		writer.print(property(name, instance, format));
	}
}
