/*
 *PropertyValueParserCollection.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;


import nga.model.UpdatableByText;
import nga.servlet.ErrorInfo;
import nga.servlet.config.PropertyInfo;
import nga.util.FormatUtil;

/**
 * PropertyValueParser WB
 */
public class PropertyValueParserCollection {

	/** String p PropertyValueParser */
	public static final PropertyValueParser FOR_STRING = new StringPropertyParser();

	/** Charactor, char p PropertyValueParser */
	public static final PropertyValueParser FOR_CHARACTOR = new CharactorPropertyParser();

	/** Boolean, boolean p PropertyValueParser */
	public static final PropertyValueParser FOR_BOOLEAN = new BooleanPropertyParser();
	
	/** Integer, int p PropertyValueParser */
	public static final PropertyValueParser FOR_INTEGER = new IntegerPropertyParser();

	/** Long, long p PropertyValueParser */
	public static final PropertyValueParser FOR_LONG = new LongPropertyParser();

	/** Short, shortp PropertyValueParser */
	public static final PropertyValueParser FOR_SHORT = new ShortPropertyParser();

	/** Byte, byte p PropertyValueParser */
	public static final PropertyValueParser FOR_BYTE = new BytePropertyParser();

	/** Float, float p PropertyValueParser */
	public static final PropertyValueParser FOR_FLOAT = new FloatPropertyParser();

	/** Double, double p PropertyValueParser */
	public static final PropertyValueParser FOR_DOUBLE = new DoublePropertyParser();

	/** BigDecimal p PropertyValueParser */
	public static final PropertyValueParser FOR_BIGDECIMAL = new BigDecimalPropertyParser();

	/** BigInteger p PropertyValueParser */
	public static final PropertyValueParser FOR_BIGINTEGER = new BigIntegerPropertyParser();

	/** java.util.Date p PropertyValueParser */
	public static final PropertyValueParser FOR_DATE = new DatePropertyParser();

	/** java.sql.Date p PropertyValueParser */
	public static final PropertyValueParser FOR_SQLDATE = new SqlDatePropertyParser();
	
	/** java.sql.Time p PropertyValueParser */
	public static final PropertyValueParser FOR_SQLTIME = new SqlTimePropertyParser();

	/** java.sql.Timestamp p PropertyValueParser */
	public static final PropertyValueParser FOR_SQLTIMESTAMP = new SqlTimestampPropertyParser();

	/** UpdatableByText p PropertyValueParser */
	public static final PropertyValueParser FOR_TEXTCONVERTIBLE = new TextConvertibleParser();


	/**
	 * PropertyValueParserCollection 쐬B
	 */
	public PropertyValueParserCollection() {
	}

	/** String p PropertyValueParser */
	public static class StringPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			if(!checkRequired(pv)) {
				return false;
			}
			
			String value = pv.getValue();
			if(value==null || value.length()==0) {
				pv.setObject(null);
				return true;
			}

			// 񒷃`FbN
			if(!checkLength(pv)) {
				return false;
			}
			
			// oCg`FbN
			if(!checkByteLength(pv)) {
				return false;
			}

			// `FbN
			if(!checkCharType(pv)) {
				return false;
			}

			pv.setObject(value);
			return true;
		}
	}

	/** Charactor, char p PropertyValueParser */
	public static class CharactorPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			if(!checkRequired(pv)) {
				return false;
			}

			String value = pv.getValue();
			if(value==null || value.length()==0) {
				pv.setObject(null);
				return true;
			}

			// `FbN
			if(!checkCharType(pv)) {
				return false;
			}
			
			pv.setObject(value.charAt(0));
			return true;
		}
	}


	/** Boolean, boolean p PropertyValueParser */
	public static class BooleanPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			if(value==null) {
				pv.setObject(Boolean.FALSE);
				return true;
			}
			else {
				pv.setObject(Boolean.valueOf(value));
				return true;
			}
		}
	}
	
	/** Integer, int p PropertyValueParser */
	public static class IntegerPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new Integer(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** Long, long p PropertyValueParser */
	public static class LongPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new Long(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** Short, shortp PropertyValueParser */
	public static class ShortPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new Short(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** Byte, byte p PropertyValueParser */
	public static class BytePropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new Byte(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** Float, float p PropertyValueParser */
	public static class FloatPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new Float(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** Double, double p PropertyValueParser */
	public static class DoublePropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new Double(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** BigDecimal p PropertyValueParser */
	public static class BigDecimalPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new BigDecimal(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** BigInteger p PropertyValueParser */
	public static class BigIntegerPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			String value = pv.getValue();
			String s = delC(value);
			try {
				if(checkNum(pv)) {
					pv.setObject((s!=null)? new BigInteger(s) : null);
					return true;
				}
				else {
					return false;
				}
			}
			catch(NumberFormatException e) {
				return handleNumberFormatException(pv);
			}
		}
	}

	/** java.util.Date p PropertyValueParser */
	public static class DatePropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			return toDate(pv, "yyyy/MM/dd");
		}
	}

	/** java.sql.Date p PropertyValueParser */
	public static class SqlDatePropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			if(toDate(pv, "yyyy/MM/dd")) {
				pv.setObject(FormatUtil.toDate((java.util.Date)pv.getObject()));
				return true;
			}
			else {
				return false;
			}
		}
	}

	/** java.sql.Time p PropertyValueParser */
	public static class SqlTimePropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			if(toDate(pv, "HH:mm")) {
				pv.setObject(FormatUtil.toTime((java.util.Date)pv.getObject()));
				return true;
			}
			else {
				return false;
			}
		}
	}

	/** java.sql.Timestamp p PropertyValueParser */
	public static class SqlTimestampPropertyParser extends PropertyValueParser {
		public boolean parse(PropertyValue pv) {
			if(toDate(pv, "yyyy/MM/dd HH:mm:ss.SSS")) {
				pv.setObject(FormatUtil.toTimestamp((java.util.Date)pv.getObject()));
				return true;
			}
			else {
				return false;
			}
		}
	}
	/** UpdatableByText p PropertyValueParser */
	public static class TextConvertibleParser extends PropertyValueParser {

		public boolean parse(PropertyValue pv) {
			if(!checkRequired(pv)) {
				return false;
			}
			
			String value = pv.getValue();
			if(value==null || value.length()==0) {
				return true;
			}
			
			try {
				((UpdatableByText)pv.getObject()).update(value);
			}
			catch (ParseException e) {
				PropertyInfo constraints = pv.getPropertyInfo();
				ErrorInfo errorInfo = pv.getErrorInfo();
				String name = pv.getName();
				String label = getLabel(constraints);
				if(label!=null) {
					errorInfo.add(name, value, "dspm.cannot_text_convert2", value, label);
				}
				else {
					errorInfo.add(name, value, "dspm.cannot_text_convert1", value);
				}
				return false;
			}

			return true;
		}
	}
}
