/*
 *CelcelWriter.java
 *
 * Copyright (C) 2005 TEAM NGA
 *
 * ̃\[XR[hƁC̃\[XR[h琶ꂽhLg
 * ̃\[XR[hRpCč쐬ꂽoCit@Cgp
 * ۂɂ͈ȉ̎gpɏ]Kv܂B
 *
 *
 * [gp]
 *
 *   ȉł́Cu\[XR[hvCu\[XR[h琶ꂽhL
 * gvCu\[XR[hRpCč쐬ꂽoCit@Cv̎O
 * ҂uCuvƌĂт܂BƂC\[XR[hP̂Ŏs\
 * ̂łꍇłCł́uCuvƌĂт܂B
 *   ̎gp̑ΏۂƂȂugpvƂ́CuCuv̕EzzE
 * ύXCuCuvgAvP[V̊JCuCuv
 * sCuCuvɊւ؂̊̂Ƃ\܂B
 *   ̎gpɂċ󂯂҂ugpҁvĂт܂B
 *
 * (1)
 *   uCuvɂ͈؂̕ۏ؂܂Bgp҂͎gp҂
 *   uCuvzzꂽO҂ɂuCuv̎gpC܂
 *   uCuvgpč쐬ꂽAvP[VCVXe̎g
 *   pɂ蔭Ȃ鑹Qɑ΂Ă쌠҂͈ؐӔC𕉂܂
 *   B̑Qɑ΂Ăׂ͂Ďgp҂ӔC𕉂̂Ƃ܂B
 *
 * (2)
 *   ̎gp҂ƒ쌠҂uCuvgp邱ƂCgp҂W
 *   Ă͂Ȃ܂B
 *
 * (3)
 *   gp҂́uCuv̕EύXEzzRɍsƂł܂B
 *                                                                 ȏ
 */

package nga.servlet.dsp.writer;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;

import nga.model.SelectableList;
import nga.model.SelectableTable;
import nga.servlet.NameUtil;
import nga.servlet.WriterUtil;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;

/**
 * Celcel pC^B
 */
public class CelcelWriter extends TargetValueWriter {

	/**
	 * e[uB
	 */
	protected TargetInfo tableInfo;
	
	/**
	 * ̃XgB
	 */
	protected TargetInfoList colInfoList;

	/**
	 * e[uB
	 */
	protected String tableName;
	
	/**
	 * s̃XgB
	 */
	protected List list;
	
	/**
	 * s̍B
	 */
	protected String rowHeight;
	
	/**
	 * o͐IDB
	 */
	protected String id;
	
	/**
	 * ŒsB
	 */
	protected int fixRows;
	
	/**
	 * Œ񐔁B
	 */
	protected int fixCols;
	
	/**
	 * o͑Ώےl SelectableList ̃CX^XǂB
	 */
	private boolean isSelectableList;
	
	/**
	 * o͑Ώےl SelectableTable ̃CX^XǂB
	 */
	private boolean isSelectableTable;
	
	
	/**
	 * CelcelWriter 쐬B
	 */
	public CelcelWriter() {
	}
	
	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#writeAttribute(nga.servlet.dsp.writer.TargetValue)
	 */
	@Override
	public void writeAttribute() throws IOException, ServletException {
		init(targetValue);

		initFixCells();

		if(fixRows > 0) {
			attr("fix-rows", fixRows);
		}

		if(fixCols > 0) {
			attr("fix-cols", fixCols);
		}
	}
	
	/**
	 * ŒsCŒ񐔂ݒ肷B
	 */
	protected void initFixCells() {
		for(TargetInfo colInfo : colInfoList) {
			if(getLabel(colInfo)!=null) {
				if(fixRows!=1) {
					fixRows = 1; // 񃉃xw肳ĂΌŒsƂďo͂B
				}
			}
			if(isFixed(colInfo)) {
				fixCols++;
			}
		}
		
	}

	/* (non-Javadoc)
	 * @see nga.servlet.dsp.writer.TargetValueWriter#write(nga.servlet.dsp.writer.TargetValue)
	 */
	@Override
	public void write() throws IOException, ServletException {
		print("<div").attr("id", tableInfo.getId()).println(">");
		if(isSelectableList()) {
			writeSelectionHolder();
		}

		if(fixRows > 0 && fixCols > 0) {
			writeHeaderTable();
		}
		if(fixRows > 0) {
			writeColHeaderTable();
		}
		if(fixCols > 0) {
			writeRowHeaderTable();
		}
		writeDetailTable();
		print("</div>");
	}
	
	/**
	 * SelectionHolder o͂B
	 */
	protected void writeSelectionHolder() {
		print("<input").attr("type", "hidden").attr("name", tableInfo.getValue()).println(">");
	}

	/**
	 * ̃CX^X̏sȂB
	 * @param resultValue o͏B
	 */
	protected void init(TargetValue resultValue) {
		tableInfo = resultValue.getTargetInfo();
		colInfoList = tableInfo.getChildren();

		tableName = tableInfo.getValue();
		list = (List)resultValue.getValue();
		isSelectableList = list instanceof SelectableList;
		isSelectableTable = list instanceof SelectableTable;
		rowHeight = getRowHeight(tableInfo);
		id = tableInfo.getId();
		fixCols = 0;
		fixRows = 0;
	}
	
	/**
	 * table ^Ȍo͂sȂB
	 * @param idSuffix id ̖ɕt^镶B
	 */
	protected void writeTableTag(String idSuffix) {
		print("<table").attr("id", id + idSuffix).println(">");
	}
	
	/**
	 * table I^Ȍo͂sȂB
	 */
	protected void writeTableEndTag() {
		println("</table>");
	}
	
	/**
	 * col ^Ȍo͂sȂB
	 * @param startIndex JnCfbNXi܂ށjB
	 * @param endIndex ICfbNXi܂܂ȂjB
	 */
	protected void writeColTags(int startIndex, int endIndex) {
		for(int i=startIndex; i < endIndex; i++) {			
			print("<col style=\"width:").print(getWidth(i)).println("\">");
		}
	}
	
	/**
	 * Œwb_e[ȕo͂sȂB
	 */
	protected void writeHeaderTable() {
		writeTableTag("-header");
		writeColTags(0, 1);

		print("<tr><th");
		attr("rowspan", fixRows);
		attr("colspan", fixCols);
		attr("onclick", "Celcel.header_onclick(event)");
		print("></th></tr>");

		writeTableEndTag();
	}

	/**
	 * Z̏o͂sȂB
	 * @param rowData sf[^B
	 * @param colInfo B
	 * @param header wb_ZǂB
	 * @param rowIndex sCfbNXB
	 * @param colIndex CfbNXB
	 */
	@SuppressWarnings("unusedArgument")
	protected void writeCell(Object rowData, TargetInfo colInfo, boolean header, int rowIndex, int colIndex) throws ServletException {
		String propertyName = colInfo.getValue();

		if(header) {
			print("<th");
			if(colIndex==0 && isSelectableList()) {
				attr("id", id + "-" + rowIndex);
				attr("onclick", "Celcel.rowHeader_onclick(event)");
			}
		}
		else {
			print("<td");
		}

		attr("onmouseover", "Celcel.cell_onmouseover(event)");
		attr("class", getClass(colInfo)).print(">");

		String propertyValue;
		if(propertyName!=null) {
			propertyValue = WriterUtil.property(propertyName, rowData, getFormat(colInfo));
		}
		else { // propertyName ݒ肳ĂȂꍇ͍sԍlƂB
			propertyValue = String.valueOf(rowIndex + 1);
		}
		boolean editable = isEditable(colInfo);
		
		if(editable || !header) {
			print("<input type=\"text\"");
			attr("value", propertyValue);
			if(editable) {
				attr("name", NameUtil.name(tableName, rowIndex, propertyName));
			}
			else {
				attr("readonly", "readonly");
			}
			attr("onkeydown", "Celcel.input_onkeydown(event)");
			attr("onfocus", "Celcel.input_onfocus(event)");
			attr("onclick", "Celcel.input_onclick(event)");
			attr("onmouseover", "Celcel.cell_onmouseover(event)");
			print(">");
		}
		else {
			print(propertyValue);					
		}

		if(header) {
			print("</th>");
		}
		else {
			print("</td>");
		}
		
	}
	
	/**
	 * tr Jn^Ȍo͂sȂB
	 */
	protected void writeTrTag() {		
		print("<tr style=\"height:").print(rowHeight).print("\">");
	}
	
	/**
	 * tr I^Ȍo͂sȂB
	 */
	protected void writeTrEndTag() {
		println("</tr>");		
	}
	
	/**
	 * so͂sȂB
	 * @param startRowIndex JnsCfbNXi܂ށjB
	 * @param endRowIndex IsCfbNXi܂܂ȂjB
	 * @param startColIndex JnCfbNXi܂ށjB
	 * @param endColIndex ICfbNXi܂܂ȂjB
	 * @param header wb_o͂ǂB
	 */
	@SuppressWarnings("unchecked")
	protected void writeRows(int startRowIndex, int endRowIndex, int startColIndex, int endColIndex, boolean header) throws ServletException {
		for(int i = startRowIndex; i < endRowIndex; i++) {
			writeTrTag();

			Object data = list.get(i);
			for(int j = startColIndex; j < endColIndex; j++) {
				writeCell(data, colInfoList.get(j), header, i, j);
			}
			
			writeTrEndTag();
		}
	}

	/**
	 * wb_e[ȕo͂sȂB
	 */
	@SuppressWarnings("unusedThrown")
	protected void writeColHeaderTable() throws ServletException {
		writeTableTag("-columnHeader");
		writeColTags(fixCols, colInfoList.size());

		for(int i = fixCols; i < colInfoList.size(); i++) {
			TargetInfo colInfo = colInfoList.get(i);
			print("<th");
			if(isSelectableTable()) {
				attr("id", id + "-" + colInfo.getValue());
				attr("onclick", "Celcel.columnHeader_onclick(event)");
			}
			print(">").format(getLabel(colInfo)).print("</th>");
		}

		writeTrEndTag();
		writeTableEndTag();
	}

	/**
	 * swb_̏o͂sȂB
	 */
	protected void writeRowHeaderTable() throws ServletException {
		writeTableTag("-rowHeader");
		writeColTags(0, fixCols);
		writeRows(0, list.size(), 0, fixCols, true);
		writeTableEndTag();
	}

	/**
	 * ׂ̏o͂sȂB
	 */
	protected void writeDetailTable() throws ServletException {
		writeTableTag("-detail");
		writeColTags(fixCols, colInfoList.size());
		writeRows(0, list.size(), fixCols, colInfoList.size(), false);
		writeTableEndTag();
	}

	/**
	 * w肳ꂽ̗񕝂擾B
	 * @param colIndex ԍB
	 * @return 񕝁B
	 */
	protected String getWidth(int colIndex) {
		return getWidth(colInfoList.get(colIndex));
	}
	
	/**
	 * o͑Ώےl SelectableList ̃CX^Xǂ𒲂ׂB
	 * @return o͑Ώےl SelectableList ̃CX^XȂ trueB
	 */
	protected boolean isSelectableList() {
		return isSelectableList;
	}
	
	/**
	 * o͑Ώےl SelectableTable ̃CX^Xǂ𒲂ׂB
	 * @return o͑Ώےl SelectableTable ̃CX^XȂ trueB
	 */
	protected boolean isSelectableTable() {
		return isSelectableTable;
	}

	/**
	 * Œ񂩂ǂ擾BB
	 * @param targetInfo target ^OB
	 * @return Œ̏ꍇ trueB
	 */
	public static boolean isFixed(TargetInfo targetInfo) {
		return targetInfo.get("fixed", false);
	}

	/**
	 * 񕝂擾B
	 * @param targetInfo target ^OB
	 * @return 񕝁B
	 */
	public static String getWidth(TargetInfo targetInfo) {
		return targetInfo.get("width", "20px");
	}
	
	/**
	 * s̍擾B
	 * @param targetInfo target ^OB
	 * @return 񕝁B
	 */
	public static String getRowHeight(TargetInfo targetInfo) {
		return targetInfo.get("row-height", "20px");
	}
	
	/**
	 * ҏW\񂩂ǂ擾B
	 * @param targetInfo target ^OB
	 * @return ҏW\̏ꍇ trueB
	 */
	public static boolean isEditable(TargetInfo targetInfo) {
		return targetInfo.get("editable", false);
	}
	
}
